/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v3_4_2;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalServiceUtil;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.layout.responsive.ViewportSize;
import com.liferay.layout.util.structure.ColumnLayoutStructureItem;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LayoutPageTemplateStructureRelUpgradeProcess
extends UpgradeProcess {
    private static final String[] _ALIGN_KEYS = new String[]{"buttonAlign", "contentAlign", "imageAlign", "textAlign"};
    private static final Map<String, String> _borderRadiuses = HashMapBuilder.put((Object)"lg", (Object)"0.375rem").put((Object)"none", (Object)"").put((Object)"sm", (Object)"0.1875rem").build();
    private static final Map<String, String> _colors = HashMapBuilder.put((Object)"danger", (Object)"#DA1414").put((Object)"dark", (Object)"#272833").put((Object)"gray-dark", (Object)"#393A4A").put((Object)"info", (Object)"#2E5AAC").put((Object)"light", (Object)"#F1F2F5").put((Object)"lighter", (Object)"#F7F8F9").put((Object)"primary", (Object)"#0B5FFF").put((Object)"secondary", (Object)"#6B6C7E").put((Object)"success", (Object)"#287D3C").put((Object)"warning", (Object)"#B95000").put((Object)"white", (Object)"#FFFFFF").build();
    private static final Map<String, String> _shadows = HashMapBuilder.put((Object)"lg", (Object)"0 1rem 3rem rgba(0, 0, 0, .175)").put((Object)"sm", (Object)"0 .125rem .25rem rgba(0, 0, 0, .075)").build();
    private final FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;

    public LayoutPageTemplateStructureRelUpgradeProcess(FragmentEntryConfigurationParser fragmentEntryConfigurationParser) {
        this._fragmentEntryConfigurationParser = fragmentEntryConfigurationParser;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeLayoutPageTemplateStructureRel();
    }

    private boolean _isEmpty(JSONObject jsonObject) {
        if (jsonObject == null) {
            return true;
        }
        Set keySet = jsonObject.keySet();
        return keySet.isEmpty();
    }

    private void _replaceAlign(JSONObject fragmentConfigValuesJSONObject, JSONObject stylesJSONObject) {
        for (String key : _ALIGN_KEYS) {
            if (!fragmentConfigValuesJSONObject.has(key)) continue;
            stylesJSONObject.put("textAlign", fragmentConfigValuesJSONObject.get(key));
            break;
        }
    }

    private void _replaceBorderRadius(JSONObject fragmentConfigValuesJSONObject, JSONObject stylesJSONObject) {
        if (!fragmentConfigValuesJSONObject.has("borderRadius")) {
            return;
        }
        String borderRadius = fragmentConfigValuesJSONObject.getString("borderRadius");
        if (_borderRadiuses.containsKey(borderRadius)) {
            stylesJSONObject.put("borderRadius", _borderRadiuses.get(borderRadius));
        }
    }

    private void _replaceBottomSpacing(JSONObject fragmentConfigDefaultValuesJSONObject, JSONObject fragmentConfigValuesJSONObject, JSONObject stylesJSONObject) {
        if (!(fragmentConfigDefaultValuesJSONObject.has("bottomSpacing") || fragmentConfigDefaultValuesJSONObject.has("marginBottom") || fragmentConfigValuesJSONObject.has("bottomSpacing") || fragmentConfigValuesJSONObject.has("marginBottom"))) {
            return;
        }
        String marginBottom = fragmentConfigValuesJSONObject.getString("bottomSpacing", fragmentConfigDefaultValuesJSONObject.getString("bottomSpacing"));
        if (Validator.isNull((String)marginBottom)) {
            marginBottom = fragmentConfigValuesJSONObject.getString("marginBottom", fragmentConfigDefaultValuesJSONObject.getString("marginBottom"));
        }
        stylesJSONObject.put("marginBottom", marginBottom);
    }

    private void _replaceShadow(JSONObject fragmentConfigValuesJSONObject, JSONObject stylesJSONObject) {
        if (!fragmentConfigValuesJSONObject.has("boxShadow")) {
            return;
        }
        String shadowCssClass = fragmentConfigValuesJSONObject.getString("boxShadow");
        if (_shadows.containsKey(shadowCssClass)) {
            stylesJSONObject.put("shadow", _shadows.get(shadowCssClass));
        }
    }

    private void _replaceTextColor(JSONObject fragmentConfigValuesJSONObject, JSONObject stylesJSONObject) {
        JSONObject textColorJSONObject = fragmentConfigValuesJSONObject.getJSONObject("textColor");
        if (textColorJSONObject == null) {
            return;
        }
        if (Validator.isNotNull((String)textColorJSONObject.getString("cssClass"))) {
            stylesJSONObject.put("textColor", _colors.getOrDefault(textColorJSONObject.getString("cssClass"), textColorJSONObject.getString("cssClass")));
        } else if (Validator.isNotNull((String)textColorJSONObject.getString("color"))) {
            stylesJSONObject.put("textColor", _colors.getOrDefault(textColorJSONObject.getString("color"), textColorJSONObject.getString("color")));
        } else if (Validator.isNotNull((String)textColorJSONObject.getString("rgbValue"))) {
            stylesJSONObject.put("textColor", textColorJSONObject.getString("rgbValue"));
        }
    }

    private String _upgradeLayoutData(String data) throws Exception {
        LayoutStructure layoutStructure = LayoutStructure.of((String)data);
        List layoutStructureItems = layoutStructure.getLayoutStructureItems();
        for (LayoutStructureItem layoutStructureItem : layoutStructureItems) {
            JSONObject editableValuesJSONObject;
            JSONObject fragmentConfigValuesJSONObject;
            FragmentEntryLink fragmentEntryLink;
            if (layoutStructureItem instanceof ColumnLayoutStructureItem) {
                ColumnLayoutStructureItem columnLayoutStructureItem = (ColumnLayoutStructureItem)layoutStructureItem;
                Map viewportConfigurationJSONObjects = columnLayoutStructureItem.getViewportConfigurationJSONObjects();
                JSONObject mobileLandscapeJSONObject = (JSONObject)viewportConfigurationJSONObjects.get(ViewportSize.MOBILE_LANDSCAPE.getViewportSizeId());
                JSONObject portraitMobileJSONObject = (JSONObject)viewportConfigurationJSONObjects.get(ViewportSize.PORTRAIT_MOBILE.getViewportSizeId());
                JSONObject tabletJSONObject = (JSONObject)viewportConfigurationJSONObjects.get(ViewportSize.TABLET.getViewportSizeId());
                if (this._isEmpty(mobileLandscapeJSONObject) && this._isEmpty(portraitMobileJSONObject) && this._isEmpty(tabletJSONObject)) {
                    columnLayoutStructureItem.setViewportConfiguration(ViewportSize.MOBILE_LANDSCAPE.getViewportSizeId(), JSONUtil.put((String)"size", (Object)"12"));
                }
            }
            if (!(layoutStructureItem instanceof FragmentStyledLayoutStructureItem)) continue;
            FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructureItem;
            JSONObject itemConfigJSONObject = fragmentStyledLayoutStructureItem.getItemConfigJSONObject();
            JSONObject stylesJSONObject = itemConfigJSONObject.getJSONObject("styles");
            if (stylesJSONObject == null) {
                stylesJSONObject = JSONFactoryUtil.createJSONObject();
                itemConfigJSONObject.put("styles", stylesJSONObject);
            }
            if ((fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.fetchFragmentEntryLink((long)fragmentStyledLayoutStructureItem.getFragmentEntryLinkId())) == null || (fragmentConfigValuesJSONObject = (editableValuesJSONObject = JSONFactoryUtil.createJSONObject((String)fragmentEntryLink.getEditableValues())).getJSONObject("com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor")) == null) continue;
            this._replaceBottomSpacing(this._fragmentEntryConfigurationParser.getConfigurationDefaultValuesJSONObject(fragmentEntryLink.getConfiguration()), fragmentConfigValuesJSONObject, stylesJSONObject);
            if (this._isEmpty(fragmentConfigValuesJSONObject)) continue;
            this._replaceAlign(fragmentConfigValuesJSONObject, stylesJSONObject);
            this._replaceBorderRadius(fragmentConfigValuesJSONObject, stylesJSONObject);
            this._replaceShadow(fragmentConfigValuesJSONObject, stylesJSONObject);
            this._replaceTextColor(fragmentConfigValuesJSONObject, stylesJSONObject);
        }
        JSONObject jsonObject = layoutStructure.toJSONObject();
        return jsonObject.toString();
    }

    private void _upgradeLayoutPageTemplateStructureRel() throws Exception {
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select ctCollectionId, lPageTemplateStructureRelId, segmentsExperienceId, data_ from LayoutPageTemplateStructureRel");
             PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update LayoutPageTemplateStructureRel set data_ = ? where ctCollectionId = ? and lPageTemplateStructureRelId = ?");){
            while (resultSet.next()) {
                long ctCollectionId = resultSet.getLong("ctCollectionId");
                long layoutPageTemplateStructureRelId = resultSet.getLong("lPageTemplateStructureRelId");
                String data = resultSet.getString("data_");
                preparedStatement.setString(1, this._upgradeLayoutData(data));
                preparedStatement.setLong(2, ctCollectionId);
                preparedStatement.setLong(3, layoutPageTemplateStructureRelId);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }
}

