/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v1_1_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class UpgradeLayoutPrototype
extends UpgradeProcess {
    private static final int _MAX_NAME_LENGTH = 75;
    private static final Log _log = LogFactoryUtil.getLog(UpgradeLayoutPrototype.class);
    private final CompanyLocalService _companyLocalService;
    private final LayoutPrototypeLocalService _layoutPrototypeLocalService;

    public UpgradeLayoutPrototype(CompanyLocalService companyLocalService, LayoutPrototypeLocalService layoutPrototypeLocalService) {
        this._companyLocalService = companyLocalService;
        this._layoutPrototypeLocalService = layoutPrototypeLocalService;
    }

    protected void doUpgrade() throws Exception {
        this.upgradeSchema();
        this.upgradeLayoutPrototype();
    }

    protected void upgradeLayoutPrototype() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into LayoutPageTemplateEntry (uuid_, ");
        sb.append("layoutPageTemplateEntryId, groupId, companyId, userId, ");
        sb.append("userName, createDate, modifiedDate, ");
        sb.append("layoutPageTemplateCollectionId, name, type_, ");
        sb.append("layoutPrototypeId, status) values (?, ?, ?, ?, ?, ?, ?, ");
        sb.append("?, ?, ?, ?, ?, ?)");
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb.toString());){
            HashSet<String> existingNames = new HashSet<String>();
            List layoutPrototypes = this._layoutPrototypeLocalService.getLayoutPrototypes(-1, -1);
            for (LayoutPrototype layoutPrototype : layoutPrototypes) {
                Locale defaultLocale;
                long companyId = layoutPrototype.getCompanyId();
                java.util.Date createDate = layoutPrototype.getCreateDate();
                String nameXML = layoutPrototype.getName();
                Company company = this._companyLocalService.getCompany(companyId);
                Map nameMap = LocalizationUtil.getLocalizationMap((String)nameXML);
                String name = (String)nameMap.get(defaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)nameXML)));
                if (existingNames.contains(name)) {
                    name = this._generateNewName(name, existingNames);
                    nameMap.put(defaultLocale, name);
                    layoutPrototype.setNameMap(nameMap);
                    this._layoutPrototypeLocalService.updateLayoutPrototype(layoutPrototype);
                }
                existingNames.add(name);
                ps.setString(1, PortalUUIDUtil.generate());
                ps.setLong(2, this.increment());
                ps.setLong(3, company.getGroupId());
                ps.setLong(4, layoutPrototype.getCompanyId());
                ps.setLong(5, layoutPrototype.getUserId());
                ps.setString(6, layoutPrototype.getUserName());
                ps.setDate(7, new Date(createDate.getTime()));
                ps.setDate(8, new Date(createDate.getTime()));
                ps.setLong(9, 0L);
                ps.setString(10, name);
                ps.setInt(11, 2);
                ps.setLong(12, layoutPrototype.getLayoutPrototypeId());
                ps.setInt(13, 0);
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    protected void upgradeSchema() throws Exception {
        String template = StringUtil.read((InputStream)UpgradeLayoutPrototype.class.getResourceAsStream("dependencies/update.sql"));
        this.runSQLTemplateString(template, false, false);
    }

    private String _generateNewName(String name, Set<String> existingNames) {
        String newName;
        int i = 1;
        while (true) {
            String suffix = "-" + i;
            newName = name + suffix;
            if (newName.length() > 75) {
                String prefix = name.substring(0, 75 - suffix.length());
                newName = prefix + suffix;
            }
            if (!existingNames.contains(newName)) break;
            ++i;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Renaming duplicate layout prototype name \"", name, "\" to \"", newName, "\""}));
        }
        return newName;
    }
}

