/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.model.listener;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class LayoutPrototypeModelListener
extends BaseModelListener<LayoutPrototype> {
    private static final Log _log = LogFactoryUtil.getLog(LayoutPrototypeModelListener.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(unbind="-")
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;

    public void onAfterCreate(LayoutPrototype layoutPrototype) throws ModelListenerException {
        if (ExportImportThreadLocal.isStagingInProcess() || ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        try {
            LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchFirstLayoutPageTemplateEntry(layoutPrototype.getLayoutPrototypeId());
            if (layoutPageTemplateEntry != null) {
                return;
            }
            this._layoutPageTemplateEntryLocalService.addLayoutPageTemplateEntry(layoutPrototype);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            throw new ModelListenerException((Throwable)pe);
        }
    }

    public void onAfterRemove(LayoutPrototype layoutPrototype) throws ModelListenerException {
        try {
            LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchFirstLayoutPageTemplateEntry(layoutPrototype.getLayoutPrototypeId());
            if (layoutPageTemplateEntry != null) {
                this._layoutPageTemplateEntryLocalService.deleteLayoutPageTemplateEntry(layoutPageTemplateEntry);
            }
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            throw new ModelListenerException((Throwable)pe);
        }
    }

    public void onAfterUpdate(LayoutPrototype layoutPrototype) throws ModelListenerException {
        try {
            LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchFirstLayoutPageTemplateEntry(layoutPrototype.getLayoutPrototypeId());
            if (layoutPageTemplateEntry == null) {
                return;
            }
            String nameXML = layoutPrototype.getName();
            Map nameMap = LocalizationUtil.getLocalizationMap((String)nameXML);
            Locale defaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)nameXML));
            int status = 5;
            if (layoutPrototype.isActive()) {
                status = 0;
            }
            this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getUserId(), layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), (String)nameMap.get(defaultLocale), status);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            throw new ModelListenerException((Throwable)pe);
        }
    }
}

