/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import jakarta.servlet.ServletContext;

public class PortletClassInvoker {
    private static final String _INSTANCE_SEPARATOR = "_INSTANCE_";

    public static Object invoke(String portletId, MethodKey methodKey, Object ... arguments) throws Exception {
        portletId = PortletClassInvoker._getRootPortletId(portletId);
        ClassLoader portletClassLoader = PortalClassLoaderUtil.getClassLoader();
        PortletBag portletBag = PortletBagPool.get((String)portletId);
        if (portletBag != null) {
            ServletContext servletContext = portletBag.getServletContext();
            portletClassLoader = servletContext.getClassLoader();
        }
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)portletClassLoader);){
            MethodHandler methodHandler = new MethodHandler(methodKey, arguments);
            Object object = methodHandler.invoke();
            return object;
        }
    }

    private static String _getRootPortletId(String portletId) {
        int pos = portletId.indexOf(_INSTANCE_SEPARATOR);
        if (pos == -1) {
            return portletId;
        }
        return portletId.substring(0, pos);
    }
}

