/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class DigesterUtil {
    public static final String DEFAULT_ALGORITHM = "SHA";
    public static final String ENCODING = "UTF-8";
    public static final String MD5 = "MD5";
    public static final String SHA = "SHA";
    public static final String SHA_1 = "SHA-1";
    public static final String SHA_256 = "SHA-256";
    private static final boolean _BASE_64 = Objects.equals(PropsUtil.get("passwords.digest.encoding"), "base64");
    private static final Log _log = LogFactoryUtil.getLog(DigesterUtil.class);

    public static String digest(ByteBuffer byteBuffer) {
        return DigesterUtil.digest("SHA", byteBuffer);
    }

    public static String digest(InputStream inputStream) {
        return DigesterUtil.digest("SHA", inputStream);
    }

    public static String digest(String text) {
        return DigesterUtil.digest("SHA", text);
    }

    public static String digest(String algorithm, ByteBuffer byteBuffer) {
        if (_BASE_64) {
            return DigesterUtil.digestBase64(algorithm, byteBuffer);
        }
        return DigesterUtil.digestHex(algorithm, byteBuffer);
    }

    public static String digest(String algorithm, InputStream inputStream) {
        if (_BASE_64) {
            return DigesterUtil.digestBase64(algorithm, inputStream);
        }
        return DigesterUtil.digestHex(algorithm, inputStream);
    }

    public static String digest(String algorithm, String ... text) {
        if (_BASE_64) {
            return DigesterUtil.digestBase64(algorithm, text);
        }
        return DigesterUtil.digestHex(algorithm, text);
    }

    public static String digestBase64(ByteBuffer byteBuffer) {
        return DigesterUtil.digestBase64("SHA", byteBuffer);
    }

    public static String digestBase64(InputStream inputStream) {
        return DigesterUtil.digestBase64("SHA", inputStream);
    }

    public static String digestBase64(String text) {
        return DigesterUtil.digestBase64("SHA", text);
    }

    public static String digestBase64(String algorithm, ByteBuffer byteBuffer) {
        byte[] bytes = DigesterUtil.digestRaw(algorithm, byteBuffer);
        return Base64.encode(bytes);
    }

    public static String digestBase64(String algorithm, InputStream inputStream) {
        byte[] bytes = DigesterUtil.digestRaw(algorithm, inputStream);
        return Base64.encode(bytes);
    }

    public static String digestBase64(String algorithm, String ... text) {
        byte[] bytes = DigesterUtil.digestRaw(algorithm, text);
        return Base64.encode(bytes);
    }

    public static String digestHex(ByteBuffer byteBuffer) {
        return DigesterUtil.digestHex("SHA", byteBuffer);
    }

    public static String digestHex(InputStream inputStream) {
        return DigesterUtil.digestHex("SHA", inputStream);
    }

    public static String digestHex(String text) {
        return DigesterUtil.digestHex("SHA", text);
    }

    public static String digestHex(String algorithm, ByteBuffer byteBuffer) {
        byte[] bytes = DigesterUtil.digestRaw(algorithm, byteBuffer);
        return StringUtil.bytesToHexString(bytes);
    }

    public static String digestHex(String algorithm, InputStream inputStream) {
        byte[] bytes = DigesterUtil.digestRaw(algorithm, inputStream);
        return StringUtil.bytesToHexString(bytes);
    }

    public static String digestHex(String algorithm, String ... text) {
        byte[] bytes = DigesterUtil.digestRaw(algorithm, text);
        return StringUtil.bytesToHexString(bytes);
    }

    public static byte[] digestRaw(ByteBuffer byteBuffer) {
        return DigesterUtil.digestRaw("SHA", byteBuffer);
    }

    public static byte[] digestRaw(String text) {
        return DigesterUtil.digestRaw("SHA", text);
    }

    public static byte[] digestRaw(String algorithm, ByteBuffer byteBuffer) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(algorithm);
            messageDigest.update(byteBuffer);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            _log.error(noSuchAlgorithmException);
        }
        return messageDigest.digest();
    }

    public static byte[] digestRaw(String algorithm, InputStream inputStream1) {
        MessageDigest messageDigest = null;
        try (InputStream inputStream2 = inputStream1;){
            messageDigest = MessageDigest.getInstance(algorithm);
            byte[] buffer = new byte[StreamUtil.BUFFER_SIZE];
            int read = 0;
            while ((read = inputStream2.read(buffer)) != -1) {
                if (read <= 0) continue;
                messageDigest.update(buffer, 0, read);
            }
        }
        catch (IOException ioException) {
            _log.error(ioException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            _log.error(noSuchAlgorithmException);
        }
        return messageDigest.digest();
    }

    public static byte[] digestRaw(String algorithm, String ... text) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(algorithm);
            StringBundler sb = new StringBundler(text.length * 2 - 1);
            for (String t : text) {
                if (sb.length() > 0) {
                    sb.append(":");
                }
                sb.append(t);
            }
            String s = sb.toString();
            messageDigest.update(s.getBytes(ENCODING));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            _log.error(noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            _log.error(unsupportedEncodingException);
        }
        return messageDigest.digest();
    }
}

