/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.log;

import com.liferay.portal.kernel.internal.log4j.Log4jLogFactoryImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.SanitizerLogWrapper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LogFactoryUtil {
    private static final LogFactory _logFactory = new Log4jLogFactoryImpl();
    private static final ConcurrentMap<String, Log> _logs = new ConcurrentHashMap<String, Log>();

    public static Log getLog(Class<?> c) {
        return LogFactoryUtil.getLog(c.getName());
    }

    public static Log getLog(String name) {
        Log previousLog;
        Log log = (Log)_logs.get(name);
        if (log == null && (previousLog = _logs.putIfAbsent(name, log = SanitizerLogWrapper.isEnabled() ? new SanitizerLogWrapper(_logFactory.getLog(name)) : _logFactory.getLog(name))) != null) {
            log = previousLog;
        }
        return log;
    }

    public static LogFactory getLogFactory() {
        return _logFactory;
    }
}

