/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;

public class ServerDetector {
    public static final String JBOSS_ID = "jboss";
    public static final String SYSTEM_PROPERTY_KEY_SERVER_DETECTOR_SERVER_ID = "server.detector.server.id";
    public static final String TOMCAT_ID = "tomcat";
    public static final String WEBLOGIC_ID = "weblogic";
    public static final String WILDFLY_ID = "wildfly";
    private static final Log _log = LogFactoryUtil.getLog(ServerDetector.class);
    private static final ServerType _serverType = ServerDetector._detectServerType();

    public static String getServerId() {
        return _serverType.getLowerCaseName();
    }

    public static boolean isJBoss() {
        return _serverType == ServerType.JBOSS;
    }

    public static boolean isSupported(String serverType) {
        return serverType.equals(JBOSS_ID) || serverType.equals(TOMCAT_ID) || serverType.equals(WEBLOGIC_ID) || serverType.equals(WILDFLY_ID);
    }

    public static boolean isSupportsComet() {
        return false;
    }

    public static boolean isTomcat() {
        return _serverType == ServerType.TOMCAT;
    }

    public static boolean isWebLogic() {
        return _serverType == ServerType.WEBLOGIC;
    }

    public static boolean isWildfly() {
        return _serverType == ServerType.WILDFLY;
    }

    private static boolean _detect(String className) {
        try {
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            systemClassLoader.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (_log.isDebugEnabled()) {
                _log.debug(classNotFoundException);
            }
            return ServerDetector.class.getResource(className) != null;
        }
    }

    private static ServerType _detectServerType() {
        String serverId = System.getProperty(SYSTEM_PROPERTY_KEY_SERVER_DETECTOR_SERVER_ID);
        if (serverId != null) {
            return ServerType.valueOf(StringUtil.toUpperCase(serverId));
        }
        if (ServerDetector._hasSystemProperty("jboss.home.dir")) {
            return ServerType.JBOSS;
        }
        if (ServerDetector._detect("/weblogic/Server.class")) {
            return ServerType.WEBLOGIC;
        }
        if (ServerDetector._hasSystemProperty("jboss.home.dir")) {
            return ServerType.WILDFLY;
        }
        if (ServerDetector._hasSystemProperty("catalina.base")) {
            return ServerType.TOMCAT;
        }
        return ServerType.UNKNOWN;
    }

    private static boolean _hasSystemProperty(String key) {
        String value = System.getProperty(key);
        return value != null;
    }

    static {
        if (!GetterUtil.getBoolean(System.getProperty("server.detector.quiet")) && System.getProperty("external-properties") == null && _log.isInfoEnabled()) {
            _log.info("Detected server " + _serverType.getLowerCaseName());
        }
    }

    private static enum ServerType {
        JBOSS("jboss"),
        TOMCAT("tomcat"),
        UNKNOWN("unknown"),
        WEBLOGIC("weblogic"),
        WILDFLY("wildfly");

        private final String _lowerCaseName;

        public String getLowerCaseName() {
            return this._lowerCaseName;
        }

        private ServerType(String lowerCaseName) {
            this._lowerCaseName = lowerCaseName;
        }
    }
}

