/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HttpComponentsUtil {
    private static final String _TEMP_PLUS = "_LIFERAY_TEMP_PLUS_";
    private static final String _TEMP_SLASH = "_LIFERAY_TEMP_SLASH_";
    private static final String _TEMP_TILDE = "_LIFERAY_TEMP_TILDE_";
    private static final Log _log = LogFactoryUtil.getLog(HttpComponentsUtil.class);
    private static final ThreadLocal<Map<String, URI>> _uris = new CentralizedThreadLocal<Map>(String.valueOf(HttpComponentsUtil.class) + "._uris", HashMap::new);

    public static String addParameter(String url, String name, boolean value) {
        return HttpComponentsUtil.addParameter(url, name, String.valueOf(value));
    }

    public static String addParameter(String url, String name, double value) {
        return HttpComponentsUtil.addParameter(url, name, String.valueOf(value));
    }

    public static String addParameter(String url, String name, int value) {
        return HttpComponentsUtil.addParameter(url, name, String.valueOf(value));
    }

    public static String addParameter(String url, String name, long value) {
        return HttpComponentsUtil.addParameter(url, name, String.valueOf(value));
    }

    public static String addParameter(String url, String name, short value) {
        return HttpComponentsUtil.addParameter(url, name, String.valueOf(value));
    }

    public static String addParameter(String url, String name, String value) {
        if (url == null) {
            return null;
        }
        String[] urlArray = PortalUtil.stripURLAnchor(url, "#");
        url = urlArray[0];
        String anchor = urlArray[1];
        StringBundler sb = new StringBundler(6);
        sb.append(url);
        if (url.indexOf(63) == -1) {
            sb.append("?");
        } else if (!url.endsWith("?") && !url.endsWith("&")) {
            sb.append("&");
        }
        sb.append(name);
        sb.append("=");
        sb.append(URLCodec.encodeURL(value));
        sb.append(anchor);
        return HttpComponentsUtil.shortenURL(sb.toString());
    }

    public static String addParameters(String url, Object ... parameters) {
        if (parameters.length % 2 != 0) {
            throw new IllegalArgumentException("Parameters length is not an even number");
        }
        for (int i = 0; i < parameters.length; i += 2) {
            String name = String.valueOf(parameters[i]);
            String value = String.valueOf(parameters[i + 1]);
            url = HttpComponentsUtil.addParameter(url, name, value);
        }
        return url;
    }

    public static String decodePath(String path) {
        return HttpComponentsUtil.decodeURL(path);
    }

    public static String decodeURL(String url) {
        if (Validator.isNull(url)) {
            return url;
        }
        try {
            return URLCodec.decodeURL(url, "UTF-8");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (_log.isWarnEnabled()) {
                _log.warn(illegalArgumentException);
            }
            return "";
        }
    }

    public static String encodeParameters(String url) {
        if (Validator.isNull(url)) {
            return url;
        }
        String queryString = HttpComponentsUtil.getQueryString(url);
        if (Validator.isNull(queryString)) {
            return url;
        }
        String encodedQueryString = HttpComponentsUtil.parameterMapToString(HttpComponentsUtil.parameterMapFromString(queryString), false);
        return StringUtil.replace(url, queryString, encodedQueryString);
    }

    public static String encodePath(String path) {
        if (Validator.isNull(path)) {
            return path;
        }
        path = StringUtil.replace(path, new char[]{'+', '/', '~'}, new String[]{_TEMP_PLUS, _TEMP_SLASH, _TEMP_TILDE});
        path = URLCodec.encodeURL(path, true);
        path = StringUtil.replace(path, new String[]{_TEMP_PLUS, _TEMP_SLASH, _TEMP_TILDE}, new String[]{"+", "/", "~"});
        return path;
    }

    public static String fixPath(String path) {
        return HttpComponentsUtil.fixPath(path, true, true);
    }

    public static String fixPath(String path, boolean leading, boolean trailing) {
        int slashCount;
        int i;
        if (path == null) {
            return "";
        }
        int leadingSlashCount = 0;
        int trailingSlashCount = 0;
        if (leading) {
            for (i = 0; i < path.length() && path.charAt(i) == '/'; ++i) {
                ++leadingSlashCount;
            }
        }
        if (trailing) {
            for (i = path.length() - 1; i >= 0 && path.charAt(i) == '/'; --i) {
                ++trailingSlashCount;
            }
        }
        if ((slashCount = leadingSlashCount + trailingSlashCount) > path.length()) {
            return "";
        }
        if (slashCount > 0) {
            path = path.substring(leadingSlashCount, path.length() - trailingSlashCount);
        }
        return path;
    }

    public static String getCompleteURL(HttpServletRequest httpServletRequest) {
        String proxyPath;
        StringBuffer sb = httpServletRequest.getRequestURL();
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (httpServletRequest.getQueryString() != null) {
            sb.append("?");
            sb.append(httpServletRequest.getQueryString());
        }
        if (Validator.isNotNull(proxyPath = PortalUtil.getPathProxy())) {
            int x = sb.indexOf("://") + "://".length();
            int y = sb.indexOf("/", x);
            sb.insert(y, proxyPath);
        }
        String completeURL = sb.toString();
        if (httpServletRequest.isRequestedSessionIdFromURL()) {
            HttpSession httpSession = httpServletRequest.getSession();
            String sessionId = httpSession.getId();
            completeURL = PortalUtil.getURLWithSessionId(completeURL, sessionId);
        }
        if (_log.isWarnEnabled() && completeURL.contains("?&")) {
            _log.warn("Invalid url " + completeURL);
        }
        return completeURL;
    }

    public static String getDomain(String url) {
        URI uri;
        block5: {
            if (Validator.isNull(url)) {
                return url;
            }
            uri = null;
            try {
                uri = HttpComponentsUtil.getURI(url);
            }
            catch (URISyntaxException uriSyntaxException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug(uriSyntaxException);
            }
        }
        if (uri == null) {
            return "";
        }
        String host = uri.getHost();
        if (host == null) {
            return "";
        }
        return host;
    }

    public static String getIpAddress(String url) {
        if (Validator.isNull(url)) {
            return url;
        }
        try {
            URL urlObj = new URL(url);
            InetAddress address = InetAddressUtil.getInetAddressByName(urlObj.getHost());
            return address.getHostAddress();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return url;
        }
    }

    public static String getParameter(String url, String name) {
        return HttpComponentsUtil.getParameter(url, name, true);
    }

    public static String getParameter(String url, String name, boolean escaped) {
        if (Validator.isNull(url) || Validator.isNull(name)) {
            return "";
        }
        String[] parts = StringUtil.split(url, '?');
        if (parts.length == 2) {
            String[] params = null;
            params = escaped ? StringUtil.split(parts[1], "&amp;") : StringUtil.split(parts[1], '&');
            for (String param : params) {
                String[] kvp = StringUtil.split(param, '=');
                if (kvp.length != 2 || !kvp[0].equals(name)) continue;
                return kvp[1];
            }
        }
        return "";
    }

    public static Map<String, String[]> getParameterMap(String queryString) {
        return HttpComponentsUtil.parameterMapFromString(queryString);
    }

    public static String getPath(String url) {
        URI uri;
        block5: {
            if (Validator.isNull(url)) {
                return url;
            }
            uri = null;
            try {
                uri = HttpComponentsUtil.getURI(url);
            }
            catch (URISyntaxException uriSyntaxException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug(uriSyntaxException);
            }
        }
        if (uri == null) {
            return "";
        }
        String path = uri.getPath();
        if (path == null) {
            return "";
        }
        return path;
    }

    public static String getProtocol(ActionRequest actionRequest) {
        return HttpComponentsUtil.getProtocol(actionRequest.isSecure());
    }

    public static String getProtocol(boolean secure) {
        if (!secure) {
            return "http";
        }
        return "https";
    }

    public static String getProtocol(HttpServletRequest httpServletRequest) {
        return HttpComponentsUtil.getProtocol(httpServletRequest.isSecure());
    }

    public static String getProtocol(RenderRequest renderRequest) {
        return HttpComponentsUtil.getProtocol(renderRequest.isSecure());
    }

    public static String getProtocol(String url) {
        URI uri;
        block5: {
            if (Validator.isNull(url)) {
                return url;
            }
            uri = null;
            try {
                uri = HttpComponentsUtil.getURI(url);
            }
            catch (URISyntaxException uriSyntaxException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug(uriSyntaxException);
            }
        }
        if (uri == null) {
            return "";
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            return "";
        }
        return scheme;
    }

    public static String getQueryString(HttpServletRequest httpServletRequest) {
        if (HttpComponentsUtil.isForwarded(httpServletRequest)) {
            return GetterUtil.getString(httpServletRequest.getAttribute("javax.servlet.forward.query_string"));
        }
        return httpServletRequest.getQueryString();
    }

    public static String getQueryString(String url) {
        URI uri;
        block5: {
            if (Validator.isNull(url)) {
                return url;
            }
            uri = null;
            try {
                uri = HttpComponentsUtil.getURI(url);
            }
            catch (URISyntaxException uriSyntaxException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug(uriSyntaxException);
            }
        }
        if (uri == null) {
            return "";
        }
        String queryString = uri.getRawQuery();
        if (queryString == null) {
            return "";
        }
        return queryString;
    }

    public static String getRequestURL(HttpServletRequest httpServletRequest) {
        return String.valueOf(httpServletRequest.getRequestURL());
    }

    public static URI getURI(String uriString) throws URISyntaxException {
        Map<String, URI> uris = _uris.get();
        URI uri = uris.get(uriString = uriString.trim());
        if (uri == null) {
            uri = new URI(uriString);
            uris.put(uriString, uri);
        }
        return uri;
    }

    public static boolean hasDomain(String url) {
        if (Validator.isNull(url)) {
            return false;
        }
        return Validator.isNotNull(HttpComponentsUtil.getDomain(url));
    }

    public static boolean hasProtocol(String url) {
        if (Validator.isNull(url) || url.indexOf(58) == -1) {
            return false;
        }
        return Validator.isNotNull(HttpComponentsUtil.getProtocol(url));
    }

    public static boolean isForwarded(HttpServletRequest httpServletRequest) {
        String forwardedRequestURI = (String)httpServletRequest.getAttribute("javax.servlet.forward.request_uri");
        return forwardedRequestURI != null;
    }

    public static boolean isSecure(String url) {
        return StringUtil.equalsIgnoreCase(HttpComponentsUtil.getProtocol(url), "https");
    }

    public static String normalizePath(String uri) {
        char c;
        if (Validator.isNull(uri)) {
            return uri;
        }
        uri = HttpComponentsUtil.removePathParameters(uri);
        for (int i = 0; i < uri.length() && (c = uri.charAt(i)) != '%' && c != '.' && (c != '/' || i + 1 >= uri.length() || uri.charAt(i + 1) != '/'); ++i) {
            if (i != uri.length() - 1) continue;
            if (c == '?') {
                return uri.substring(0, uri.length() - 1);
            }
            return uri;
        }
        String path = null;
        String queryString = null;
        int pos = uri.indexOf(63);
        if (pos != -1) {
            path = uri.substring(0, pos);
            queryString = uri.substring(pos + 1);
        } else {
            path = uri;
        }
        String[] uriParts = StringUtil.split(path.substring(1), '/');
        ArrayList<String> parts = new ArrayList<String>(uriParts.length);
        String prevUriPart = null;
        for (String uriPart : uriParts) {
            String curUriPart = URLCodec.decodeURL(uriPart);
            if (curUriPart.equals("..")) {
                if (prevUriPart != null && !prevUriPart.equals(".")) {
                    parts.remove(parts.size() - 1);
                }
            } else if (curUriPart.length() > 0 && !curUriPart.equals(".")) {
                parts.add(URLCodec.encodeURL(curUriPart));
            }
            prevUriPart = curUriPart;
        }
        if (parts.isEmpty()) {
            return "/";
        }
        StringBundler sb = new StringBundler(parts.size() * 2 + 2);
        for (String part : parts) {
            sb.append("/");
            sb.append(part);
        }
        if (Validator.isNotNull(queryString)) {
            sb.append("?");
            sb.append(queryString);
        }
        return sb.toString();
    }

    public static Map<String, String[]> parameterMapFromString(String queryString) {
        String[] parameters;
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        if (Validator.isNull(queryString)) {
            return parameterMap;
        }
        for (String parameter : parameters = StringUtil.split(queryString, '&')) {
            String[] values;
            String[] kvp;
            if (parameter.length() == 0 || (kvp = StringUtil.split(parameter, '=')).length == 0) continue;
            String key = kvp[0];
            String value = "";
            if (kvp.length > 1) {
                try {
                    value = HttpComponentsUtil.decodeURL(kvp[1]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!_log.isInfoEnabled()) continue;
                    _log.info(StringBundler.concat("Skipping parameter with key ", key, " because of invalid value ", kvp[1]), illegalArgumentException);
                    continue;
                }
            }
            if ((values = (String[])parameterMap.get(key)) == null) {
                parameterMap.put(key, new String[]{value});
                continue;
            }
            parameterMap.put(key, ArrayUtil.append(values, value));
        }
        return parameterMap;
    }

    public static String parameterMapToString(Map<String, String[]> parameterMap) {
        return HttpComponentsUtil.parameterMapToString(parameterMap, true);
    }

    public static String parameterMapToString(Map<String, String[]> parameterMap, boolean addQuestion) {
        if (parameterMap.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler();
        if (addQuestion) {
            sb.append("?");
        }
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String[] values;
            String name = entry.getKey();
            for (String value : values = entry.getValue()) {
                sb.append(name);
                sb.append("=");
                sb.append(URLCodec.encodeURL(value));
                sb.append("&");
            }
        }
        if (sb.index() > 1) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    public static String protocolize(String url, ActionRequest actionRequest) {
        return HttpComponentsUtil.protocolize(url, actionRequest.isSecure());
    }

    public static String protocolize(String url, boolean secure) {
        return HttpComponentsUtil.protocolize(url, -1, secure);
    }

    public static String protocolize(String url, HttpServletRequest httpServletRequest) {
        return HttpComponentsUtil.protocolize(url, httpServletRequest.isSecure());
    }

    public static String protocolize(String url, int port, boolean secure) {
        if (Validator.isNull(url)) {
            return url;
        }
        try {
            URL urlObj = new URL(url);
            String protocol = "http";
            if (secure) {
                protocol = "https";
            }
            if (port == -1) {
                port = urlObj.getPort();
            }
            urlObj = new URL(protocol, urlObj.getHost(), port, urlObj.getFile());
            return urlObj.toString();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return url;
        }
    }

    public static String protocolize(String url, RenderRequest renderRequest) {
        return HttpComponentsUtil.protocolize(url, renderRequest.isSecure());
    }

    public static String removeDomain(String url) {
        if (Validator.isNull(url)) {
            return url;
        }
        int pos = (url = HttpComponentsUtil.removeProtocol(url)).indexOf(47);
        if (pos > 0) {
            return url.substring(pos);
        }
        return url;
    }

    public static String removeParameter(String url, String name) {
        String[] parameters;
        if (Validator.isNull(url) || Validator.isNull(name)) {
            return url;
        }
        int pos = url.indexOf(63);
        if (pos == -1) {
            return url;
        }
        String[] array = PortalUtil.stripURLAnchor(url, "#");
        url = array[0];
        String anchor = array[1];
        StringBundler sb = new StringBundler();
        sb.append(url.substring(0, pos + 1));
        for (String parameter : parameters = StringUtil.split(url.substring(pos + 1), '&')) {
            if (parameter.length() <= 0) continue;
            String[] kvp = StringUtil.split(parameter, '=');
            String key = kvp[0];
            String value = "";
            if (kvp.length > 1) {
                value = kvp[1];
            }
            if (key.equals(name)) continue;
            sb.append(key);
            sb.append("=");
            sb.append(value);
            sb.append("&");
        }
        url = StringUtil.replace(sb.toString(), "&&", "&");
        if (url.endsWith("&")) {
            url = url.substring(0, url.length() - 1);
        }
        if (url.endsWith("?")) {
            url = url.substring(0, url.length() - 1);
        }
        return url + anchor;
    }

    public static String removePathParameters(String uri) {
        if (Validator.isNull(uri)) {
            return uri;
        }
        int pos = uri.indexOf(59);
        if (pos == -1) {
            return uri;
        }
        if (pos == 0) {
            throw new IllegalArgumentException("Unable to handle URI: " + uri);
        }
        String[] uriParts = StringUtil.split(uri.substring(1), '/');
        StringBundler sb = new StringBundler(uriParts.length * 2);
        for (String uriPart : uriParts) {
            pos = uriPart.indexOf(59);
            if (pos == -1) {
                sb.append("/");
                sb.append(uriPart);
                continue;
            }
            if (pos == 0) continue;
            sb.append("/");
            sb.append(uriPart.substring(0, pos));
        }
        if (sb.length() == 0) {
            return "/";
        }
        return sb.toString();
    }

    public static String removeProtocol(String url) {
        String protocol = HttpComponentsUtil.getProtocol(url);
        if (Validator.isNotNull(protocol)) {
            if ((url = url.trim()).regionMatches(protocol.length(), "://", 0, "://".length())) {
                return url.substring(protocol.length() + "://".length());
            }
            return url.substring(protocol.length() + ":".length());
        }
        return url;
    }

    public static String sanitizeHeader(String header) {
        if (header == null) {
            return null;
        }
        StringBuilder sb = null;
        for (int i = 0; i < header.length(); ++i) {
            char c = header.charAt(i);
            if ((c > '\u001f' || c == '\t') && c != '\u007f' && c <= '\u00ff') continue;
            if (sb == null) {
                sb = new StringBuilder(header);
            }
            sb.setCharAt(i, ' ');
        }
        if (sb != null) {
            header = sb.toString();
        }
        return header;
    }

    public static String setParameter(String url, String name, boolean value) {
        return HttpComponentsUtil.setParameter(url, name, String.valueOf(value));
    }

    public static String setParameter(String url, String name, double value) {
        return HttpComponentsUtil.setParameter(url, name, String.valueOf(value));
    }

    public static String setParameter(String url, String name, int value) {
        return HttpComponentsUtil.setParameter(url, name, String.valueOf(value));
    }

    public static String setParameter(String url, String name, long value) {
        return HttpComponentsUtil.setParameter(url, name, String.valueOf(value));
    }

    public static String setParameter(String url, String name, short value) {
        return HttpComponentsUtil.setParameter(url, name, String.valueOf(value));
    }

    public static String setParameter(String url, String name, String value) {
        if (Validator.isNull(url) || Validator.isNull(name)) {
            return url;
        }
        url = HttpComponentsUtil.removeParameter(url, name);
        return HttpComponentsUtil.addParameter(url, name, value);
    }

    public static String shortenURL(String url) {
        if (url.length() <= 2083) {
            return url;
        }
        return HttpComponentsUtil._shortenURL(url, 0, "?", "&", "=");
    }

    private static String _shortenURL(String encodedURL, int currentLength, String encodedQuestion, String encodedAmpersand, String encodedEqual) {
        if (currentLength + encodedURL.length() <= 2083) {
            return encodedURL;
        }
        int index = encodedURL.indexOf(encodedQuestion);
        if (index == -1) {
            return encodedURL;
        }
        StringBundler sb = new StringBundler();
        sb.append(encodedURL.substring(0, index));
        sb.append(encodedQuestion);
        String queryString = encodedURL.substring(index + encodedQuestion.length());
        String[] params = StringUtil.split(queryString, encodedAmpersand);
        params = ArrayUtil.unique(params);
        ArrayList<String> encodedRedirectParams = new ArrayList<String>();
        for (String param : params) {
            if (param.contains("_backURL" + encodedEqual) || param.contains("_redirect" + encodedEqual) || param.contains("_returnToFullPageURL" + encodedEqual) || param.startsWith("redirect") && param.indexOf(encodedEqual) != -1) {
                encodedRedirectParams.add(param);
                continue;
            }
            sb.append(param);
            sb.append(encodedAmpersand);
        }
        if (currentLength + sb.length() > 2083) {
            sb.setIndex(sb.index() - 1);
            return sb.toString();
        }
        for (String encodedRedirectParam : encodedRedirectParams) {
            int pos = encodedRedirectParam.indexOf(encodedEqual);
            String key = encodedRedirectParam.substring(0, pos);
            String redirect = encodedRedirectParam.substring(pos + encodedEqual.length());
            sb.append(key);
            sb.append(encodedEqual);
            int newLength = sb.length();
            redirect = HttpComponentsUtil._shortenURL(redirect, currentLength + newLength, URLCodec.encodeURL(encodedQuestion), URLCodec.encodeURL(encodedAmpersand), URLCodec.encodeURL(encodedEqual));
            if (currentLength + (newLength += redirect.length()) > 2083) {
                sb.setIndex(sb.index() - 2);
                continue;
            }
            sb.append(redirect);
            sb.append(encodedAmpersand);
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }
}

