/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.mail.kernel.model.FileAttachment;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.model.SMTPAccount;
import com.liferay.mail.kernel.service.MailServiceUtil;
import com.liferay.mail.kernel.template.MailTemplate;
import com.liferay.mail.kernel.template.MailTemplateContext;
import com.liferay.mail.kernel.template.MailTemplateContextBuilder;
import com.liferay.mail.kernel.template.MailTemplateFactoryUtil;
import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.Subscription;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.notifications.UserNotificationManagerUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.UserNotificationEventLocalServiceUtil;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.EscapableLocalizableFunction;
import com.liferay.portal.kernel.util.EscapableObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlEscapableObject;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.mail.internet.InternetAddress;

public class SubscriptionSender
implements Serializable {
    protected String body;
    protected boolean bulk;
    @Deprecated
    protected long companyId;
    protected long creatorUserId;
    protected long currentUserId;
    protected List<FileAttachment> fileAttachments = new ArrayList<FileAttachment>();
    protected String fromAddress;
    protected String fromName;
    protected long groupId;
    protected boolean htmlFormat;
    protected String inReplyTo;
    protected Map<Locale, String> localizedBodyMap;
    protected Map<Locale, String> localizedPortletTitleMap;
    protected Map<Locale, String> localizedSubjectMap;
    protected String mailId;
    protected String portletId;
    protected String replyToAddress;
    protected long scopeGroupId;
    protected ServiceContext serviceContext;
    protected SMTPAccount smtpAccount;
    protected String subject;
    protected boolean uniqueMailId = true;
    private static final String _LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING = PropsUtil.get("layout.friendly.url.private.group.servlet.mapping");
    private static final Log _log = LogFactoryUtil.getLog(SubscriptionSender.class);
    private List<InternetAddress> _bulkAddresses;
    private transient ClassLoader _classLoader;
    private String _className;
    private long _classPK;
    private final Map<String, EscapableObject<String>> _context = new HashMap<String, EscapableObject<String>>();
    private String _contextCreatorUserPrefix;
    private final Set<String> _delayedSentEmailAddresses = new HashSet<String>();
    private String _entryTitle;
    private String _entryURL;
    private final Map<Hook.Event<?>, List<Hook<?>>> _hooks = new HashMap();
    private boolean _initialized;
    private final Map<String, EscapableLocalizableFunction> _localizedContext = new HashMap<String, EscapableLocalizableFunction>();
    private Object[] _mailIdIds;
    private String _mailIdPopPortletPrefix;
    private String _notificationClassName;
    private int _notificationType;
    private final List<Tuple> _persistedSubscribersTuples = new ArrayList<Tuple>();
    private final List<ObjectValuePair<String, String>> _runtimeSubscribersOVPs = new ArrayList<ObjectValuePair<String, String>>();
    private boolean _sendToCurrentUser;
    private final Set<String> _sentEmailAddresses = new HashSet<String>();

    public void addAssetEntryPersistedSubscribers(String assetEntryClassName, long assetEntryClassPK) {
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry((String)assetEntryClassName, (long)assetEntryClassPK);
        if (assetEntry == null) {
            return;
        }
        for (AssetTag assetTag : assetEntry.getTags()) {
            this.addPersistedSubscribers(AssetTag.class.getName(), assetTag.getTagId());
        }
    }

    public void addFileAttachment(File file) {
        this.addFileAttachment(file, null);
    }

    public void addFileAttachment(File file, String fileName) {
        if (file == null) {
            return;
        }
        if (this.fileAttachments == null) {
            this.fileAttachments = new ArrayList<FileAttachment>();
        }
        FileAttachment attachment = new FileAttachment(file, fileName);
        this.fileAttachments.add(attachment);
    }

    public <T> void addHook(Hook.Event<T> event, Hook<T> hook) {
        List<Hook<T>> hooks = this._getHooks(event);
        hooks.add(hook);
    }

    public void addPersistedSubscribers(String className, long classPK) {
        this.addPersistedSubscribers(className, classPK, true);
    }

    public void addPersistedSubscribers(String className, long classPK, boolean notifyImmediately) {
        this._persistedSubscribersTuples.add(new Tuple(className, classPK, notifyImmediately));
    }

    public void addRuntimeSubscribers(String toAddress, String toName) {
        ObjectValuePair<String, String> ovp = new ObjectValuePair<String, String>(toAddress, toName);
        this._runtimeSubscribersOVPs.add(ovp);
    }

    public void flushNotifications() throws Exception {
        this.initialize();
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)this._classLoader);){
            for (Tuple tuple : this._persistedSubscribersTuples) {
                String className = (String)tuple.getObject(0);
                long classPK = (Long)tuple.getObject(1);
                boolean notifyImmediately = (Boolean)tuple.getObject(2);
                List subscriptions = SubscriptionLocalServiceUtil.getSubscriptions((long)CompanyThreadLocal.getNonsystemCompanyId(), (String)className, (long)classPK);
                for (Subscription subscription : subscriptions) {
                    try {
                        this.notifyPersistedSubscriber(subscription, notifyImmediately);
                    }
                    catch (Exception exception) {
                        _log.error("Unable to process subscription: " + subscription, exception);
                    }
                }
            }
            this._persistedSubscribersTuples.clear();
            for (ObjectValuePair objectValuePair : this._runtimeSubscribersOVPs) {
                String toAddress = (String)objectValuePair.getKey();
                if (Validator.isNull(toAddress)) continue;
                if (this._sentEmailAddresses.contains(toAddress)) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug("Do not send a duplicate email to " + toAddress);
                    continue;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug(StringBundler.concat("Add ", toAddress, " to the list of users who have received an ", "email"));
                }
                this._sentEmailAddresses.add(toAddress);
                String toName = (String)objectValuePair.getValue();
                InternetAddress to = new InternetAddress(toAddress, toName);
                this.notifyRuntimeSubscriber(to, LocaleUtil.getDefault());
            }
            this._runtimeSubscribersOVPs.clear();
            if (this.bulk && this._bulkAddresses != null) {
                Locale locale = LocaleUtil.getDefault();
                MailTemplateContext mailTemplateContext = this._getBasicMailTemplateContext(locale);
                String template = this.replyToAddress;
                if (Validator.isNull(template)) {
                    template = this.fromAddress;
                }
                MailTemplate replyToAddressMailTemplate = MailTemplateFactoryUtil.createMailTemplate((String)template, (boolean)false);
                String processedReplyToAddress = replyToAddressMailTemplate.renderAsString(locale, mailTemplateContext);
                InternetAddress to = new InternetAddress(processedReplyToAddress, processedReplyToAddress);
                this.sendEmail(to, locale);
            }
        }
    }

    public void flushNotificationsAsync() {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Thread currentThread = Thread.currentThread();
            this._classLoader = currentThread.getContextClassLoader();
            MessageBusUtil.sendMessage((String)"liferay/subscription_sender", (Object)this);
            return null;
        });
    }

    @Deprecated
    public long getCompanyId() {
        return CompanyThreadLocal.getNonsystemCompanyId();
    }

    public Object getContextAttribute(String key) {
        return this._context.get(key);
    }

    public long getCurrentUserId() {
        return this.currentUserId;
    }

    public String getMailId() {
        return this.mailId;
    }

    public ServiceContext getServiceContext() {
        this.serviceContext.setCompanyId(CompanyThreadLocal.getNonsystemCompanyId());
        return this.serviceContext;
    }

    public boolean hasSubscribers() {
        if (!this._runtimeSubscribersOVPs.isEmpty()) {
            return true;
        }
        for (Tuple tuple : this._persistedSubscribersTuples) {
            String className = (String)tuple.getObject(0);
            long classPK = (Long)tuple.getObject(1);
            List subscriptions = SubscriptionLocalServiceUtil.getSubscriptions((long)CompanyThreadLocal.getNonsystemCompanyId(), (String)className, (long)classPK);
            if (subscriptions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void initialize() throws Exception {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        if (this.groupId == 0L && this.serviceContext != null) {
            this.setScopeGroupId(this.serviceContext.getScopeGroupId());
        }
        Company company = CompanyLocalServiceUtil.getCompany((long)CompanyThreadLocal.getNonsystemCompanyId());
        this.setContextAttribute("[$COMPANY_ID$]", company.getCompanyId());
        this.setContextAttribute("[$COMPANY_MX$]", company.getMx());
        this.setContextAttribute("[$COMPANY_NAME$]", company.getName());
        if (Validator.isNotNull(this._entryURL)) {
            boolean secureConnection = HttpComponentsUtil.isSecure(this._entryURL);
            if (this._entryURL.startsWith(PortalUtil.getPortalURL(company.getVirtualHostname(), PortalUtil.getPortalServerPort(secureConnection), secureConnection))) {
                this.setContextAttribute("[$PORTAL_URL$]", company.getPortalURL(this.groupId, this._entryURL.contains(_LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING)));
            } else {
                int endIndex = this._entryURL.indexOf(47, "https://".length());
                if (endIndex == -1) {
                    this.setContextAttribute("[$PORTAL_URL$]", this._entryURL);
                } else {
                    this.setContextAttribute("[$PORTAL_URL$]", this._entryURL.substring(0, endIndex));
                }
            }
        } else {
            this.setContextAttribute("[$PORTAL_URL$]", company.getPortalURL(this.groupId));
        }
        if (this.groupId > 0L) {
            this.setLocalizedContextAttribute("[$SITE_NAME$]", new EscapableLocalizableFunction(locale -> this._getGroupDescriptiveName(this.groupId, (Locale)locale)));
        }
        if (this.creatorUserId > 0L && Validator.isNotNull(this._contextCreatorUserPrefix)) {
            this.setContextAttribute("[$" + this._contextCreatorUserPrefix + "_USER_ADDRESS$]", PortalUtil.getUserEmailAddress(this.creatorUserId));
            this.setContextAttribute("[$" + this._contextCreatorUserPrefix + "_USER_NAME$]", PortalUtil.getUserName(this.creatorUserId, ""));
        }
        if (this.uniqueMailId) {
            this._mailIdIds = ArrayUtil.append(this._mailIdIds, PortalUUIDUtil.generate());
        }
        this.mailId = PortalUtil.getMailId(company.getMx(), this._mailIdPopPortletPrefix, this._mailIdIds);
    }

    public boolean isBulk() {
        return this.bulk;
    }

    public void sendEmailNotification(long userId) throws Exception {
        this.sendEmailNotification(UserLocalServiceUtil.getUser((long)userId));
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setBulk(boolean bulk) {
        this.bulk = bulk;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    @Deprecated
    public void setCompanyId(long companyId) {
    }

    public void setContextAttribute(String key, EscapableObject<String> value) {
        this._context.put(key, value);
        this._context.put(this._getFilterKey(key, "attr"), new HTMLAtributeEscapableObject<String>(value.getOriginalValue(), true));
        this._context.put(this._getFilterKey(key, "html"), new HtmlEscapableObject<String>(value.getOriginalValue(), true));
        this._context.put(this._getFilterKey(key, "uri"), new URIEscapableObject<String>(value.getOriginalValue(), true));
    }

    public void setContextAttribute(String key, Object value) {
        this.setContextAttribute(key, value, true);
    }

    public void setContextAttribute(String key, Object value, boolean escape) {
        this.setContextAttribute(key, new HtmlEscapableObject<String>(String.valueOf(value), escape));
    }

    public void setContextAttributes(Object ... values) {
        for (int i = 0; i < values.length; i += 2) {
            this.setContextAttribute(String.valueOf(values[i]), values[i + 1]);
        }
    }

    public void setContextCreatorUserPrefix(String contextCreatorUserPrefix) {
        this._contextCreatorUserPrefix = contextCreatorUserPrefix;
    }

    public void setCreatorUserId(long creatorUserId) {
        this.creatorUserId = creatorUserId;
    }

    public void setCurrentUserId(long currentUserId) {
        this.currentUserId = currentUserId;
    }

    public void setEntryTitle(String entryTitle) {
        this._entryTitle = entryTitle;
    }

    public void setEntryURL(String entryURL) {
        this._entryURL = entryURL;
    }

    public void setFrom(String fromAddress, String fromName) {
        this.fromAddress = fromAddress;
        this.fromName = fromName;
    }

    public void setGroupId(long groupId) {
        this.groupId = groupId;
    }

    public void setHtmlFormat(boolean htmlFormat) {
        this.htmlFormat = htmlFormat;
    }

    public void setInReplyTo(String inReplyTo) {
        this.inReplyTo = inReplyTo;
    }

    public void setLocalizedBodyMap(Map<Locale, String> localizedBodyMap) {
        this.localizedBodyMap = localizedBodyMap;
    }

    public void setLocalizedContextAttribute(String key, EscapableLocalizableFunction value) {
        this._localizedContext.put(key, value);
    }

    public <T extends Serializable & Function<Locale, String>> void setLocalizedContextAttribute(String key, T function) {
        this.setLocalizedContextAttribute(key, function, true);
    }

    public <T extends Serializable & Function<Locale, String>> void setLocalizedContextAttribute(String key, T function, boolean escape) {
        this.setLocalizedContextAttribute(key, new EscapableLocalizableFunction(function, escape));
    }

    public void setLocalizedContextAttributeWithFunction(String key, Function<Locale, String> function) {
        this.setLocalizedContextAttributeWithFunction(key, function, true);
    }

    public void setLocalizedContextAttributeWithFunction(String key, Function<Locale, String> function, boolean escape) {
        this.setLocalizedContextAttribute(key, new EscapableLocalizableFunction(function, escape));
    }

    public void setLocalizedPortletTitleMap(Map<Locale, String> localizedPortletTitleMap) {
        this.localizedPortletTitleMap = localizedPortletTitleMap;
    }

    public void setLocalizedSubjectMap(Map<Locale, String> localizedSubjectMap) {
        this.localizedSubjectMap = localizedSubjectMap;
    }

    public void setMailId(String popPortletPrefix, Object ... ids) {
        this._mailIdPopPortletPrefix = popPortletPrefix;
        this._mailIdIds = ids;
    }

    public void setNotificationClassName(String notificationClassName) {
        this._notificationClassName = notificationClassName;
    }

    @Deprecated
    public void setNotificationClassNameId(long notificationClassNameId) {
        ClassName className = ClassNameLocalServiceUtil.fetchByClassNameId((long)notificationClassNameId);
        if (className != null) {
            this._notificationClassName = className.getClassName();
        }
    }

    public void setNotificationType(int notificationType) {
        this._notificationType = notificationType;
    }

    public void setPortletId(String portletId) {
        this.portletId = portletId;
    }

    public void setReplyToAddress(String replyToAddress) {
        this.replyToAddress = replyToAddress;
    }

    public void setScopeGroupId(long scopeGroupId) {
        block2: {
            try {
                Group group = GroupLocalServiceUtil.getGroup((long)scopeGroupId);
                this.groupId = group.isLayout() ? group.getParentGroupId() : scopeGroupId;
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug(exception);
            }
        }
        this.scopeGroupId = scopeGroupId;
    }

    public void setSendToCurrentUser(boolean sendToCurrentUser) {
        this._sendToCurrentUser = sendToCurrentUser;
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void setSMTPAccount(SMTPAccount smtpAccount) {
        this.smtpAccount = smtpAccount;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setUniqueMailId(boolean uniqueMailId) {
        this.uniqueMailId = uniqueMailId;
    }

    protected void deleteSubscription(Subscription subscription) throws Exception {
        SubscriptionLocalServiceUtil.deleteSubscription((long)subscription.getSubscriptionId());
    }

    protected boolean hasPermission(Subscription subscription, String className, long classPK, User user) throws Exception {
        if (subscription.getClassName() == null) {
            return false;
        }
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        Boolean hasPermission = null;
        if (Validator.isNotNull(className) && ((hasPermission = ModelResourcePermissionUtil.contains((PermissionChecker)permissionChecker, (long)this.groupId, (String)className, (long)classPK, (String)"VIEW")) == null || !hasPermission.booleanValue())) {
            return false;
        }
        hasPermission = this.hasSubscribePermission(permissionChecker, subscription);
        return hasPermission != null && hasPermission != false;
    }

    protected boolean hasPermission(Subscription subscription, User user) throws Exception {
        return this.hasPermission(subscription, this._className, this._classPK, user);
    }

    protected Boolean hasSubscribePermission(PermissionChecker permissionChecker, Subscription subscription) throws PortalException {
        ResourceAction resourceAction = ResourceActionLocalServiceUtil.fetchResourceAction((String)subscription.getClassName(), (String)"SUBSCRIBE");
        if (resourceAction != null) {
            return ModelResourcePermissionUtil.contains((PermissionChecker)permissionChecker, (long)this.groupId, (String)subscription.getClassName(), (long)subscription.getClassPK(), (String)"SUBSCRIBE");
        }
        return Boolean.TRUE;
    }

    protected void notifyPersistedSubscriber(Subscription subscription, boolean notifyImmediately) throws Exception {
        this.notifyPersistedSubscriber(subscription, this._className, this._classPK, notifyImmediately);
    }

    protected void notifyPersistedSubscriber(Subscription subscription, String className, long classPK, boolean notifyImmediately) throws Exception {
        User user = UserLocalServiceUtil.fetchUserById((long)subscription.getUserId());
        if (user == null) {
            if (_log.isInfoEnabled()) {
                _log.info("Subscription " + subscription.getSubscriptionId() + " is stale and will be deleted");
            }
            this.deleteSubscription(subscription);
            return;
        }
        String emailAddress = user.getEmailAddress();
        if (notifyImmediately) {
            if (this._sentEmailAddresses.contains(emailAddress)) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Do not send a duplicate email to " + emailAddress);
                }
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Add " + emailAddress + " to the list of users who have received an email");
            }
            this._sentEmailAddresses.add(emailAddress);
        } else {
            if (this._delayedSentEmailAddresses.contains(emailAddress)) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Do not send a duplicate email to " + emailAddress);
                }
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Add " + emailAddress + " to the list of users who will receive an email");
            }
            this._delayedSentEmailAddresses.add(emailAddress);
        }
        if (!user.isActive()) {
            if (_log.isDebugEnabled()) {
                _log.debug("Skip inactive user " + user.getUserId());
            }
            return;
        }
        try {
            if (!this.hasPermission(subscription, className, classPK, user)) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Skip unauthorized user " + user.getUserId());
                }
                return;
            }
        }
        catch (Exception exception) {
            _log.error(exception);
            return;
        }
        this._notifyHooks(Hook.Event.PERSISTED_SUBSCRIBER_FOUND, subscription);
        this.sendNotification(user, notifyImmediately);
    }

    protected void notifyRuntimeSubscriber(InternetAddress to, Locale locale) throws Exception {
        String emailAddress;
        long companyId = CompanyThreadLocal.getNonsystemCompanyId();
        User user = UserLocalServiceUtil.fetchUserByEmailAddress((long)companyId, (String)(emailAddress = to.getAddress()));
        if (user == null) {
            if (_log.isInfoEnabled()) {
                _log.info(StringBundler.concat((Object[])new Object[]{"User with email address ", emailAddress, " does not exist for company ", companyId}));
            }
            if (this.bulk) {
                this._addBulkAddress(to);
                return;
            }
            this.sendEmail(to, locale);
        } else {
            if (!user.isActive()) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Skip inactive user " + user.getUserId());
                }
                return;
            }
            this.sendNotification(user, true);
        }
    }

    protected void populateNotificationEventJSONObject(JSONObject notificationEventJSONObject) {
        String command = null;
        if (this.serviceContext != null) {
            command = this.serviceContext.getCommand();
        }
        notificationEventJSONObject.put("className", this._className).put("classPK", this._classPK).put("command", command).put("context", this._context).put("entryTitle", this._entryTitle).put("entryURL", this._entryURL).put("localizedBodyMap", this.localizedBodyMap).put("localizedContext", this._localizedContext).put("localizedSubjectMap", this.localizedSubjectMap).put("mailId", this.mailId).put("notificationType", this._notificationType).put("portletId", this.portletId).put("userId", this.currentUserId);
    }

    protected void processMailMessage(MailMessage mailMessage, Locale locale) throws Exception {
        InternetAddress to = mailMessage.getTo()[0];
        MailTemplateContext mailTemplateContext = this._getBodyMailTemplateContext(locale, mailMessage.getFrom(), to);
        MailTemplate subjectMailTemplate = MailTemplateFactoryUtil.createMailTemplate((String)mailMessage.getSubject(), (boolean)false);
        String processedSubject = subjectMailTemplate.renderAsString(locale, mailTemplateContext);
        mailMessage.setSubject(processedSubject);
        MailTemplate bodyMailTemplate = MailTemplateFactoryUtil.createMailTemplate((String)mailMessage.getBody(), (boolean)true);
        String processedBody = bodyMailTemplate.renderAsString(locale, mailTemplateContext);
        mailMessage.setBody(processedBody);
        this._notifyHooks(Hook.Event.MAIL_MESSAGE_CREATED, mailMessage);
    }

    protected void sendEmail(InternetAddress to, Locale locale) throws Exception {
        MailTemplateContext mailTemplateContext = this._getBasicMailTemplateContext(locale);
        MailTemplate fromAddressMailTemplate = MailTemplateFactoryUtil.createMailTemplate((String)this.fromAddress, (boolean)false);
        MailTemplate fromNameMailTemplate = MailTemplateFactoryUtil.createMailTemplate((String)this.fromName, (boolean)false);
        InternetAddress from = new InternetAddress(fromAddressMailTemplate.renderAsString(locale, mailTemplateContext), fromNameMailTemplate.renderAsString(locale, mailTemplateContext));
        String processedSubject = this._getLocalizedValue(this.localizedSubjectMap, locale, this.subject);
        String processedBody = this._getLocalizedValue(this.localizedBodyMap, locale, this.body);
        MailMessage mailMessage = new MailMessage(from, to, processedSubject, processedBody, this.htmlFormat);
        if (this.fileAttachments != null) {
            for (FileAttachment fileAttachment : this.fileAttachments) {
                mailMessage.addFileAttachment(fileAttachment.getFile(), fileAttachment.getFileName());
            }
        }
        if (this.bulk && this._bulkAddresses != null) {
            mailMessage.setBulkAddresses(this._bulkAddresses.toArray(new InternetAddress[0]));
            this._bulkAddresses.clear();
        }
        if (this.inReplyTo != null) {
            mailMessage.setInReplyTo(this.inReplyTo);
        }
        mailMessage.setMessageId(this.mailId);
        if (this.replyToAddress != null) {
            MailTemplate replyToAddressMailTemplate = MailTemplateFactoryUtil.createMailTemplate((String)this.replyToAddress, (boolean)false);
            String processedReplyToAddress = replyToAddressMailTemplate.renderAsString(locale, mailTemplateContext);
            InternetAddress replyTo = new InternetAddress(processedReplyToAddress, processedReplyToAddress);
            mailMessage.setReplyTo(new InternetAddress[]{replyTo});
        }
        if (this.smtpAccount != null) {
            mailMessage.setSMTPAccount(this.smtpAccount);
        }
        this.processMailMessage(mailMessage, locale);
        MailServiceUtil.sendEmail((MailMessage)mailMessage);
    }

    protected void sendEmailNotification(User user) throws Exception {
        if (UserNotificationManagerUtil.isDeliver((long)user.getUserId(), (String)this.portletId, (long)this._getNotificationClassNameId(), (int)this._notificationType, (int)10000)) {
            InternetAddress to = new InternetAddress(user.getEmailAddress(), user.getFullName());
            if (this.bulk) {
                this._addBulkAddress(to);
                return;
            }
            this.sendEmail(to, user.getLocale());
        }
    }

    @Deprecated
    protected void sendNotification(User user) throws Exception {
        this.sendNotification(user, true);
    }

    protected void sendNotification(User user, boolean notifyImmediately) throws Exception {
        if (!this._sendToCurrentUser && this.currentUserId == user.getUserId()) {
            if (_log.isDebugEnabled()) {
                _log.debug("Skip user " + this.currentUserId);
            }
            return;
        }
        if (notifyImmediately) {
            this.sendEmailNotification(user);
        }
        this.sendUserNotification(user, notifyImmediately);
    }

    @Deprecated
    protected void sendUserNotification(User user) throws Exception {
        this.sendNotification(user, true);
    }

    protected void sendUserNotification(User user, boolean notifyImmediately) throws Exception {
        JSONObject notificationEventJSONObject = JSONFactoryUtil.createJSONObject();
        this.populateNotificationEventJSONObject(notificationEventJSONObject);
        if (UserNotificationManagerUtil.isDeliver((long)user.getUserId(), (String)this.portletId, (long)this._getNotificationClassNameId(), (int)this._notificationType, (int)10005)) {
            UserNotificationEventLocalServiceUtil.sendUserNotificationEvents((long)user.getUserId(), (String)this.portletId, (int)10005, (boolean)notifyImmediately, (boolean)false, (JSONObject)notificationEventJSONObject);
        }
        if (UserNotificationManagerUtil.isDeliver((long)user.getUserId(), (String)this.portletId, (long)this._getNotificationClassNameId(), (int)this._notificationType, (int)10002)) {
            UserNotificationEventLocalServiceUtil.sendUserNotificationEvents((long)user.getUserId(), (String)this.portletId, (int)10002, (boolean)notifyImmediately, (boolean)false, (JSONObject)notificationEventJSONObject);
        }
    }

    private void _addBulkAddress(InternetAddress internetAddress) {
        if (this._bulkAddresses == null) {
            this._bulkAddresses = new ArrayList<InternetAddress>();
        }
        this._bulkAddresses.add(internetAddress);
    }

    private MailTemplateContext _getBasicMailTemplateContext(Locale locale) {
        MailTemplateContextBuilder mailTemplateContextBuilder = MailTemplateFactoryUtil.createMailTemplateContextBuilder();
        String portletName = this._getPortletName(locale);
        mailTemplateContextBuilder.put("[$PORTLET_NAME$]", portletName);
        mailTemplateContextBuilder.put("[$PORTLET_TITLE$]", this._getPortletTitle(portletName, locale));
        this._context.forEach((arg_0, arg_1) -> ((MailTemplateContextBuilder)mailTemplateContextBuilder).put(arg_0, arg_1));
        this._localizedContext.forEach((arg_0, arg_1) -> ((MailTemplateContextBuilder)mailTemplateContextBuilder).put(arg_0, arg_1));
        return mailTemplateContextBuilder.build();
    }

    private MailTemplateContext _getBodyMailTemplateContext(Locale locale, InternetAddress from, InternetAddress to) {
        MailTemplateContextBuilder mailTemplateContextBuilder = MailTemplateFactoryUtil.createMailTemplateContextBuilder();
        mailTemplateContextBuilder.put("[$FROM_ADDRESS$]", from.getAddress());
        mailTemplateContextBuilder.put("[$FROM_NAME$]", new EscapableObject<String>(GetterUtil.getString(from.getPersonal(), from.getAddress())));
        mailTemplateContextBuilder.put("[$TO_ADDRESS$]", new EscapableObject<String>(to.getAddress()));
        mailTemplateContextBuilder.put("[$TO_NAME$]", new EscapableObject<String>(GetterUtil.getString(to.getPersonal(), to.getAddress())));
        MailTemplateContext mailTemplateContext = mailTemplateContextBuilder.build();
        return mailTemplateContext.aggregateWith(this._getBasicMailTemplateContext(locale));
    }

    private String _getFilterKey(String key, String escapeMode) {
        int i = key.lastIndexOf("$]");
        if (i != key.length() - 2) {
            throw new IllegalArgumentException("Subscription template key is not syntactically correct: " + key);
        }
        return StringBundler.concat(key.substring(0, i), "|", escapeMode, "$]");
    }

    private String _getGroupDescriptiveName(long groupId, Locale locale) {
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            return group.getDescriptiveName(locale);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug(portalException);
            }
            return "";
        }
    }

    private <T> List<Hook<T>> _getHooks(Hook.Event<T> event) {
        return this._hooks.computeIfAbsent(event, key -> new ArrayList());
    }

    private String _getLocalizedValue(Map<Locale, String> localizedValueMap, Locale locale, String defaultValue) {
        return GetterUtil.get(MapUtil.getWithFallbackKey(localizedValueMap, locale, LocaleUtil.getDefault()), defaultValue);
    }

    private long _getNotificationClassNameId() {
        if (this._notificationClassName == null) {
            return 0L;
        }
        return ClassNameLocalServiceUtil.getClassNameId((String)this._notificationClassName);
    }

    private String _getPortletName(Locale locale) {
        if (Validator.isNull(this.portletId)) {
            return "";
        }
        return PortalUtil.getPortletTitle(this.portletId, locale);
    }

    private String _getPortletTitle(String portletName, Locale locale) {
        return this._getLocalizedValue(this.localizedPortletTitleMap, locale, portletName);
    }

    private <T> void _notifyHooks(Hook.Event<T> event, T payload) {
        List<Hook<Hook>> hooks = this._getHooks(event);
        hooks.forEach(hook -> hook.process(payload));
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        String contextName = objectInputStream.readUTF();
        if (!contextName.equals("IS NULL")) {
            this._classLoader = ClassLoaderPool.getClassLoader((String)contextName);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        String contextName = "IS NULL";
        if (this._classLoader != null) {
            contextName = ClassLoaderPool.getContextName((ClassLoader)this._classLoader);
        }
        objectOutputStream.writeUTF(contextName);
    }

    private static class URIEscapableObject<T>
    extends EscapableObject<T> {
        public URIEscapableObject(T originalValue) {
            super(originalValue);
        }

        public URIEscapableObject(T originalValue, boolean escape) {
            super(originalValue, escape);
        }

        @Override
        protected String escape(T value) {
            return URLCodec.encodeURL(String.valueOf(value));
        }
    }

    private static class HTMLAtributeEscapableObject<T>
    extends EscapableObject<T> {
        public HTMLAtributeEscapableObject(T originalValue) {
            super(originalValue);
        }

        public HTMLAtributeEscapableObject(T originalValue, boolean escape) {
            super(originalValue, escape);
        }

        @Override
        protected String escape(T value) {
            return HtmlUtil.escapeAttribute(String.valueOf(value));
        }
    }

    public static interface Hook<T> {
        public void process(T var1);

        public static interface Event<S> {
            public static final Event<MailMessage> MAIL_MESSAGE_CREATED = new Event<MailMessage>(){};
            public static final Event<Subscription> PERSISTED_SUBSCRIBER_FOUND = new Event<Subscription>(){};
        }
    }
}

