/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class DefaultLayoutPrototypesUtil {
    public static Layout addLayout(LayoutSet layoutSet, String nameKey, String friendlyURL, String layoutTemplateId) throws Exception {
        Group group = layoutSet.getGroup();
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            nameMap.put(locale, LanguageUtil.get((Locale)locale, (String)nameKey));
        }
        Layout layout = LayoutLocalServiceUtil.addLayout((long)group.getCreatorUserId(), (long)group.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (long)0L, nameMap, null, null, null, null, (String)"portlet", (String)"", (boolean)false, HashMapBuilder.put(LocaleUtil.getDefault(), friendlyURL).build(), (ServiceContext)new ServiceContext());
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, layoutTemplateId, false);
        return layout;
    }

    public static String addPortletId(Layout layout, String portletId, String columnId) throws Exception {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        portletId = layoutTypePortlet.addPortletId(0L, portletId, columnId, -1, false);
        DefaultLayoutPrototypesUtil.updateLayout(layout);
        DefaultLayoutPrototypesUtil.addResourcePermissions(layout, portletId);
        return portletId;
    }

    public static PortletPreferences updatePortletSetup(Layout layout, String portletId, Map<String, String> preferences) throws Exception {
        PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
        for (Map.Entry<String, String> entry : preferences.entrySet()) {
            portletSetup.setValue(entry.getKey(), entry.getValue());
        }
        portletSetup.store();
        return portletSetup;
    }

    protected static void addResourcePermissions(Layout layout, String portletId) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
        PortalUtil.addPortletDefaultResource(layout.getCompanyId(), layout, portlet);
    }

    protected static void updateLayout(Layout layout) throws Exception {
        LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
    }
}

