/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.language;

import com.liferay.portal.kernel.language.constants.LanguageConstants;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class LanguageValidator {
    public static boolean isSpecialPropertyKey(String key) {
        return ArrayUtil.contains(LanguageConstants.KEYS_SPECIAL_PROPERTIES, key);
    }

    public static boolean isValid(String key, String value) {
        if (key.equals("lang.dir")) {
            return ArrayUtil.contains(LanguageConstants.VALUES_DIR, value);
        }
        if (key.equals("lang.line.begin") || key.equals("lang.line.end")) {
            return ArrayUtil.contains(LanguageConstants.VALUES_LINE, value);
        }
        if (key.equals("lang.user.default.portrait")) {
            return ArrayUtil.contains(LanguageConstants.VALUES_USER_DEFAULT_PORTRAIT, value);
        }
        if (key.equals("lang.user.initials.field.names")) {
            return LanguageValidator._isValidUserInitialsFieldNamesValue(value);
        }
        if (key.equals("lang.user.name.field.names")) {
            return LanguageValidator._isValidUserNameFieldNamesValue(value);
        }
        if (key.equals("lang.user.name.prefix.values") || key.equals("lang.user.name.suffix.values")) {
            return Validator.isNotNull(value);
        }
        if (key.equals("lang.user.name.required.field.names")) {
            return LanguageValidator._isValidUserNameRequiredFieldNamesValue(value);
        }
        return true;
    }

    private static boolean _isValidUserInitialsFieldNamesValue(String value) {
        String[] valueParts;
        for (String valuePart : valueParts = StringUtil.split(value)) {
            if (ArrayUtil.contains(LanguageConstants.VALUES_USER_INITIALS_FIELD_NAMES, valuePart)) continue;
            return false;
        }
        return true;
    }

    private static boolean _isValidUserNameFieldNamesValue(String value) {
        Object[] valueParts = StringUtil.split(value);
        if (ArrayUtil.isEmpty(valueParts) || !ArrayUtil.contains(valueParts, "first-name") || !ArrayUtil.contains(valueParts, "last-name")) {
            return false;
        }
        if (ArrayUtil.contains(valueParts, "prefix") && !((String)valueParts[0]).equals("prefix")) {
            return false;
        }
        int index = valueParts.length - 1;
        if (ArrayUtil.contains(valueParts, "suffix") && !((String)valueParts[index]).equals("suffix")) {
            return false;
        }
        for (Object valuePart : valueParts) {
            if (ArrayUtil.contains(LanguageConstants.VALUES_USER_NAME_FIELD_NAMES, valuePart)) continue;
            return false;
        }
        return true;
    }

    private static boolean _isValidUserNameRequiredFieldNamesValue(String value) {
        Object[] valueParts = StringUtil.split(value);
        if (ArrayUtil.isEmpty(valueParts)) {
            return false;
        }
        for (Object valuePart : valueParts) {
            if (ArrayUtil.contains(LanguageConstants.VALUES_USER_NAME_FIELD_NAMES, valuePart)) continue;
            return false;
        }
        return true;
    }
}

