/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.lang.reflect.InvocationTargetException;

public class PortalClassInvoker {
    public static Object invoke(MethodKey methodKey, Object ... arguments) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(PortalClassLoaderUtil.getClassLoader());
            MethodHandler methodHandler = new MethodHandler(methodKey, arguments);
            Object object = methodHandler.invoke();
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof Error) {
                throw new SystemException((Throwable)invocationTargetException);
            }
            throw (Exception)throwable;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }
}

