/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.highlight.HighlightUtil;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;

public class StringUtil {
    protected static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] _RANDOM_STRING_CHAR_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final Log _log = LogFactoryUtil.getLog(StringUtil.class);
    private static final String[] _emptyStringArray = new String[0];

    public static String add(String s, String add) {
        return StringUtil.add(s, add, ",");
    }

    public static String add(String s, String add, String delimiter) {
        return StringUtil.add(s, add, delimiter, false);
    }

    public static String add(String s, String add, String delimiter, boolean allowDuplicates) {
        if (add == null || delimiter == null) {
            return null;
        }
        if (s == null) {
            s = "";
        }
        if (allowDuplicates || !StringUtil.contains(s, add, delimiter)) {
            StringBundler sb = new StringBundler(4);
            sb.append(s);
            if (Validator.isNull(s) || s.endsWith(delimiter)) {
                sb.append(add);
                sb.append(delimiter);
            } else {
                sb.append(delimiter);
                sb.append(add);
                sb.append(delimiter);
            }
            s = sb.toString();
        }
        return s;
    }

    public static String appendParentheticalSuffix(String s, int suffix) {
        if (Pattern.matches(".* \\(" + String.valueOf(suffix - 1) + "\\)", s)) {
            int pos = s.lastIndexOf(" (");
            s = s.substring(0, pos);
        }
        return StringUtil.appendParentheticalSuffix(s, String.valueOf(suffix));
    }

    public static String appendParentheticalSuffix(String s, String suffix) {
        StringBundler sb = new StringBundler(5);
        sb.append(s);
        sb.append(" ");
        sb.append("(");
        sb.append(suffix);
        sb.append(")");
        return sb.toString();
    }

    public static String bytesToHexString(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i * 2] = HEX_DIGITS[(bytes[i] & 0xFF) >> 4];
            chars[i * 2 + 1] = HEX_DIGITS[bytes[i] & 0xF];
        }
        return new String(chars);
    }

    public static boolean contains(String s, String text) {
        return StringUtil.contains(s, text, ",");
    }

    public static boolean contains(String s, String text, String delimiter) {
        String dtd;
        int pos;
        if (s == null || text == null || delimiter == null) {
            return false;
        }
        if (!s.endsWith(delimiter)) {
            s = s.concat(delimiter);
        }
        if ((pos = s.indexOf(dtd = delimiter.concat(text).concat(delimiter))) == -1) {
            String td = text.concat(delimiter);
            return s.startsWith(td);
        }
        return true;
    }

    public static boolean containsIgnoreCase(String s, String text) {
        return StringUtil.containsIgnoreCase(s, text, ",");
    }

    public static boolean containsIgnoreCase(String s, String text, String delimiter) {
        if (s == null || text == null || delimiter == null) {
            return false;
        }
        return StringUtil.contains(StringUtil.toLowerCase(s), StringUtil.toLowerCase(text), delimiter);
    }

    public static int count(String s, String text) {
        if (s == null || s.length() == 0 || text == null || text.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = s.indexOf(text);
        while (pos != -1) {
            pos = s.indexOf(text, pos + text.length());
            ++count;
        }
        return count;
    }

    public static boolean endsWith(String s, char end) {
        return StringUtil.endsWith(s, Character.valueOf(end).toString());
    }

    public static boolean endsWith(String s, String end) {
        if (s == null || end == null) {
            return false;
        }
        if (end.length() > s.length()) {
            return false;
        }
        String temp = s.substring(s.length() - end.length());
        return StringUtil.equalsIgnoreCase(temp, end);
    }

    public static boolean equalsIgnoreBreakLine(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        s1 = StringUtil.replace(s1, new String[]{"\r\n", "\n"}, new String[]{"", ""});
        s2 = StringUtil.replace(s2, new String[]{"\r\n", "\n"}, new String[]{"", ""});
        if (s1.length() != s2.length()) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 == (c2 = s2.charAt(i))) continue;
            if (c1 > '\u007f' || c2 > '\u007f') {
                if (Character.toLowerCase(c1) == Character.toLowerCase(c2) || Character.toUpperCase(c1) == Character.toUpperCase(c2)) continue;
                return false;
            }
            if (c1 < 'A' || c1 > 'z' || c2 < 'A' || c2 > 'z') {
                return false;
            }
            int delta = c1 - c2;
            if (delta == 32 || delta == -32) continue;
            return false;
        }
        return true;
    }

    public static String extract(String s, char[] chars) {
        if (s == null) {
            return "";
        }
        StringBundler sb = new StringBundler();
        block0: for (char c1 : s.toCharArray()) {
            for (char c2 : chars) {
                if (c1 != c2) continue;
                sb.append(c1);
                continue block0;
            }
        }
        return sb.toString();
    }

    public static String extractChars(String s) {
        char[] chars;
        if (s == null) {
            return "";
        }
        StringBundler sb = new StringBundler();
        for (char c : chars = s.toCharArray()) {
            if (!Validator.isChar(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String extractDigits(String s) {
        char[] chars;
        if (s == null) {
            return "";
        }
        StringBundler sb = new StringBundler();
        for (char c : chars = s.toCharArray()) {
            if (!Validator.isDigit(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String extractFirst(String s, char delimiter) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(delimiter);
        if (index < 0) {
            return null;
        }
        return s.substring(0, index);
    }

    public static String extractFirst(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(delimiter);
        if (index < 0) {
            return null;
        }
        return s.substring(0, index);
    }

    public static String extractLast(String s, char delimiter) {
        if (s == null) {
            return null;
        }
        int index = s.lastIndexOf(delimiter);
        if (index < 0) {
            return null;
        }
        return s.substring(index + 1);
    }

    public static String extractLast(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        int index = s.lastIndexOf(delimiter);
        if (index < 0) {
            return null;
        }
        return s.substring(index + delimiter.length());
    }

    public static String extractLeadingDigits(String s) {
        char[] chars;
        if (s == null) {
            return "";
        }
        StringBundler sb = new StringBundler();
        for (char c : chars = s.toCharArray()) {
            if (!Validator.isDigit(c)) {
                return sb.toString();
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Deprecated
    public static String highlight(String s, String[] queryTerms) {
        return HighlightUtil.highlight((String)s, (String[])queryTerms);
    }

    @Deprecated
    public static String highlight(String s, String[] queryTerms, String highlight1, String highlight2) {
        return HighlightUtil.highlight((String)s, (String[])queryTerms, (String)highlight1, (String)highlight2);
    }

    public static int indexOfAny(String s, char[] chars) {
        if (s == null) {
            return -1;
        }
        return StringUtil.indexOfAny(s, chars, 0, s.length() - 1);
    }

    public static int indexOfAny(String s, char[] chars, int fromIndex) {
        if (s == null) {
            return -1;
        }
        return StringUtil.indexOfAny(s, chars, fromIndex, s.length() - 1);
    }

    public static int indexOfAny(String s, char[] chars, int fromIndex, int toIndex) {
        if (s == null || toIndex < fromIndex) {
            return -1;
        }
        if (ArrayUtil.isEmpty((char[])chars)) {
            return -1;
        }
        if (fromIndex >= s.length()) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex >= s.length()) {
            toIndex = s.length() - 1;
        }
        for (int i = fromIndex; i <= toIndex; ++i) {
            char c = s.charAt(i);
            for (int j = 0; j < chars.length; ++j) {
                if (c != chars[j]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfAny(String s, String[] texts) {
        if (s == null) {
            return -1;
        }
        return StringUtil.indexOfAny(s, texts, 0, s.length() - 1);
    }

    public static int indexOfAny(String s, String[] texts, int fromIndex) {
        if (s == null) {
            return -1;
        }
        return StringUtil.indexOfAny(s, texts, fromIndex, s.length() - 1);
    }

    public static int indexOfAny(String s, String[] texts, int fromIndex, int toIndex) {
        if (s == null || toIndex < fromIndex) {
            return -1;
        }
        if (ArrayUtil.isEmpty((Object[])texts)) {
            return -1;
        }
        if (fromIndex >= s.length()) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex >= s.length()) {
            toIndex = s.length() - 1;
        }
        for (int i = fromIndex; i <= toIndex; ++i) {
            for (int j = 0; j < texts.length; ++j) {
                if (texts[j] == null || i + texts[j].length() > toIndex + 1 || !s.startsWith(texts[j], i)) continue;
                return i;
            }
        }
        return -1;
    }

    public static String insert(String s, String insert, int offset) {
        if (s == null) {
            return null;
        }
        if (insert == null) {
            return s;
        }
        if (offset > s.length()) {
            return s.concat(insert);
        }
        String prefix = s.substring(0, offset);
        String postfix = s.substring(offset);
        return prefix.concat(insert).concat(postfix);
    }

    public static boolean isLowerCase(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(c <= '\u007f' ? c >= 'A' && c <= 'Z' : Character.isLetter(c) && Character.isUpperCase(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(c <= '\u007f' ? c >= 'a' && c <= 'z' : Character.isLetter(c) && Character.isLowerCase(c))) continue;
            return false;
        }
        return true;
    }

    public static int lastIndexOfAny(String s, char[] chars) {
        if (s == null) {
            return -1;
        }
        return StringUtil.lastIndexOfAny(s, chars, 0, s.length() - 1);
    }

    public static int lastIndexOfAny(String s, char[] chars, int toIndex) {
        if (s == null) {
            return -1;
        }
        return StringUtil.lastIndexOfAny(s, chars, 0, toIndex);
    }

    public static int lastIndexOfAny(String s, char[] chars, int fromIndex, int toIndex) {
        if (s == null || toIndex < fromIndex) {
            return -1;
        }
        if (ArrayUtil.isEmpty((char[])chars)) {
            return -1;
        }
        if (fromIndex >= s.length()) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex >= s.length()) {
            toIndex = s.length() - 1;
        }
        for (int i = toIndex; i >= fromIndex; --i) {
            char c = s.charAt(i);
            for (int j = 0; j < chars.length; ++j) {
                if (c != chars[j]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOfAny(String s, String[] texts) {
        if (s == null) {
            return -1;
        }
        return StringUtil.lastIndexOfAny(s, texts, 0, s.length() - 1);
    }

    public static int lastIndexOfAny(String s, String[] texts, int toIndex) {
        if (s == null) {
            return -1;
        }
        return StringUtil.lastIndexOfAny(s, texts, 0, toIndex);
    }

    public static int lastIndexOfAny(String s, String[] texts, int fromIndex, int toIndex) {
        if (s == null || toIndex < fromIndex) {
            return -1;
        }
        if (ArrayUtil.isEmpty((Object[])texts)) {
            return -1;
        }
        if (fromIndex >= s.length()) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex >= s.length()) {
            toIndex = s.length() - 1;
        }
        for (int i = toIndex; i >= fromIndex; --i) {
            for (int j = 0; j < texts.length; ++j) {
                if (texts[j] == null || i + texts[j].length() > toIndex + 1 || !s.startsWith(texts[j], i)) continue;
                return i;
            }
        }
        return -1;
    }

    public static String lowerCase(String s) {
        return StringUtil.toLowerCase(s);
    }

    public static void lowerCase(String ... array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = StringUtil.toLowerCase(array[i]);
            }
        }
    }

    public static String lowerCaseFirstLetter(String s) {
        char[] chars = s.toCharArray();
        if (chars[0] >= 'A' && chars[0] <= 'Z') {
            chars[0] = (char)(chars[0] + 32);
        }
        return new String(chars);
    }

    public static boolean matches(String s, String pattern) {
        String[] array;
        for (String element : array = pattern.split("\\*")) {
            int pos = s.indexOf(element);
            if (pos == -1) {
                return false;
            }
            s = s.substring(pos + element.length());
        }
        return true;
    }

    public static boolean matchesIgnoreCase(String s, String pattern) {
        return StringUtil.matches(StringUtil.lowerCase(s), StringUtil.lowerCase(pattern));
    }

    public static String merge(boolean[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(boolean[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String merge(char[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(char[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String merge(Collection<?> col) {
        return StringUtil.merge(col, ",");
    }

    public static String merge(Collection<?> col, String delimiter) {
        if (col == null) {
            return null;
        }
        return StringUtil.merge(col.toArray(new Object[col.size()]), delimiter);
    }

    public static String merge(double[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(double[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String merge(float[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(float[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String merge(int[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(int[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String merge(long[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(long[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String merge(Object[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(Object[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(array[i]).trim());
        }
        return sb.toString();
    }

    public static String merge(short[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(short[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(delimiter);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String quote(String s) {
        return StringUtil.quote(s, '\'');
    }

    public static String quote(String s, char quote) {
        if (s == null) {
            return null;
        }
        return StringUtil.quote(s, String.valueOf(quote));
    }

    public static String quote(String s, String quote) {
        if (s == null) {
            return null;
        }
        return quote.concat(s).concat(quote);
    }

    public static String randomId() {
        Random random = new Random();
        char[] chars = new char[4];
        for (int i = 0; i < 4; ++i) {
            chars[i] = (char)(97 + random.nextInt(26));
        }
        return new String(chars);
    }

    public static String randomize(String s) {
        return RandomUtil.shuffle((String)s);
    }

    public static String randomString() {
        return StringUtil.randomString(8);
    }

    public static String randomString(int length) {
        Random random = new Random();
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(_RANDOM_STRING_CHAR_TABLE.length);
            chars[i] = _RANDOM_STRING_CHAR_TABLE[index];
        }
        return new String(chars);
    }

    public static String read(ClassLoader classLoader, String name) throws IOException {
        return StringUtil.read(classLoader, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(ClassLoader classLoader, String name, boolean all) throws IOException {
        String string;
        if (all) {
            StringBundler sb = new StringBundler();
            Enumeration<URL> enu = classLoader.getResources(name);
            while (enu.hasMoreElements()) {
                InputStream is;
                block8: {
                    URL url = enu.nextElement();
                    is = url.openStream();
                    if (is == null) {
                        throw new IOException("Unable to open resource at " + url.toString());
                    }
                    try {
                        String s = StringUtil.read(is);
                        if (s == null) break block8;
                        sb.append(s);
                        sb.append("\n");
                    }
                    catch (Throwable throwable) {
                        StreamUtil.cleanUp((Closeable[])new Closeable[]{is});
                        throw throwable;
                    }
                }
                StreamUtil.cleanUp((Closeable[])new Closeable[]{is});
            }
            return sb.toString().trim();
        }
        InputStream is = classLoader.getResourceAsStream(name);
        if (is == null) {
            throw new IOException("Unable to open resource in class loader " + name);
        }
        try {
            String s;
            string = s = StringUtil.read(is);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp((Closeable[])new Closeable[]{is});
            throw throwable;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{is});
        return string;
    }

    public static String read(InputStream is) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new InputStreamReader(is));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
        }
        return sb.toString().trim();
    }

    public static void readLines(InputStream is, Collection<String> lines) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new InputStreamReader(is));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                lines.add(line);
            }
        }
    }

    @Deprecated
    public static String remove(String s, String element) {
        return StringUtil.removeFromList(s, element, ",");
    }

    @Deprecated
    public static String remove(String s, String element, String delimiter) {
        return StringUtil.removeFromList(s, element, delimiter);
    }

    public static String removeFromList(String s, String element) {
        return StringUtil.removeFromList(s, element, ",");
    }

    public static String removeFromList(String s, String element, String delimiter) {
        if (s == null || element == null || delimiter == null) {
            return null;
        }
        if (Validator.isNotNull(s) && !s.endsWith(delimiter)) {
            s = s + delimiter;
        }
        String drd = delimiter.concat(element).concat(delimiter);
        String rd = element.concat(delimiter);
        while (StringUtil.contains(s, element, delimiter)) {
            int y;
            int x;
            int pos = s.indexOf(drd);
            if (pos == -1) {
                if (!s.startsWith(rd)) continue;
                x = element.length() + delimiter.length();
                y = s.length();
                s = s.substring(x, y);
                continue;
            }
            x = pos + element.length() + delimiter.length();
            y = s.length();
            String temp = s.substring(0, pos);
            s = temp.concat(s.substring(x, y));
        }
        return s;
    }

    public static String replace(String s, char oldSub, char newSub) {
        if (s == null) {
            return null;
        }
        return s.replace(oldSub, newSub);
    }

    public static String replace(String s, char oldSub, String newSub) {
        char[] chars;
        if (s == null || newSub == null) {
            return null;
        }
        StringBundler sb = new StringBundler(s.length() + 5 * newSub.length());
        for (char c : chars = s.toCharArray()) {
            if (c == oldSub) {
                sb.append(newSub);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String replace(String s, String oldSub, String newSub) {
        return StringUtil.replace(s, oldSub, newSub, 0);
    }

    public static String replace(String s, String oldSub, String newSub, int fromIndex) {
        int y;
        if (s == null) {
            return null;
        }
        if (oldSub == null || oldSub.equals("")) {
            return s;
        }
        if (newSub == null) {
            newSub = "";
        }
        if ((y = s.indexOf(oldSub, fromIndex)) >= 0) {
            StringBundler sb = new StringBundler();
            int length = oldSub.length();
            int x = 0;
            while (x <= y) {
                sb.append(s.substring(x, y));
                sb.append(newSub);
                x = y + length;
                y = s.indexOf(oldSub, x);
            }
            sb.append(s.substring(x));
            return sb.toString();
        }
        return s;
    }

    public static String replace(String s, String begin, String end, Map<String, String> values) {
        StringBundler sb = StringUtil.replaceToStringBundler(s, begin, end, values);
        return sb.toString();
    }

    public static String replace(String s, String[] oldSubs, String[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        for (int i = 0; i < oldSubs.length; ++i) {
            s = StringUtil.replace(s, oldSubs[i], newSubs[i]);
        }
        return s;
    }

    public static String replace(String s, String[] oldSubs, String[] newSubs, boolean exactMatch) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        if (!exactMatch) {
            return StringUtil.replace(s, oldSubs, newSubs);
        }
        for (int i = 0; i < oldSubs.length; ++i) {
            s = s.replaceAll("\\b" + oldSubs[i] + "\\b", newSubs[i]);
        }
        return s;
    }

    public static String replaceFirst(String s, char oldSub, char newSub) {
        if (s == null) {
            return null;
        }
        return StringUtil.replaceFirst(s, String.valueOf(oldSub), String.valueOf(newSub));
    }

    public static String replaceFirst(String s, char oldSub, String newSub) {
        if (s == null || newSub == null) {
            return null;
        }
        return StringUtil.replaceFirst(s, String.valueOf(oldSub), newSub);
    }

    public static String replaceFirst(String s, String oldSub, String newSub) {
        return StringUtil.replaceFirst(s, oldSub, newSub, 0);
    }

    public static String replaceFirst(String s, String oldSub, String newSub, int fromIndex) {
        if (s == null || oldSub == null || newSub == null) {
            return null;
        }
        if (oldSub.equals(newSub)) {
            return s;
        }
        int y = s.indexOf(oldSub, fromIndex);
        if (y >= 0) {
            return s.substring(0, y).concat(newSub).concat(s.substring(y + oldSub.length()));
        }
        return s;
    }

    public static String replaceFirst(String s, String[] oldSubs, String[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        for (int i = 0; i < oldSubs.length; ++i) {
            s = StringUtil.replaceFirst(s, oldSubs[i], newSubs[i]);
        }
        return s;
    }

    public static String replaceLast(String s, char oldSub, char newSub) {
        if (s == null) {
            return null;
        }
        return StringUtil.replaceLast(s, String.valueOf(oldSub), String.valueOf(newSub));
    }

    public static String replaceLast(String s, char oldSub, String newSub) {
        if (s == null || newSub == null) {
            return null;
        }
        return StringUtil.replaceLast(s, String.valueOf(oldSub), newSub);
    }

    public static String replaceLast(String s, String oldSub, String newSub) {
        if (s == null || oldSub == null || newSub == null) {
            return null;
        }
        if (oldSub.equals(newSub)) {
            return s;
        }
        int y = s.lastIndexOf(oldSub);
        if (y >= 0) {
            return s.substring(0, y).concat(newSub).concat(s.substring(y + oldSub.length()));
        }
        return s;
    }

    public static String replaceLast(String s, String[] oldSubs, String[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        for (int i = 0; i < oldSubs.length; ++i) {
            s = StringUtil.replaceLast(s, oldSubs[i], newSubs[i]);
        }
        return s;
    }

    public static StringBundler replaceToStringBundler(String s, String begin, String end, Map<String, String> values) {
        if (Validator.isBlank(s) || Validator.isBlank(begin) || Validator.isBlank(end) || MapUtil.isEmpty(values)) {
            return new StringBundler(s);
        }
        StringBundler sb = new StringBundler(values.size() * 2 + 1);
        int pos = 0;
        while (true) {
            int x = s.indexOf(begin, pos);
            int y = s.indexOf(end, x + begin.length());
            if (x == -1 || y == -1) break;
            sb.append(s.substring(pos, x));
            String oldValue = s.substring(x + begin.length(), y);
            String newValue = values.get(oldValue);
            if (newValue == null) {
                newValue = oldValue;
            }
            sb.append(newValue);
            pos = y + end.length();
        }
        sb.append(s.substring(pos));
        return sb;
    }

    public static StringBundler replaceWithStringBundler(String s, String begin, String end, Map<String, StringBundler> values) {
        if (Validator.isBlank(s) || Validator.isBlank(begin) || Validator.isBlank(end) || MapUtil.isEmpty(values)) {
            return new StringBundler(s);
        }
        int size = values.size() + 1;
        for (StringBundler valueSB : values.values()) {
            size += valueSB.index();
        }
        StringBundler sb = new StringBundler(size);
        int pos = 0;
        while (true) {
            int x = s.indexOf(begin, pos);
            int y = s.indexOf(end, x + begin.length());
            if (x == -1 || y == -1) break;
            sb.append(s.substring(pos, x));
            String oldValue = s.substring(x + begin.length(), y);
            StringBundler newValue = values.get(oldValue);
            if (newValue == null) {
                sb.append(oldValue);
            } else {
                sb.append(newValue);
            }
            pos = y + end.length();
        }
        sb.append(s.substring(pos));
        return sb;
    }

    public static String reverse(String s) {
        if (s == null) {
            return null;
        }
        char[] chars = s.toCharArray();
        char[] reverse = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            reverse[i] = chars[chars.length - i - 1];
        }
        return new String(reverse);
    }

    public static String safePath(String path) {
        return StringUtil.replace(path, "//", "/");
    }

    public static String shorten(String s) {
        return StringUtil.shorten(s, 20);
    }

    public static String shorten(String s, int length) {
        return StringUtil.shorten(s, length, "...");
    }

    public static String shorten(String s, int length, String suffix) {
        if (s == null || suffix == null) {
            return null;
        }
        if (s.length() <= length) {
            return s;
        }
        if (length < suffix.length()) {
            return s.substring(0, length);
        }
        int curLength = length;
        for (int j = curLength - suffix.length(); j >= 0; --j) {
            if (!Character.isWhitespace(s.charAt(j))) continue;
            curLength = j;
            break;
        }
        if (curLength == length) {
            curLength = length - suffix.length();
        }
        String temp = s.substring(0, curLength);
        return temp.concat(suffix);
    }

    public static String shorten(String s, String suffix) {
        return StringUtil.shorten(s, 20, suffix);
    }

    public static String[] split(String s) {
        return StringUtil.split(s, ',');
    }

    public static boolean[] split(String s, boolean x) {
        return StringUtil.split(s, ",", x);
    }

    public static String[] split(String s, char delimiter) {
        if (Validator.isNull(s)) {
            return _emptyStringArray;
        }
        if ((s = s.trim()).length() == 0) {
            return _emptyStringArray;
        }
        if (delimiter == '\r' || delimiter == '\n') {
            return StringUtil.splitLines(s);
        }
        ArrayList<String> nodeValues = new ArrayList<String>();
        int offset = 0;
        int pos = s.indexOf(delimiter, offset);
        while (pos != -1) {
            nodeValues.add(s.substring(offset, pos));
            offset = pos + 1;
            pos = s.indexOf(delimiter, offset);
        }
        if (offset < s.length()) {
            nodeValues.add(s.substring(offset));
        }
        return nodeValues.toArray(new String[nodeValues.size()]);
    }

    public static double[] split(String s, double x) {
        return StringUtil.split(s, ",", x);
    }

    public static float[] split(String s, float x) {
        return StringUtil.split(s, ",", x);
    }

    public static int[] split(String s, int x) {
        return StringUtil.split(s, ",", x);
    }

    public static long[] split(String s, long x) {
        return StringUtil.split(s, ",", x);
    }

    public static short[] split(String s, short x) {
        return StringUtil.split(s, ",", x);
    }

    public static String[] split(String s, String delimiter) {
        if (Validator.isNull(s) || delimiter == null || delimiter.equals("")) {
            return _emptyStringArray;
        }
        if ((s = s.trim()).equals(delimiter)) {
            return _emptyStringArray;
        }
        if (delimiter.length() == 1) {
            return StringUtil.split(s, delimiter.charAt(0));
        }
        ArrayList<String> nodeValues = new ArrayList<String>();
        int offset = 0;
        int pos = s.indexOf(delimiter, offset);
        while (pos != -1) {
            nodeValues.add(s.substring(offset, pos));
            offset = pos + delimiter.length();
            pos = s.indexOf(delimiter, offset);
        }
        if (offset < s.length()) {
            nodeValues.add(s.substring(offset));
        }
        return nodeValues.toArray(new String[nodeValues.size()]);
    }

    public static boolean[] split(String s, String delimiter, boolean x) {
        String[] array = StringUtil.split(s, delimiter);
        boolean[] newArray = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            boolean value = x;
            try {
                value = Boolean.valueOf(array[i]);
            }
            catch (Exception e) {
                // empty catch block
            }
            newArray[i] = value;
        }
        return newArray;
    }

    public static double[] split(String s, String delimiter, double x) {
        String[] array = StringUtil.split(s, delimiter);
        double[] newArray = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            double value = x;
            try {
                value = Double.parseDouble(array[i]);
            }
            catch (Exception e) {
                // empty catch block
            }
            newArray[i] = value;
        }
        return newArray;
    }

    public static float[] split(String s, String delimiter, float x) {
        String[] array = StringUtil.split(s, delimiter);
        float[] newArray = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            float value = x;
            try {
                value = Float.parseFloat(array[i]);
            }
            catch (Exception e) {
                // empty catch block
            }
            newArray[i] = value;
        }
        return newArray;
    }

    public static int[] split(String s, String delimiter, int x) {
        String[] array = StringUtil.split(s, delimiter);
        int[] newArray = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            int value = x;
            try {
                value = Integer.parseInt(array[i]);
            }
            catch (Exception e) {
                // empty catch block
            }
            newArray[i] = value;
        }
        return newArray;
    }

    public static long[] split(String s, String delimiter, long x) {
        String[] array = StringUtil.split(s, delimiter);
        long[] newArray = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            long value = x;
            try {
                value = Long.parseLong(array[i]);
            }
            catch (Exception e) {
                // empty catch block
            }
            newArray[i] = value;
        }
        return newArray;
    }

    public static short[] split(String s, String delimiter, short x) {
        String[] array = StringUtil.split(s, delimiter);
        short[] newArray = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            short value = x;
            try {
                value = Short.parseShort(array[i]);
            }
            catch (Exception e) {
                // empty catch block
            }
            newArray[i] = value;
        }
        return newArray;
    }

    public static String[] splitLines(String s) {
        if (Validator.isNull(s)) {
            return _emptyStringArray;
        }
        s = s.trim();
        ArrayList<String> lines = new ArrayList<String>();
        int lastIndex = 0;
        while (true) {
            int returnIndex = s.indexOf(13, lastIndex);
            int newLineIndex = s.indexOf(10, lastIndex);
            if (returnIndex == -1 && newLineIndex == -1) break;
            if (returnIndex == -1) {
                lines.add(s.substring(lastIndex, newLineIndex));
                lastIndex = newLineIndex + 1;
                continue;
            }
            if (newLineIndex == -1) {
                lines.add(s.substring(lastIndex, returnIndex));
                lastIndex = returnIndex + 1;
                continue;
            }
            if (newLineIndex < returnIndex) {
                lines.add(s.substring(lastIndex, newLineIndex));
                lastIndex = newLineIndex + 1;
                continue;
            }
            lines.add(s.substring(lastIndex, returnIndex));
            lastIndex = returnIndex + 1;
            if (lastIndex != newLineIndex) continue;
            ++lastIndex;
        }
        if (lastIndex < s.length()) {
            lines.add(s.substring(lastIndex));
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static boolean startsWith(String s, char begin) {
        return StringUtil.startsWith(s, Character.valueOf(begin).toString());
    }

    public static boolean startsWith(String s, String start) {
        if (s == null || start == null) {
            return false;
        }
        if (start.length() > s.length()) {
            return false;
        }
        String temp = s.substring(0, start.length());
        return StringUtil.equalsIgnoreCase(temp, start);
    }

    public static int startsWithWeight(String s1, String s2) {
        int i;
        if (s1 == null || s2 == null) {
            return 0;
        }
        char[] chars1 = s1.toCharArray();
        char[] chars2 = s2.toCharArray();
        for (i = 0; i < chars1.length && i < chars2.length && chars1[i] == chars2[i]; ++i) {
        }
        return i;
    }

    public static String strip(String s, char remove) {
        if (s == null) {
            return null;
        }
        int x = s.indexOf(remove);
        if (x < 0) {
            return s;
        }
        int y = 0;
        StringBundler sb = new StringBundler(s.length());
        while (x >= 0) {
            sb.append(s.subSequence(y, x));
            y = x + 1;
            x = s.indexOf(remove, y);
        }
        sb.append(s.substring(y));
        return sb.toString();
    }

    public static String strip(String s, char[] remove) {
        for (char c : remove) {
            s = StringUtil.strip(s, c);
        }
        return s;
    }

    public static String stripBetween(String s, String begin, String end) {
        if (Validator.isBlank(s) || Validator.isBlank(begin) || Validator.isBlank(end)) {
            return s;
        }
        StringBundler sb = new StringBundler(s.length());
        int pos = 0;
        while (true) {
            int x = s.indexOf(begin, pos);
            int y = s.indexOf(end, x + begin.length());
            if (x == -1 || y == -1) break;
            sb.append(s.substring(pos, x));
            pos = y + end.length();
        }
        sb.append(s.substring(pos));
        return sb.toString();
    }

    public static String stripCDATA(String s) {
        if (s == null) {
            return s;
        }
        if (s.startsWith("<![CDATA[") && s.endsWith("]]>")) {
            s = s.substring("<![CDATA[".length(), s.length() - "]]>".length());
        }
        return s;
    }

    public static String stripParentheticalSuffix(String s) {
        int x = s.lastIndexOf("(");
        int y = s.lastIndexOf(")");
        if (x == -1 || y == -1) {
            return s;
        }
        if (x > y || !s.endsWith(")")) {
            return s;
        }
        if (s.charAt(x - 1) != ' ') {
            return s;
        }
        return s.substring(0, x - 1).concat(s.substring(y + 1, s.length()));
    }

    public static String toCharCode(String s) {
        StringBundler sb = new StringBundler(s.length());
        for (int i = 0; i < s.length(); ++i) {
            sb.append(s.codePointAt(i));
        }
        return sb.toString();
    }

    public static String toHexString(int i) {
        char[] buffer = new char[8];
        int index = 8;
        do {
            buffer[--index] = HEX_DIGITS[i & 0xF];
        } while ((i >>>= 4) != 0);
        return new String(buffer, index, 8 - index);
    }

    public static String toHexString(long l) {
        char[] buffer = new char[16];
        int index = 16;
        do {
            buffer[--index] = HEX_DIGITS[(int)(l & 0xFL)];
        } while ((l >>>= 4) != 0L);
        return new String(buffer, index, 16 - index);
    }

    public static String toHexString(Object obj) {
        if (obj instanceof Integer) {
            return StringUtil.toHexString((Integer)obj);
        }
        if (obj instanceof Long) {
            return StringUtil.toHexString((Long)obj);
        }
        return String.valueOf(obj);
    }

    public static String toLowerCase(String s) {
        return StringUtil.toLowerCase(s, null);
    }

    public static String toLowerCase(String s, Locale locale) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                if (locale == null) {
                    locale = LocaleUtil.getDefault();
                }
                return s.toLowerCase(locale);
            }
            if (c < 'A' || c > 'Z') continue;
            if (sb == null) {
                sb = new StringBuilder(s);
            }
            sb.setCharAt(i, (char)(c + 32));
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }

    public static String toUpperCase(String s) {
        return StringUtil.toUpperCase(s, null);
    }

    public static String toUpperCase(String s, Locale locale) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                if (locale == null) {
                    locale = LocaleUtil.getDefault();
                }
                return s.toUpperCase(locale);
            }
            if (c < 'a' || c > 'z') continue;
            if (sb == null) {
                sb = new StringBuilder(s);
            }
            sb.setCharAt(i, (char)(c - 32));
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }

    public static String trim(String s) {
        int len;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        int x = len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            x = i;
            break;
        }
        if (x == len) {
            return "";
        }
        int y = x + 1;
        for (int i = len - 1; i > x; --i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            y = i + 1;
            break;
        }
        if (x == 0 && y == len) {
            return s;
        }
        return s.substring(x, y);
    }

    public static String trim(String s, char c) {
        return StringUtil.trim(s, new char[]{c});
    }

    public static String trim(String s, char[] exceptions) {
        int len;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (ArrayUtil.isEmpty((char[])exceptions)) {
            return StringUtil.trim(s);
        }
        int x = len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (StringUtil._isTrimable(c, exceptions)) continue;
            x = i;
            break;
        }
        if (x == len) {
            return "";
        }
        int y = x + 1;
        for (int i = len - 1; i > x; --i) {
            char c = s.charAt(i);
            if (StringUtil._isTrimable(c, exceptions)) continue;
            y = i + 1;
            break;
        }
        if (x == 0 && y == len) {
            return s;
        }
        return s.substring(x, y);
    }

    public static String trimLeading(String s) {
        int len;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        int x = len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            x = i;
            break;
        }
        if (x == len) {
            return "";
        }
        if (x == 0) {
            return s;
        }
        return s.substring(x);
    }

    public static String trimLeading(String s, char c) {
        return StringUtil.trimLeading(s, new char[]{c});
    }

    public static String trimLeading(String s, char[] exceptions) {
        int len;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (ArrayUtil.isEmpty((char[])exceptions)) {
            return StringUtil.trimLeading(s);
        }
        int x = len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (StringUtil._isTrimable(c, exceptions)) continue;
            x = i;
            break;
        }
        if (x == len) {
            return "";
        }
        if (x == 0) {
            return s;
        }
        return s.substring(x);
    }

    public static String trimTrailing(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        int len = s.length();
        int x = 0;
        for (int i = len - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            x = i + 1;
            break;
        }
        if (x == 0) {
            return "";
        }
        if (x == len) {
            return s;
        }
        return s.substring(0, x);
    }

    public static String trimTrailing(String s, char c) {
        return StringUtil.trimTrailing(s, new char[]{c});
    }

    public static String trimTrailing(String s, char[] exceptions) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (ArrayUtil.isEmpty((char[])exceptions)) {
            return StringUtil.trimTrailing(s);
        }
        int len = s.length();
        int x = 0;
        for (int i = len - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (StringUtil._isTrimable(c, exceptions)) continue;
            x = i + 1;
            break;
        }
        if (x == 0) {
            return "";
        }
        if (x == len) {
            return s;
        }
        return s.substring(0, x);
    }

    public static String unquote(String s) {
        if (Validator.isNull(s)) {
            return s;
        }
        if (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            return s.substring(1, s.length() - 1);
        }
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String upperCase(String s) {
        return StringUtil.toUpperCase(s);
    }

    public static String upperCaseFirstLetter(String s) {
        char[] chars = s.toCharArray();
        if (chars[0] >= 'a' && chars[0] <= 'z') {
            chars[0] = (char)(chars[0] - 32);
        }
        return new String(chars);
    }

    public static String valueOf(Object obj) {
        return String.valueOf(obj);
    }

    public static boolean wildcardMatches(String s, String wildcard, char singleWildcardCharacter, char multipleWildcardCharacter, char escapeWildcardCharacter, boolean caseSensitive) {
        char c;
        int index;
        if (!caseSensitive) {
            s = StringUtil.toLowerCase(s);
            wildcard = StringUtil.toLowerCase(wildcard);
        }
        if ((index = wildcard.indexOf(escapeWildcardCharacter)) != -1) {
            char newSingleWildcardCharacter = '\u0000';
            while (wildcard.indexOf(newSingleWildcardCharacter) != -1) {
                newSingleWildcardCharacter = (char)(newSingleWildcardCharacter + 1);
            }
            char newMultipleWildcardCharacter = (char)(newSingleWildcardCharacter + 1);
            while (wildcard.indexOf(newMultipleWildcardCharacter) != -1) {
                newMultipleWildcardCharacter = (char)(newMultipleWildcardCharacter + '\u0001');
            }
            StringBuilder sb = new StringBuilder(wildcard);
            for (int i = 0; i < sb.length(); ++i) {
                c = sb.charAt(i);
                if (c == escapeWildcardCharacter) {
                    sb.deleteCharAt(i);
                    continue;
                }
                if (c == singleWildcardCharacter) {
                    sb.setCharAt(i, newSingleWildcardCharacter);
                    continue;
                }
                if (c != multipleWildcardCharacter) continue;
                sb.setCharAt(i, newMultipleWildcardCharacter);
            }
            wildcard = sb.toString();
            singleWildcardCharacter = newSingleWildcardCharacter;
            multipleWildcardCharacter = newMultipleWildcardCharacter;
        }
        for (index = 0; index < s.length(); ++index) {
            if (index >= wildcard.length()) {
                return false;
            }
            char c2 = wildcard.charAt(index);
            if (c2 == multipleWildcardCharacter) break;
            if (s.charAt(index) == c2 || c2 == singleWildcardCharacter) continue;
            return false;
        }
        int sIndex = index;
        int wildcardIndex = index;
        int matchPoint = 0;
        int comparePoint = 0;
        while (sIndex < s.length()) {
            if (wildcardIndex == wildcard.length()) {
                return false;
            }
            c = wildcard.charAt(wildcardIndex);
            if (c == multipleWildcardCharacter) {
                if (++wildcardIndex == wildcard.length()) {
                    return true;
                }
                matchPoint = wildcardIndex;
                comparePoint = sIndex + 1;
                continue;
            }
            if (c == s.charAt(sIndex) || c == singleWildcardCharacter) {
                ++sIndex;
                ++wildcardIndex;
                continue;
            }
            wildcardIndex = matchPoint;
            sIndex = comparePoint++;
        }
        while (wildcardIndex < wildcard.length() && wildcard.charAt(wildcardIndex) == multipleWildcardCharacter) {
            ++wildcardIndex;
        }
        return wildcardIndex == wildcard.length();
    }

    public static String wrap(String text) {
        return StringUtil.wrap(text, 80, "\n");
    }

    public static String wrap(String text, int width, String lineSeparator) {
        try {
            return StringUtil._wrap(text, width, lineSeparator);
        }
        catch (IOException ioe) {
            _log.error(ioe.getMessage());
            return text;
        }
    }

    private static boolean _isTrimable(char c, char[] exceptions) {
        for (char exception : exceptions) {
            if (c != exception) continue;
            return false;
        }
        return Character.isWhitespace(c);
    }

    private static String _wrap(String text, int width, String lineSeparator) throws IOException {
        if (text == null) {
            return null;
        }
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(text));
        String s = "";
        while ((s = unsyncBufferedReader.readLine()) != null) {
            String[] tokens;
            if (s.length() == 0) {
                sb.append(lineSeparator);
                continue;
            }
            int lineLength = 0;
            for (String token : tokens = s.split(" ")) {
                if (lineLength + token.length() + 1 > width) {
                    if (lineLength > 0) {
                        sb.append(lineSeparator);
                    }
                    if (token.length() > width) {
                        int pos = token.indexOf(40);
                        if (pos != -1) {
                            sb.append(token.substring(0, pos + 1));
                            sb.append(lineSeparator);
                            token = token.substring(pos + 1);
                            sb.append(token);
                            lineLength = token.length();
                            continue;
                        }
                        sb.append(token);
                        lineLength = token.length();
                        continue;
                    }
                    sb.append(token);
                    lineLength = token.length();
                    continue;
                }
                if (lineLength > 0) {
                    sb.append(" ");
                    ++lineLength;
                }
                sb.append(token);
                lineLength += token.length();
            }
            sb.append(lineSeparator);
        }
        return sb.toString();
    }
}

