/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.nio.CharsetDecoderUtil;
import com.liferay.petra.nio.CharsetEncoderUtil;
import com.liferay.portal.kernel.io.DummyOutputStream;
import com.liferay.portal.kernel.io.DummyWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.servlet.MetaInfoCacheServletResponse;
import com.liferay.portal.kernel.servlet.ServletOutputStreamAdapter;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class BufferCacheServletResponse
extends MetaInfoCacheServletResponse {
    private static final ByteBuffer _emptyByteBuffer = ByteBuffer.allocate(0);
    private static final CharBuffer _emptyCharBuffer = CharBuffer.allocate(0);
    private ByteBuffer _byteBuffer;
    private CharBuffer _charBuffer;
    private PrintWriter _printWriter;
    private ServletOutputStream _servletOutputStream;
    private UnsyncByteArrayOutputStream _unsyncByteArrayOutputStream;
    private UnsyncStringWriter _unsyncStringWriter;

    public BufferCacheServletResponse(HttpServletResponse response) {
        super(response);
    }

    @Override
    public int getBufferSize() {
        if (this._byteBuffer != null) {
            return this._byteBuffer.limit();
        }
        if (this._charBuffer != null) {
            ByteBuffer byteBuffer = CharsetEncoderUtil.encode((String)this.getCharacterEncoding(), (CharBuffer)this._charBuffer.duplicate());
            return byteBuffer.limit();
        }
        try {
            this._flushInternalBuffer();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        if (this._unsyncByteArrayOutputStream != null) {
            return this._unsyncByteArrayOutputStream.size();
        }
        if (this._unsyncStringWriter != null) {
            String content = this._unsyncStringWriter.toString();
            ByteBuffer byteBuffer = CharsetEncoderUtil.encode((String)this.getCharacterEncoding(), (CharBuffer)CharBuffer.wrap(content));
            return byteBuffer.limit();
        }
        return 0;
    }

    public ByteBuffer getByteBuffer() throws IOException {
        if (this._byteBuffer != null) {
            return this._byteBuffer;
        }
        if (this._charBuffer != null) {
            return CharsetEncoderUtil.encode((String)this.getCharacterEncoding(), (CharBuffer)this._charBuffer.duplicate());
        }
        this._flushInternalBuffer();
        if (this._unsyncByteArrayOutputStream != null) {
            return this._unsyncByteArrayOutputStream.unsafeGetByteBuffer();
        }
        if (this._unsyncStringWriter != null) {
            String content = this._unsyncStringWriter.toString();
            return CharsetEncoderUtil.encode((String)this.getCharacterEncoding(), (CharBuffer)CharBuffer.wrap(content));
        }
        return _emptyByteBuffer;
    }

    public CharBuffer getCharBuffer() throws IOException {
        if (this._charBuffer != null) {
            return this._charBuffer;
        }
        if (this._byteBuffer != null) {
            return CharsetDecoderUtil.decode((String)this.getCharacterEncoding(), (ByteBuffer)this._byteBuffer.duplicate());
        }
        this._flushInternalBuffer();
        if (this._unsyncStringWriter != null) {
            return CharBuffer.wrap(this._unsyncStringWriter.toString());
        }
        if (this._unsyncByteArrayOutputStream != null) {
            ByteBuffer byteBuffer = this._unsyncByteArrayOutputStream.unsafeGetByteBuffer();
            return CharsetDecoderUtil.decode((String)this.getCharacterEncoding(), (ByteBuffer)byteBuffer);
        }
        return _emptyCharBuffer;
    }

    @Override
    public ServletOutputStream getOutputStream() {
        if (this.calledGetWriter) {
            throw new IllegalStateException("Unable to obtain OutputStream because Writer is already in use");
        }
        if (this._servletOutputStream != null) {
            return this._servletOutputStream;
        }
        this.resetBuffer(true);
        this._unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        this._servletOutputStream = new ServletOutputStreamAdapter(this._unsyncByteArrayOutputStream);
        this.calledGetOutputStream = true;
        return this._servletOutputStream;
    }

    public String getString() throws IOException {
        if (this._charBuffer != null) {
            return this._charBuffer.toString();
        }
        if (this._byteBuffer != null) {
            CharBuffer charBuffer = CharsetDecoderUtil.decode((String)this.getCharacterEncoding(), (ByteBuffer)this._byteBuffer.duplicate());
            return charBuffer.toString();
        }
        this._flushInternalBuffer();
        if (this._unsyncStringWriter != null) {
            return this._unsyncStringWriter.toString();
        }
        if (this._unsyncByteArrayOutputStream != null) {
            ByteBuffer byteBuffer = this._unsyncByteArrayOutputStream.unsafeGetByteBuffer();
            CharBuffer charBuffer = CharsetDecoderUtil.decode((String)this.getCharacterEncoding(), (ByteBuffer)byteBuffer);
            return charBuffer.toString();
        }
        return "";
    }

    public StringBundler getStringBundler() throws IOException {
        if (this._charBuffer != null) {
            StringBundler sb = new StringBundler(1);
            sb.append(this._charBuffer.toString());
            return sb;
        }
        if (this._byteBuffer != null) {
            CharBuffer charBuffer = CharsetDecoderUtil.decode((String)this.getCharacterEncoding(), (ByteBuffer)this._byteBuffer.duplicate());
            StringBundler sb = new StringBundler(1);
            sb.append(charBuffer.toString());
            return sb;
        }
        this._flushInternalBuffer();
        if (this._unsyncStringWriter != null) {
            return this._unsyncStringWriter.getStringBundler();
        }
        if (this._unsyncByteArrayOutputStream != null) {
            ByteBuffer byteBuffer = this._unsyncByteArrayOutputStream.unsafeGetByteBuffer();
            CharBuffer charBuffer = CharsetDecoderUtil.decode((String)this.getCharacterEncoding(), (ByteBuffer)byteBuffer);
            StringBundler sb = new StringBundler(1);
            sb.append(charBuffer.toString());
            return sb;
        }
        return new StringBundler(1);
    }

    @Override
    public PrintWriter getWriter() {
        if (this.calledGetOutputStream) {
            throw new IllegalStateException("Cannot obtain Writer because OutputStream is already in use");
        }
        if (this._printWriter != null) {
            return this._printWriter;
        }
        this.resetBuffer(true);
        this._unsyncStringWriter = new UnsyncStringWriter();
        this._printWriter = UnsyncPrintWriterPool.borrow(this._unsyncStringWriter);
        this.calledGetWriter = true;
        return this._printWriter;
    }

    public boolean isByteMode() {
        return this._byteBuffer != null || this._unsyncByteArrayOutputStream != null;
    }

    public boolean isCharMode() {
        return this._charBuffer != null || this._unsyncStringWriter != null;
    }

    public void outputBuffer() throws IOException {
        this._flushInternalBuffer();
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        if (this._byteBuffer != null || this.calledGetOutputStream) {
            ServletResponseUtil.write(response, this.getByteBuffer());
        } else if (this._charBuffer != null || this.calledGetWriter) {
            ServletResponseUtil.write(response, this.getCharBuffer());
        }
    }

    @Override
    public void setBufferSize(int bufferSize) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Set buffer size after commit");
        }
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.resetBuffer(true);
        this._byteBuffer = byteBuffer;
        if (byteBuffer != null) {
            this._servletOutputStream = new ServletOutputStreamAdapter(new DummyOutputStream());
            this.calledGetOutputStream = true;
        }
    }

    public void setCharBuffer(CharBuffer charBuffer) {
        this.resetBuffer(true);
        this._charBuffer = charBuffer;
        if (charBuffer != null) {
            this._printWriter = UnsyncPrintWriterPool.borrow(new DummyWriter());
            this.calledGetWriter = true;
        }
    }

    @Override
    public void setContentLength(int contentLength) {
    }

    public void setString(String string) {
        this.setCharBuffer(CharBuffer.wrap(string));
    }

    @Override
    protected void resetBuffer(boolean nullOutReferences) {
        if (nullOutReferences) {
            this.calledGetOutputStream = false;
            this.calledGetWriter = false;
            this._printWriter = null;
            this._servletOutputStream = null;
            this._unsyncByteArrayOutputStream = null;
            this._unsyncStringWriter = null;
        } else {
            if (this._unsyncByteArrayOutputStream != null) {
                this._unsyncByteArrayOutputStream.reset();
            }
            if (this._unsyncStringWriter != null) {
                this._unsyncStringWriter.reset();
            }
            if (this._byteBuffer != null) {
                this._servletOutputStream = null;
                this.calledGetOutputStream = false;
            }
            if (this._charBuffer != null) {
                this._printWriter = null;
                this.calledGetWriter = false;
            }
        }
        this._byteBuffer = null;
        this._charBuffer = null;
    }

    private void _flushInternalBuffer() throws IOException {
        if (this.calledGetOutputStream) {
            this._servletOutputStream.flush();
        } else if (this.calledGetWriter) {
            this._printWriter.flush();
        }
    }
}

