/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.sanitizer;

import com.liferay.portal.kernel.sanitizer.Sanitizer;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public abstract class BaseSanitizer
implements Sanitizer {
    @Override
    public byte[] sanitize(long companyId, long groupId, long userId, String className, long classPK, String contentType, String[] modes, byte[] bytes, Map<String, Object> options) throws SanitizerException {
        if (bytes == null) {
            return null;
        }
        try {
            String content = new String(bytes, "UTF-8");
            String result = this.sanitize(companyId, groupId, userId, className, classPK, contentType, modes, content, options);
            return result.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new SanitizerException(uee);
        }
    }

    @Override
    public void sanitize(long companyId, long groupId, long userId, String className, long classPK, String contentType, String[] modes, InputStream inputStream, OutputStream outputStream, Map<String, Object> options) throws SanitizerException {
        if (inputStream == null || outputStream == null) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            StreamUtil.transfer(inputStream, byteArrayOutputStream);
            String content = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
            String result = this.sanitize(companyId, groupId, userId, className, classPK, contentType, modes, content, options);
            byte[] bytes = result.getBytes("UTF-8");
            outputStream.write(bytes);
        }
        catch (IOException ioe) {
            throw new SanitizerException(ioe);
        }
    }

    @Override
    public abstract String sanitize(long var1, long var3, long var5, String var7, long var8, String var10, String[] var11, String var12, Map<String, Object> var13) throws SanitizerException;
}

