/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.users.admin.kernel.file.uploads.UserFileUploadsSettings;

@ProviderType
public class UserConstants {
    public static final int FULL_NAME_MAX_LENGTH = 75;
    public static final String LIST_VIEW_FLAT_ORGANIZATIONS = "flat-organizations";
    public static final String LIST_VIEW_FLAT_USER_GROUPS = "flat-user-groups";
    public static final String LIST_VIEW_FLAT_USERS = "flat-users";
    public static final String LIST_VIEW_TREE = "tree";
    public static final long USER_ID_DEFAULT = 0L;
    public static final String USERS_EMAIL_ADDRESS_AUTO_SUFFIX = PropsUtil.get("users.email.address.auto.suffix");
    private static final Log _log = LogFactoryUtil.getLog(UserConstants.class);
    private static volatile UserFileUploadsSettings _userFileUploadsSettings = ServiceProxyFactory.newServiceTrackedInstance(UserFileUploadsSettings.class, UserConstants.class, "_userFileUploadsSettings", false);

    @Deprecated
    public static String getPortraitURL(String imagePath, boolean male, long portraitId) {
        if (!_userFileUploadsSettings.isImageCheckToken()) {
            return UserConstants.getPortraitURL(imagePath, male, portraitId, null);
        }
        if (portraitId <= 0L) {
            return UserConstants.getPortraitURL(imagePath, male, 0L, "");
        }
        try {
            User user = UserLocalServiceUtil.fetchUserByPortraitId(portraitId);
            if (user == null) {
                return UserConstants.getPortraitURL(imagePath, male, 0L, "");
            }
            return UserConstants.getPortraitURL(imagePath, male, portraitId, user.getUserUuid());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn(e, e);
            }
            return "";
        }
    }

    public static String getPortraitURL(String imagePath, boolean male, long portraitId, String userUuid) {
        StringBundler sb = new StringBundler(9);
        sb.append(imagePath);
        sb.append("/user_");
        if (male) {
            sb.append("male");
        } else {
            sb.append("female");
        }
        sb.append("_portrait?img_id=");
        sb.append(portraitId);
        if (_userFileUploadsSettings.isImageCheckToken()) {
            sb.append("&img_id_token=");
            sb.append(URLCodec.encodeURL(DigesterUtil.digest(userUuid)));
        }
        sb.append("&t=");
        sb.append(WebServerServletTokenUtil.getToken(portraitId));
        return sb.toString();
    }
}

