/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.lock;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Date;

public class LockProtectedAction<T> {
    private static final Log _log = LogFactoryUtil.getLog(LockProtectedAction.class);
    private final String _className;
    private final String _lockKey;
    private final long _retryDelay;
    private T _returnValue;
    private final long _timeout;

    public LockProtectedAction(Class<?> clazz, String lockKey, long timeout, long retryDelay) {
        this._className = clazz.getName();
        this._lockKey = lockKey;
        this._timeout = timeout;
        this._retryDelay = retryDelay;
    }

    public T getReturnValue() {
        return this._returnValue;
    }

    public void performAction() throws PortalException {
        block10: {
            Lock lock = LockManagerUtil.lock(this._className, this._lockKey, this._lockKey);
            if (lock.isNew()) {
                try {
                    this._returnValue = this.performProtectedAction();
                }
                finally {
                    LockManagerUtil.unlock(this._className, this._lockKey, this._lockKey);
                }
                return;
            }
            Date createDate = lock.getCreateDate();
            if (System.currentTimeMillis() - createDate.getTime() >= this._timeout) {
                LockManagerUtil.unlock(this._className, this._lockKey, lock.getOwner());
                if (_log.isWarnEnabled()) {
                    _log.warn("Removed lock " + lock + " due to timeout");
                }
            } else {
                try {
                    Thread.sleep(this._retryDelay);
                }
                catch (InterruptedException ie) {
                    if (!_log.isWarnEnabled()) break block10;
                    _log.warn("Interrupted while waiting to reacquire lock", ie);
                }
            }
        }
    }

    protected T performProtectedAction() throws PortalException {
        return null;
    }
}

