/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.internal.servlet;

import com.liferay.portal.kernel.util.StringBundler;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class RestrictedByteArrayCacheOutputStream
extends OutputStream {
    protected byte[] cache;
    protected int cacheCapacity;
    protected FlushPreAction flushPreAction;
    protected int index;
    protected OutputStream outputStream;
    protected boolean overflowed;

    public RestrictedByteArrayCacheOutputStream(OutputStream outputStream, int cacheCapacity, FlushPreAction flushPreAction) {
        this(outputStream, 32, cacheCapacity, flushPreAction);
    }

    public RestrictedByteArrayCacheOutputStream(OutputStream outputStream, int initialCacheSize, int cacheCapacity, FlushPreAction flushPreAction) {
        if (initialCacheSize > cacheCapacity) {
            throw new IllegalArgumentException(StringBundler.concat("Initial cache size ", String.valueOf(initialCacheSize), " is larger than cache capacity ", String.valueOf(cacheCapacity)));
        }
        this.outputStream = outputStream;
        this.cacheCapacity = cacheCapacity;
        this.flushPreAction = flushPreAction;
        this.cache = new byte[initialCacheSize];
    }

    @Override
    public void flush() throws IOException {
        if (this.overflowed) {
            return;
        }
        if (this.flushPreAction != null) {
            this.flushPreAction.beforeFlush();
        }
        this.overflowed = true;
        this.outputStream.write(this.cache, 0, this.index);
        this.cache = null;
        this.index = -1;
    }

    public int getCacheCapacity() {
        return this.cacheCapacity;
    }

    public boolean isOverflowed() {
        return this.overflowed;
    }

    public void reset() {
        if (this.overflowed) {
            throw new IllegalStateException("Cache overflowed");
        }
        this.index = 0;
    }

    public int size() {
        return this.index;
    }

    public byte[] toByteArray() {
        if (this.overflowed) {
            throw new IllegalStateException("Cache overflowed");
        }
        byte[] newCache = new byte[this.index];
        System.arraycopy(this.cache, 0, newCache, 0, this.index);
        return newCache;
    }

    public byte[] unsafeGetByteArray() {
        if (this.overflowed) {
            throw new IllegalStateException("Cache overflowed");
        }
        return this.cache;
    }

    public ByteBuffer unsafeGetByteBuffer() {
        if (this.overflowed) {
            throw new IllegalStateException("Cache overflowed");
        }
        return ByteBuffer.wrap(this.cache, 0, this.index);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        if (length <= 0) {
            return;
        }
        if (this.overflowed) {
            this.outputStream.write(bytes, offset, length);
            return;
        }
        int newIndex = this.index + length;
        if (newIndex > this.cacheCapacity) {
            this.flush();
            this.outputStream.write(bytes, offset, length);
            return;
        }
        this.ensureCacheSize(newIndex);
        System.arraycopy(bytes, offset, this.cache, this.index, length);
        this.index = newIndex;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.overflowed) {
            this.outputStream.write(b);
            return;
        }
        int newIndex = this.index + 1;
        if (newIndex > this.cacheCapacity) {
            this.flush();
            this.outputStream.write(b);
            return;
        }
        this.ensureCacheSize(newIndex);
        this.cache[this.index] = (byte)b;
        this.index = newIndex;
    }

    protected void ensureCacheSize(int newIndex) {
        if (newIndex <= this.cache.length) {
            return;
        }
        int newCacheSize = Math.max(this.cache.length << 1, newIndex);
        if (newCacheSize > this.cacheCapacity) {
            newCacheSize = this.cacheCapacity;
        }
        byte[] newCache = new byte[newCacheSize];
        System.arraycopy(this.cache, 0, newCache, 0, this.cache.length);
        this.cache = newCache;
    }

    public static interface FlushPreAction {
        public void beforeFlush() throws IOException;
    }
}

