/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.exception;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.EmailAddressValidator;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.StringUtil;

public class UserEmailAddressException
extends PortalException {
    @Deprecated
    public UserEmailAddressException() {
    }

    @Deprecated
    public UserEmailAddressException(String msg) {
        super(msg);
    }

    @Deprecated
    public UserEmailAddressException(String msg, Throwable cause) {
        super(msg, cause);
    }

    @Deprecated
    public UserEmailAddressException(Throwable cause) {
        super(cause);
    }

    public static class MustValidate
    extends UserEmailAddressException {
        public String emailAddress;
        public final EmailAddressValidator emailAddressValidator;

        public MustValidate(String emailAddress, EmailAddressValidator emailAddressValidator) {
            super(String.format("Email name address %s must validate with %s", emailAddress, ClassUtil.getClassName(emailAddressValidator)));
            this.emailAddress = emailAddress;
            this.emailAddressValidator = emailAddressValidator;
        }
    }

    public static class MustNotUseCompanyMx
    extends UserEmailAddressException {
        public final String emailAddress;

        public MustNotUseCompanyMx(String emailAddress) {
            super(String.format("Email address %s must not use the MX of the company or one of the associated mail host names", emailAddress));
            this.emailAddress = emailAddress;
        }
    }

    public static class MustNotBeReserved
    extends UserEmailAddressException {
        public final String emailAddress;
        public final String[] reservedEmailAddresses;

        public MustNotBeReserved(String emailAddress, String[] reservedEmailAddresses) {
            super(String.format("Email address %s must not be a reserved one such as: %s", emailAddress, StringUtil.merge(reservedEmailAddresses)));
            this.emailAddress = emailAddress;
            this.reservedEmailAddresses = reservedEmailAddresses;
        }
    }

    public static class MustNotBePOP3User
    extends UserEmailAddressException {
        public final String emailAddress;

        public MustNotBePOP3User(String emailAddress) {
            super(String.format("Email address %s must not be the one used to connect to the POP3 server", emailAddress));
            this.emailAddress = emailAddress;
        }
    }

    public static class MustNotBeNull
    extends UserEmailAddressException {
        public MustNotBeNull() {
            super("Email address must not be null");
        }

        public MustNotBeNull(String fullName) {
            super(String.format("Email address must not be null for the full name %s", fullName));
        }
    }

    public static class MustNotBeDuplicate
    extends UserEmailAddressException {
        public String emailAddress;
        public final long userId;

        public MustNotBeDuplicate(long userId, String emailAddress) {
            super(String.format("Email address %s must not be duplicate but is already used by user %s", emailAddress, userId));
            this.userId = userId;
            this.emailAddress = emailAddress;
        }
    }

    public static class MustBeEqual
    extends UserEmailAddressException {
        public final String emailAddress1;
        public final String emailAddress2;
        public final User user;

        public MustBeEqual(User user, String emailAddress1, String emailAddress2) {
            super(String.format("Email address 1 %s and email address 2 %s for user %s must be equal", emailAddress1, emailAddress2, user.getUserId()));
            this.user = user;
            this.emailAddress1 = emailAddress1;
            this.emailAddress2 = emailAddress2;
        }
    }
}

