/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster.messaging;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterLinkUtil;
import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.util.StringBundler;

public class ClusterBridgeMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(ClusterBridgeMessageListener.class);
    private Priority _priority;

    public void setPriority(Priority priority) {
        this._priority = priority;
    }

    @Override
    protected void doReceive(Message message) throws Exception {
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        Address address = ClusterLinkUtil.getAddress(message);
        if (address == null) {
            if (_log.isInfoEnabled()) {
                _log.info("Bridging cluster link multicast message " + message);
            }
            ClusterLinkUtil.sendMulticastMessage(message, this._priority);
        } else {
            if (_log.isInfoEnabled()) {
                _log.info(StringBundler.concat("Bridging cluster link unicast message ", String.valueOf(message), " to ", String.valueOf(address)));
            }
            ClusterLinkUtil.sendUnicastMessage(address, message, this._priority);
        }
    }
}

