/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.kernel.antivirus;

import com.liferay.document.library.kernel.antivirus.AntivirusScanner;
import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class BaseInputStreamAntivirusScanner
implements AntivirusScanner {
    private static final boolean _ACTIVE = true;
    private static final Log _log = LogFactoryUtil.getLog(BaseInputStreamAntivirusScanner.class);

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void scan(File file) throws AntivirusScannerException {
        block15: {
            try (FileInputStream inputStream = new FileInputStream(file);){
                this.scan(inputStream);
            }
            catch (FileNotFoundException fnfe) {
                throw new SystemException("Unable to scan file", fnfe);
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block15;
                _log.warn(ioe, ioe);
            }
        }
    }
}

