/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.portal.kernel.upgrade.util.BaseUpgradeColumnImpl;
import com.liferay.portal.kernel.upgrade.util.ValueMapper;
import com.liferay.portal.kernel.upgrade.util.ValueMapperFactoryUtil;

public class PKUpgradeColumnImpl
extends BaseUpgradeColumnImpl {
    private final Integer _newColumnType = -5;
    private final boolean _trackValues;
    private final ValueMapper _valueMapper;

    public PKUpgradeColumnImpl(String name, boolean trackValues) {
        this(name, null, trackValues);
    }

    public PKUpgradeColumnImpl(String name, Integer oldColumnType, boolean trackValues) {
        super(name, oldColumnType);
        this._trackValues = trackValues;
        this._valueMapper = this._trackValues ? ValueMapperFactoryUtil.getValueMapper() : null;
    }

    public Integer getNewColumnType(Integer defaultType) {
        return this._newColumnType;
    }

    public Object getNewValue(Object oldValue) throws Exception {
        Long newValue = this.increment();
        if (this._trackValues) {
            this._valueMapper.mapValue(oldValue, (Object)newValue);
        }
        return newValue;
    }

    public ValueMapper getValueMapper() {
        return this._valueMapper;
    }

    public boolean isTrackValues() {
        return this._trackValues;
    }
}

