/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.ExceptionRetryAcceptor;
import com.liferay.portal.kernel.spring.aop.Property;
import com.liferay.portal.kernel.spring.aop.Retry;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.PortletPreferencesLocalServiceBaseImpl;
import com.liferay.portlet.PortletPreferencesImpl;
import java.util.List;
import javax.portlet.PortletPreferences;

public class PortletPreferencesLocalServiceImpl
extends PortletPreferencesLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesLocalServiceImpl.class);

    public com.liferay.portal.kernel.model.PortletPreferences addPortletPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, Portlet portlet, String defaultPreferences) {
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences;
        block5: {
            long portletPreferencesId = this.counterLocalService.increment();
            portletPreferences = this.portletPreferencesPersistence.create(portletPreferencesId);
            portletPreferences.setOwnerId(ownerId);
            portletPreferences.setOwnerType(ownerType);
            portletPreferences.setPlid(plid);
            portletPreferences.setPortletId(portletId);
            if (Validator.isNull((String)defaultPreferences)) {
                defaultPreferences = portlet == null ? "<portlet-preferences />" : portlet.getDefaultPreferences();
            }
            portletPreferences.setPreferences(defaultPreferences);
            if (_log.isDebugEnabled()) {
                StringBundler sb = new StringBundler(13);
                sb.append("Add {companyId=");
                sb.append(companyId);
                sb.append(", ownerId=");
                sb.append(ownerId);
                sb.append(", ownerType=");
                sb.append(ownerType);
                sb.append(", plid=");
                sb.append(plid);
                sb.append(", portletId=");
                sb.append(portletId);
                sb.append(", defaultPreferences=");
                sb.append(defaultPreferences);
                sb.append("}");
                _log.debug((Object)sb.toString());
            }
            try {
                this.portletPreferencesPersistence.update((BaseModel)portletPreferences);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Add failed, fetch {ownerId=" + ownerId + ", ownerType=" + ownerType + ", plid=" + plid + ", portletId=" + portletId + "}"));
                }
                if ((portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid, portletId, false)) != null) break block5;
                throw se;
            }
        }
        return portletPreferences;
    }

    public void deletePortletPreferences(long ownerId, int ownerType, long plid) {
        this.portletPreferencesPersistence.removeByO_O_P(ownerId, ownerType, plid);
    }

    public void deletePortletPreferences(long ownerId, int ownerType, long plid, String portletId) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Delete {ownerId=" + ownerId + ", ownerType=" + ownerType + ", plid=" + plid + ", portletId=" + portletId + "}"));
        }
        this.portletPreferencesPersistence.removeByO_O_P_P(ownerId, ownerType, plid, portletId);
    }

    public void deletePortletPreferencesByPlid(long plid) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Delete {plid=" + plid + "}"));
        }
        this.portletPreferencesPersistence.removeByPlid(plid);
    }

    public PortletPreferences fetchPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId) {
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid, portletId);
        if (portletPreferences == null) {
            return null;
        }
        PortletPreferencesImpl portletPreferencesImpl = (PortletPreferencesImpl)PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)portletPreferences.getPreferences());
        return portletPreferencesImpl;
    }

    public PortletPreferences fetchPreferences(PortletPreferencesIds portletPreferencesIds) {
        return this.fetchPreferences(portletPreferencesIds.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId());
    }

    @Skip
    public PortletPreferences getDefaultPreferences(long companyId, String portletId) {
        Portlet portlet = this.portletLocalService.getPortletById(companyId, portletId);
        return PortletPreferencesFactoryUtil.fromDefaultXML((String)portlet.getDefaultPreferences());
    }

    public List<com.liferay.portal.kernel.model.PortletPreferences> getPortletPreferences() {
        return this.portletPreferencesPersistence.findAll();
    }

    public List<com.liferay.portal.kernel.model.PortletPreferences> getPortletPreferences(int ownerType, long plid, String portletId) {
        return this.portletPreferencesPersistence.findByO_P_P(ownerType, plid, portletId);
    }

    public List<com.liferay.portal.kernel.model.PortletPreferences> getPortletPreferences(long ownerId, int ownerType, long plid) {
        return this.portletPreferencesPersistence.findByO_O_P(ownerId, ownerType, plid);
    }

    public com.liferay.portal.kernel.model.PortletPreferences getPortletPreferences(long ownerId, int ownerType, long plid, String portletId) throws PortalException {
        return this.portletPreferencesPersistence.findByO_O_P_P(ownerId, ownerType, plid, portletId);
    }

    public List<com.liferay.portal.kernel.model.PortletPreferences> getPortletPreferences(long companyId, long groupId, long ownerId, int ownerType, String portletId, boolean privateLayout) {
        return this.portletPreferencesFinder.findByC_G_O_O_P_P(companyId, groupId, ownerId, ownerType, portletId, privateLayout);
    }

    public List<com.liferay.portal.kernel.model.PortletPreferences> getPortletPreferences(long plid, String portletId) {
        return this.portletPreferencesPersistence.findByP_P(plid, portletId);
    }

    public List<com.liferay.portal.kernel.model.PortletPreferences> getPortletPreferencesByPlid(long plid) {
        return this.portletPreferencesPersistence.findByPlid(plid);
    }

    public long getPortletPreferencesCount(int ownerType, long plid, String portletId) {
        return this.portletPreferencesPersistence.countByO_P_P(ownerType, plid, portletId);
    }

    public long getPortletPreferencesCount(int ownerType, String portletId) {
        return this.portletPreferencesPersistence.countByO_P(ownerType, portletId);
    }

    public long getPortletPreferencesCount(long ownerId, int ownerType, long plid, Portlet portlet, boolean excludeDefaultPreferences) {
        String portletId = portlet.getPortletId();
        if (plid == -1L) {
            portletId = portlet.getRootPortletId();
        }
        return this.portletPreferencesFinder.countByO_O_P_P_P(ownerId, ownerType, plid, portletId, excludeDefaultPreferences);
    }

    public long getPortletPreferencesCount(long ownerId, int ownerType, String portletId, boolean excludeDefaultPreferences) {
        return this.portletPreferencesFinder.countByO_O_P(ownerId, ownerType, portletId, excludeDefaultPreferences);
    }

    @Retry(acceptor=ExceptionRetryAcceptor.class, properties={@Property(name="EXCEPTION_NAME", value="org.springframework.dao.DataIntegrityViolationException")})
    public PortletPreferences getPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId) {
        return this.getPreferences(companyId, ownerId, ownerType, plid, portletId, null);
    }

    @Retry(acceptor=ExceptionRetryAcceptor.class, properties={@Property(name="EXCEPTION_NAME", value="org.springframework.dao.DataIntegrityViolationException")})
    public PortletPreferences getPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String defaultPreferences) {
        return this.getPreferences(companyId, ownerId, ownerType, plid, portletId, defaultPreferences, false);
    }

    @Retry(acceptor=ExceptionRetryAcceptor.class, properties={@Property(name="EXCEPTION_NAME", value="org.springframework.dao.DataIntegrityViolationException")})
    public PortletPreferences getPreferences(PortletPreferencesIds portletPreferencesIds) {
        return this.getPreferences(portletPreferencesIds.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId());
    }

    @Retry(acceptor=ExceptionRetryAcceptor.class, properties={@Property(name="EXCEPTION_NAME", value="org.springframework.dao.DataIntegrityViolationException")})
    public PortletPreferences getStrictPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId) {
        return this.getPreferences(companyId, ownerId, ownerType, plid, portletId, null, true);
    }

    public PortletPreferences getStrictPreferences(PortletPreferencesIds portletPreferencesIds) {
        return this.getStrictPreferences(portletPreferencesIds.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId());
    }

    public com.liferay.portal.kernel.model.PortletPreferences updatePreferences(long ownerId, int ownerType, long plid, String portletId, PortletPreferences portletPreferences) {
        String xml = PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
        return this.updatePreferences(ownerId, ownerType, plid, portletId, xml);
    }

    public com.liferay.portal.kernel.model.PortletPreferences updatePreferences(long ownerId, int ownerType, long plid, String portletId, String xml) {
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Update {ownerId=" + ownerId + ", ownerType=" + ownerType + ", plid=" + plid + ", portletId=" + portletId + ", xml=" + xml + "}"));
        }
        if ((portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid, portletId)) == null) {
            long portletPreferencesId = this.counterLocalService.increment();
            portletPreferences = this.portletPreferencesPersistence.create(portletPreferencesId);
            portletPreferences.setOwnerId(ownerId);
            portletPreferences.setOwnerType(ownerType);
            portletPreferences.setPlid(plid);
            portletPreferences.setPortletId(portletId);
        }
        portletPreferences.setPreferences(xml);
        this.portletPreferencesPersistence.update((BaseModel)portletPreferences);
        return portletPreferences;
    }

    protected PortletPreferences getPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String defaultPreferences, boolean strict) {
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid, portletId);
        if (portletPreferences == null) {
            Portlet portlet = this.portletLocalService.getPortletById(companyId, portletId);
            if (strict && (Validator.isNull((String)defaultPreferences) || portlet != null && portlet.isUndeployedPortlet())) {
                defaultPreferences = portlet == null ? "<portlet-preferences />" : portlet.getDefaultPreferences();
                return PortletPreferencesFactoryUtil.strictFromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)defaultPreferences);
            }
            portletPreferences = this.portletPreferencesLocalService.addPortletPreferences(companyId, ownerId, ownerType, plid, portletId, portlet, defaultPreferences);
        }
        PortletPreferencesImpl portletPreferencesImpl = (PortletPreferencesImpl)PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)portletPreferences.getPreferences());
        return portletPreferencesImpl;
    }
}

