/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class VerifyEmailAddressAction
extends Action {
    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String cmd = ParamUtil.getString((HttpServletRequest)request, (String)"cmd");
        if (Validator.isNull((String)cmd)) {
            return actionMapping.findForward("portal.verify_email_address");
        }
        if (themeDisplay.isSignedIn() && cmd.equals("send")) {
            this.sendEmailAddressVerification(request, response, themeDisplay);
            return actionMapping.findForward("portal.verify_email_address");
        }
        try {
            this.verifyEmailAddress(request, response, themeDisplay);
            if (!themeDisplay.isSignedIn()) {
                LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"com_liferay_login_web_portlet_LoginPortlet", (String)"RENDER_PHASE");
                response.sendRedirect(portletURL.toString());
                return null;
            }
            return actionMapping.findForward("/common/referer_jsp.jsp");
        }
        catch (Exception e) {
            if (e instanceof PortalException || e instanceof SystemException) {
                SessionErrors.add((HttpServletRequest)request, e.getClass());
                return actionMapping.findForward("portal.verify_email_address");
            }
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    protected void sendEmailAddressVerification(HttpServletRequest request, HttpServletResponse response, ThemeDisplay themeDisplay) throws Exception {
        User user = themeDisplay.getUser();
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
        UserLocalServiceUtil.sendEmailAddressVerification((User)user, (String)user.getEmailAddress(), (ServiceContext)serviceContext);
    }

    protected void verifyEmailAddress(HttpServletRequest request, HttpServletResponse response, ThemeDisplay themeDisplay) throws Exception {
        AuthTokenUtil.checkCSRFToken((HttpServletRequest)request, (String)VerifyEmailAddressAction.class.getName());
        String ticketKey = ParamUtil.getString((HttpServletRequest)request, (String)"ticketKey");
        UserLocalServiceUtil.verifyEmailAddress((String)ticketKey);
    }
}

