/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.SafeProperties;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.Properties;

public class ColorSchemeImpl
implements ColorScheme {
    private static final Log _log = LogFactoryUtil.getLog(ColorSchemeImpl.class);
    private final String _colorSchemeId;
    private String _colorSchemeImagesPath = "${images-path}/color_schemes/${css-class}";
    private String _cssClass;
    private boolean _defaultCs;
    private String _name;
    private Properties _settingsProperties = new SafeProperties();

    public ColorSchemeImpl() {
        this(null, null, null);
    }

    public ColorSchemeImpl(String colorSchemeId) {
        this(colorSchemeId, null, null);
    }

    public ColorSchemeImpl(String colorSchemeId, String name, String cssClass) {
        this._colorSchemeId = colorSchemeId;
        this._name = name;
        this._cssClass = cssClass;
    }

    public int compareTo(ColorScheme colorScheme) {
        return this.getName().compareTo(colorScheme.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColorScheme)) {
            return false;
        }
        ColorScheme colorScheme = (ColorScheme)obj;
        String colorSchemeId = colorScheme.getColorSchemeId();
        return this.getColorSchemeId().equals(colorSchemeId);
    }

    public String getColorSchemeId() {
        return this._colorSchemeId;
    }

    public String getColorSchemeImagesPath() {
        return this._colorSchemeImagesPath;
    }

    public String getColorSchemeThumbnailPath() {
        int pos;
        if (Validator.isNotNull((String)this._cssClass) && Validator.isNotNull((String)this._colorSchemeImagesPath) && (pos = this._cssClass.indexOf(32)) > 0 && this._colorSchemeImagesPath.endsWith(this._cssClass.substring(0, pos))) {
            String subclassPath = StringUtil.replace((String)this._cssClass, (char)' ', (char)'/');
            return this._colorSchemeImagesPath + subclassPath.substring(pos);
        }
        return this._colorSchemeImagesPath;
    }

    public String getCssClass() {
        return this._cssClass;
    }

    public boolean getDefaultCs() {
        return this._defaultCs;
    }

    public String getName() {
        if (Validator.isNull((String)this._name)) {
            return this._colorSchemeId;
        }
        return this._name;
    }

    public String getSetting(String key) {
        if (key.endsWith("-bg")) {
            return "#FFFFFF";
        }
        return "#000000";
    }

    public String getSettings() {
        return PropertiesUtil.toString((Properties)this._settingsProperties);
    }

    public Properties getSettingsProperties() {
        return this._settingsProperties;
    }

    public int hashCode() {
        return this._colorSchemeId.hashCode();
    }

    public boolean isDefaultCs() {
        return this._defaultCs;
    }

    public void setColorSchemeImagesPath(String colorSchemeImagesPath) {
        this._colorSchemeImagesPath = colorSchemeImagesPath;
    }

    public void setCssClass(String cssClass) {
        this._cssClass = cssClass;
    }

    public void setDefaultCs(boolean defaultCs) {
        this._defaultCs = defaultCs;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setSettings(String settings) {
        this._settingsProperties.clear();
        try {
            PropertiesUtil.load((Properties)this._settingsProperties, (String)settings);
            PropertiesUtil.trimKeys((Properties)this._settingsProperties);
        }
        catch (IOException ioe) {
            _log.error((Throwable)ioe);
        }
    }

    public void setSettingsProperties(Properties settingsProperties) {
        this._settingsProperties = settingsProperties;
    }
}

