/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.settings;

import com.liferay.portal.kernel.settings.BaseSettings;
import com.liferay.portal.kernel.settings.LocationVariableResolver;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesSettings
extends BaseSettings {
    private final LocationVariableResolver _locationVariableResolver;
    private final Map<String, String> _properties;

    public PropertiesSettings(LocationVariableResolver locationVariableResolver, Properties properties) {
        this(locationVariableResolver, properties, null);
    }

    public PropertiesSettings(LocationVariableResolver locationVariableResolver, Properties properties, Settings parentSettings) {
        super(parentSettings);
        this._locationVariableResolver = locationVariableResolver;
        this._properties = new HashMap<Object, Object>(properties);
    }

    @Override
    protected String doGetValue(String key) {
        return this.readProperty(key);
    }

    @Override
    protected String[] doGetValues(String key) {
        return StringUtil.split(this.doGetValue(key));
    }

    protected String getProperty(String key) {
        return this.readProperty(key);
    }

    protected String readProperty(String key) {
        String value = this._properties.get(key);
        if (this._locationVariableResolver.isLocationVariable(value)) {
            return this._locationVariableResolver.resolve(value);
        }
        return value;
    }
}

