/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.filters.invoker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.servlet.filters.invoker.Dispatcher;
import com.liferay.portal.kernel.servlet.filters.invoker.FilterMapping;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilter;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterChain;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterConfig;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.util.StringPlus;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class InvokerFilterHelper {
    private static final Log _log = LogFactoryUtil.getLog(InvokerFilterHelper.class);
    private final ConcurrentMap<String, List<FilterMapping>> _filterMappingsMap = new ConcurrentHashMap<String, List<FilterMapping>>();
    private final List<String> _filterNames = new CopyOnWriteArrayList<String>();
    private final List<InvokerFilter> _invokerFilters = new ArrayList<InvokerFilter>();
    private ServiceTracker<Filter, FilterMapping> _serviceTracker;

    public void destroy() {
        this._serviceTracker.close();
        for (List filterMappings : this._filterMappingsMap.values()) {
            FilterMapping filterMapping = (FilterMapping)filterMappings.get(0);
            Filter filter = filterMapping.getFilter();
            try {
                filter.destroy();
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        this._filterMappingsMap.clear();
        this._filterNames.clear();
        this.clearFilterChainsCache();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            ServletContext servletContext = filterConfig.getServletContext();
            this.readLiferayFilterWebXML(servletContext, "/WEB-INF/liferay-web.xml");
            Registry registry = RegistryUtil.getRegistry();
            String servletContextName = GetterUtil.getString(servletContext.getServletContextName());
            String portalServletContextName = PortalUtil.getServletContextName();
            if (servletContextName.equals(portalServletContextName)) {
                servletContextName = "";
            }
            com.liferay.registry.Filter filter = registry.getFilter(StringBundler.concat("(&(objectClass=", Filter.class.getName(), ")(servlet-context-name=", servletContextName, ")(servlet-filter-name=*))"));
            this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new FilterServiceTrackerCustomizer());
            this._serviceTracker.open();
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerFilterMapping(FilterMapping filterMapping, String positionFilterName, boolean after) {
        String filterName = filterMapping.getFilterName();
        while (true) {
            List oldFilterMappings = (List)this._filterMappingsMap.get(filterName);
            ArrayList<FilterMapping> newFilterMappings = null;
            newFilterMappings = oldFilterMappings == null ? new ArrayList<FilterMapping>() : new ArrayList(oldFilterMappings);
            newFilterMappings.add(filterMapping);
            if (newFilterMappings.size() == 1) {
                if (this._filterMappingsMap.putIfAbsent(filterName, newFilterMappings) != null) continue;
                int index = this._filterNames.indexOf(positionFilterName);
                if (index == -1) {
                    this._filterNames.add(filterName);
                    return;
                }
                if (after) {
                    this._filterNames.add(index + 1, filterName);
                    return;
                }
                this._filterNames.add(index, filterName);
                return;
            }
            if (this._filterMappingsMap.replace(filterName, oldFilterMappings, newFilterMappings)) return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unregisterFilterMapping(FilterMapping filterMapping) {
        String filterName = filterMapping.getFilterName();
        while (true) {
            List oldFilterMappings = (List)this._filterMappingsMap.get(filterName);
            ArrayList newFilterMappings = new ArrayList(oldFilterMappings);
            newFilterMappings.remove(filterMapping);
            if (newFilterMappings.isEmpty()) {
                if (!this._filterMappingsMap.remove(filterName, oldFilterMappings)) continue;
                this._filterNames.remove(filterName);
                return;
            }
            if (this._filterMappingsMap.replace(filterName, oldFilterMappings, newFilterMappings)) return;
        }
    }

    public void unregisterFilterMappings(String filterName) {
        List filterMappings = (List)this._filterMappingsMap.remove(filterName);
        if (filterMappings == null) {
            return;
        }
        FilterMapping filterMapping = (FilterMapping)filterMappings.get(0);
        Filter filter = filterMapping.getFilter();
        if (filter != null) {
            try {
                filter.destroy();
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        this._filterNames.remove(filterName);
        this.clearFilterChainsCache();
    }

    public void updateFilterMappings(String filterName, Filter filter) {
        ArrayList<FilterMapping> newFilterMappings;
        List oldFilterMappings;
        do {
            if ((oldFilterMappings = (List)this._filterMappingsMap.get(filterName)) == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn("No filter mappings for filter name " + filterName);
                }
                return;
            }
            newFilterMappings = new ArrayList<FilterMapping>();
            for (FilterMapping oldFilterMapping : oldFilterMappings) {
                newFilterMappings.add(oldFilterMapping.replaceFilter(filter));
            }
        } while (!this._filterMappingsMap.replace(filterName, oldFilterMappings, newFilterMappings));
    }

    protected void addInvokerFilter(InvokerFilter invokerFilter) {
        this._invokerFilters.add(invokerFilter);
    }

    protected void clearFilterChainsCache() {
        for (InvokerFilter invokerFilter : this._invokerFilters) {
            invokerFilter.clearFilterChainsCache();
        }
    }

    protected InvokerFilterChain createInvokerFilterChain(HttpServletRequest request, Dispatcher dispatcher, String uri, FilterChain filterChain) {
        InvokerFilterChain invokerFilterChain = new InvokerFilterChain(filterChain);
        for (String filterName : this._filterNames) {
            List filterMappings = (List)this._filterMappingsMap.get(filterName);
            if (filterMappings == null) continue;
            for (FilterMapping filterMapping : filterMappings) {
                if (!filterMapping.isMatch(request, dispatcher, uri)) continue;
                invokerFilterChain.addFilter(filterMapping.getFilter());
            }
        }
        return invokerFilterChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Filter initFilter(ServletContext servletContext, String filterClassName, FilterConfig filterConfig) {
        ClassLoader portalClassLoader;
        ClassLoader pluginClassLoader = (ClassLoader)servletContext.getAttribute("PLUGIN_CLASS_LOADER");
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (pluginClassLoader == null) {
            pluginClassLoader = contextClassLoader;
        }
        if ((portalClassLoader = PortalClassLoaderUtil.getClassLoader()) != pluginClassLoader) {
            pluginClassLoader = AggregateClassLoader.getAggregateClassLoader(portalClassLoader, pluginClassLoader);
        }
        if (contextClassLoader != pluginClassLoader) {
            currentThread.setContextClassLoader(pluginClassLoader);
        }
        try {
            Filter filter = (Filter)InstanceFactory.newInstance(pluginClassLoader, filterClassName);
            filter.init(filterConfig);
            Filter filter2 = filter;
            return filter2;
        }
        catch (Exception e) {
            _log.error("Unable to initialize filter " + filterClassName, e);
            Filter filter = null;
            return filter;
        }
        finally {
            if (contextClassLoader != pluginClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    @Deprecated
    protected Filter initFilter(ServletContext servletContext, String filterClassName, String filterName, FilterConfig filterConfig) {
        return this.initFilter(servletContext, filterClassName, filterConfig);
    }

    protected void readLiferayFilterWebXML(ServletContext servletContext, String path) throws Exception {
        InputStream inputStream = servletContext.getResourceAsStream(path);
        if (inputStream == null) {
            return;
        }
        Document document = UnsecureSAXReaderUtil.read(inputStream, true);
        Element rootElement = document.getRootElement();
        HashMap<String, ObjectValuePair<Filter, Object>> filterObjectValuePairs = new HashMap<String, ObjectValuePair<Filter, Object>>();
        for (Element filterElement : rootElement.elements("filter")) {
            String filterName = filterElement.elementText("filter-name");
            String filterClassName = filterElement.elementText("filter-class");
            HashMap<String, String> initParameterMap = new HashMap<String, String>();
            List<Element> initParamElements = filterElement.elements("init-param");
            for (Element initParamElement : initParamElements) {
                String name = initParamElement.elementText("param-name");
                String value = initParamElement.elementText("param-value");
                initParameterMap.put(name, value);
            }
            InvokerFilterConfig filterConfig = new InvokerFilterConfig(servletContext, filterName, initParameterMap);
            Filter filter = this.initFilter(servletContext, filterClassName, filterConfig);
            if (filter == null) continue;
            filterObjectValuePairs.put(filterName, new ObjectValuePair<Filter, Object>(filter, filterConfig));
        }
        List<Element> filterMappingElements = rootElement.elements("filter-mapping");
        for (Element filterMappingElement : filterMappingElements) {
            String filterName = filterMappingElement.elementText("filter-name");
            ArrayList<String> urlPatterns = new ArrayList<String>();
            List<Element> urlPatternElements = filterMappingElement.elements("url-pattern");
            for (Element urlPatternElement : urlPatternElements) {
                urlPatterns.add(urlPatternElement.getTextTrim());
            }
            ArrayList<String> dispatchers = new ArrayList<String>(4);
            List<Element> dispatcherElements = filterMappingElement.elements("dispatcher");
            for (Element dispatcherElement : dispatcherElements) {
                String dispatcher = StringUtil.toUpperCase(dispatcherElement.getTextTrim());
                dispatchers.add(dispatcher);
            }
            ObjectValuePair filterObjectValuePair = (ObjectValuePair)filterObjectValuePairs.get(filterName);
            if (filterObjectValuePair == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn("No filter and filter config for filter name " + filterName);
                continue;
            }
            FilterMapping filterMapping = new FilterMapping(filterName, (Filter)filterObjectValuePair.getKey(), (FilterConfig)filterObjectValuePair.getValue(), urlPatterns, dispatchers);
            this.registerFilterMapping(filterMapping, null, true);
        }
    }

    private class FilterServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Filter, FilterMapping> {
        private FilterServiceTrackerCustomizer() {
        }

        public FilterMapping addingService(ServiceReference<Filter> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            Filter filter = (Filter)registry.getService(serviceReference);
            String afterFilter = GetterUtil.getString(serviceReference.getProperty("after-filter"));
            String beforeFilter = GetterUtil.getString(serviceReference.getProperty("before-filter"));
            List dispatchers = StringPlus.asList((Object)serviceReference.getProperty("dispatcher"));
            String servletContextName = GetterUtil.getString(serviceReference.getProperty("servlet-context-name"));
            String servletFilterName = GetterUtil.getString(serviceReference.getProperty("servlet-filter-name"));
            List urlPatterns = StringPlus.asList((Object)serviceReference.getProperty("url-pattern"));
            String positionFilterName = beforeFilter;
            boolean after = false;
            if (Validator.isNotNull(afterFilter)) {
                positionFilterName = afterFilter;
                after = true;
            }
            HashMap<String, String> initParameterMap = new HashMap<String, String>();
            Map properties = serviceReference.getProperties();
            for (String key : properties.keySet()) {
                if (!key.startsWith("init.param.")) continue;
                String value = GetterUtil.getString(serviceReference.getProperty(key));
                initParameterMap.put(StringUtil.replace(key, "init.param.", ""), value);
            }
            ServletContext servletContext = ServletContextPool.get(servletContextName);
            InvokerFilterConfig filterConfig = new InvokerFilterConfig(servletContext, servletFilterName, initParameterMap);
            try {
                filter.init((FilterConfig)filterConfig);
            }
            catch (ServletException se) {
                _log.error((Object)se, se);
                registry.ungetService(serviceReference);
                return null;
            }
            InvokerFilterHelper.this.updateFilterMappings(servletFilterName, filter);
            FilterMapping filterMapping = new FilterMapping(servletFilterName, filter, filterConfig, urlPatterns, dispatchers);
            InvokerFilterHelper.this.registerFilterMapping(filterMapping, positionFilterName, after);
            InvokerFilterHelper.this.clearFilterChainsCache();
            return filterMapping;
        }

        public void modifiedService(ServiceReference<Filter> serviceReference, FilterMapping filterMapping) {
            this.removedService(serviceReference, filterMapping);
            this.addingService((ServiceReference)serviceReference);
        }

        public void removedService(ServiceReference<Filter> serviceReference, FilterMapping filterMapping) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            InvokerFilterHelper.this.unregisterFilterMappings(GetterUtil.getString(serviceReference.getProperty("servlet-filter-name")));
        }
    }
}

