/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineHelperUtil;
import com.liferay.portal.kernel.search.facet.MultiValueFacet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;

@Deprecated
public class AssetEntriesFacet
extends MultiValueFacet {
    private static final Log _log = LogFactoryUtil.getLog(AssetEntriesFacet.class);

    public AssetEntriesFacet(SearchContext searchContext) {
        super(searchContext);
        this.setFieldName("entryClassName");
        this.initFacetClause();
    }

    @Override
    public void setFacetConfiguration(FacetConfiguration facetConfiguration) {
        super.setFacetConfiguration(facetConfiguration);
        this.initFacetClause();
    }

    @Override
    protected BooleanClause<Filter> doGetFacetFilterBooleanClause() {
        SearchContext searchContext = this.getSearchContext();
        String[] entryClassNames = searchContext.getEntryClassNames();
        BooleanFilter facetFilter = new BooleanFilter();
        for (String entryClassName : entryClassNames) {
            String searchEngineId;
            Indexer indexer = IndexerRegistryUtil.getIndexer(entryClassName);
            if (indexer == null || !(searchEngineId = searchContext.getSearchEngineId()).equals(indexer.getSearchEngineId())) continue;
            try {
                BooleanFilter indexerBooleanFilter = indexer.getFacetBooleanFilter(entryClassName, searchContext);
                if (indexerBooleanFilter == null || !indexerBooleanFilter.hasClauses()) continue;
                BooleanFilter entityBooleanFilter = new BooleanFilter();
                entityBooleanFilter.add(indexerBooleanFilter, BooleanClauseOccur.MUST);
                indexer.postProcessContextBooleanFilter(entityBooleanFilter, searchContext);
                for (IndexerPostProcessor indexerPostProcessor : indexer.getIndexerPostProcessors()) {
                    indexerPostProcessor.postProcessContextBooleanFilter(entityBooleanFilter, searchContext);
                }
                this.postProcessContextQuery(entityBooleanFilter, searchContext, indexer);
                if (indexer.isStagingAware()) {
                    if (!searchContext.isIncludeLiveGroups() && searchContext.isIncludeStagingGroups()) {
                        entityBooleanFilter.addRequiredTerm("stagingGroup", true);
                    } else if (searchContext.isIncludeLiveGroups() && !searchContext.isIncludeStagingGroups()) {
                        entityBooleanFilter.addRequiredTerm("stagingGroup", false);
                    }
                }
                if (!entityBooleanFilter.hasClauses()) continue;
                facetFilter.add(entityBooleanFilter, BooleanClauseOccur.SHOULD);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        if (!facetFilter.hasClauses()) {
            return null;
        }
        return BooleanClauseFactoryUtil.createFilter(searchContext, facetFilter, BooleanClauseOccur.MUST);
    }

    protected void initFacetClause() {
        Object[] entryClassNameParam;
        SearchContext searchContext = this.getSearchContext();
        FacetConfiguration facetConfiguration = this.getFacetConfiguration();
        JSONObject dataJSONObject = facetConfiguration.getData();
        Object[] entryClassNames = null;
        if (dataJSONObject.has("values")) {
            JSONArray valuesJSONArray = dataJSONObject.getJSONArray("values");
            entryClassNames = new String[valuesJSONArray.length()];
            for (int i = 0; i < valuesJSONArray.length(); ++i) {
                entryClassNames[i] = valuesJSONArray.getString(i);
            }
        }
        if (ArrayUtil.isEmpty(entryClassNames)) {
            entryClassNames = searchContext.getEntryClassNames();
        }
        if (!this.isStatic() && ArrayUtil.isNotEmpty(entryClassNameParam = StringUtil.split(GetterUtil.getString(searchContext.getAttribute(this.getFieldName()))))) {
            entryClassNames = entryClassNameParam;
        }
        if (ArrayUtil.isEmpty(entryClassNames)) {
            entryClassNames = SearchEngineHelperUtil.getEntryClassNames();
            if (!dataJSONObject.has("values")) {
                JSONArray entriesJSONArray = JSONFactoryUtil.createJSONArray();
                for (Object entryClassName : entryClassNames) {
                    entriesJSONArray.put((String)entryClassName);
                }
                dataJSONObject.put("values", entriesJSONArray);
            }
        }
        searchContext.setEntryClassNames((String[])entryClassNames);
    }

    @Deprecated
    protected void postProcessContextQuery(BooleanFilter entityFilter, SearchContext searchContext, Indexer<?> indexer) throws Exception {
        BooleanQueryImpl entityBooleanQuery = new BooleanQueryImpl();
        indexer.postProcessContextQuery(entityBooleanQuery, searchContext);
        for (IndexerPostProcessor indexerPostProcessor : indexer.getIndexerPostProcessors()) {
            indexerPostProcessor.postProcessContextQuery(entityBooleanQuery, searchContext);
        }
        if (entityBooleanQuery.hasClauses()) {
            QueryFilter queryFilter = new QueryFilter(entityBooleanQuery);
            entityFilter.add(queryFilter, BooleanClauseOccur.MUST);
        }
    }
}

