/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.language;

import com.liferay.petra.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.petra.memory.FinalizeManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class UTF8Control
extends ResourceBundle.Control {
    public static final UTF8Control INSTANCE = new UTF8Control();
    private static final Map<URL, CachedResourceBundle> _cachedResourceBundles = new ConcurrentReferenceValueHashMap(FinalizeManager.SOFT_REFERENCE_FACTORY);

    @Override
    public Locale getFallbackLocale(String baseName, Locale locale) {
        return null;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader classLoader, boolean reload) throws IOException {
        CachedResourceBundle cachedResourceBundle;
        URL url = classLoader.getResource(this.toResourceName(this.toBundleName(baseName, locale), "properties"));
        if (url == null) {
            return null;
        }
        URLConnection urlConnection = url.openConnection();
        urlConnection.setUseCaches(!reload);
        if (!reload && (cachedResourceBundle = _cachedResourceBundles.get(url)) != null && urlConnection.getLastModified() <= cachedResourceBundle.getLastModified()) {
            return cachedResourceBundle.getResourceBundle();
        }
        try (InputStream inputStream = urlConnection.getInputStream();){
            PropertyResourceBundle resourceBundle = new PropertyResourceBundle(new InputStreamReader(inputStream, "UTF-8"));
            CachedResourceBundle cachedResourceBundle2 = new CachedResourceBundle(resourceBundle, urlConnection.getLastModified());
            _cachedResourceBundles.put(url, cachedResourceBundle2);
            PropertyResourceBundle propertyResourceBundle = resourceBundle;
            return propertyResourceBundle;
        }
    }

    private static final class CachedResourceBundle {
        private final long _lastModified;
        private final ResourceBundle _resourceBundle;

        public CachedResourceBundle(ResourceBundle resourceBundle, long lastModified) {
            this._resourceBundle = resourceBundle;
            this._lastModified = lastModified;
        }

        public long getLastModified() {
            return this._lastModified;
        }

        public ResourceBundle getResourceBundle() {
            return this._resourceBundle;
        }
    }
}

