/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@Deprecated
public class CharPipe {
    protected char[] buffer;
    protected Lock bufferLock = new ReentrantLock();
    protected int count;
    protected boolean finished;
    protected Condition notEmpty = this.bufferLock.newCondition();
    protected Condition notFull = this.bufferLock.newCondition();
    protected int readIndex;
    protected int writeIndex;
    private static final int _DEFAULT_BUFFER_SIZE = 8192;
    private final PipeReader _pipeReader = new PipeReader();
    private final PipeWriter _pipeWriter = new PipeWriter();

    public CharPipe() {
        this(8192);
    }

    public CharPipe(int bufferSize) {
        this.buffer = new char[bufferSize];
        this.count = 0;
        this.readIndex = 0;
        this.writeIndex = 0;
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean force) {
        this._pipeWriter.close();
        if (force) {
            this._pipeReader.close();
            this.buffer = null;
        } else {
            this.bufferLock.lock();
            this.finished = true;
            try {
                this.notEmpty.signalAll();
            }
            finally {
                this.bufferLock.unlock();
            }
        }
    }

    public Reader getReader() {
        return this._pipeReader;
    }

    public Writer getWriter() {
        return this._pipeWriter;
    }

    private class PipeWriter
    extends Writer {
        private volatile boolean _closed;

        private PipeWriter() {
        }

        @Override
        public Writer append(char c) throws IOException {
            this.write(c);
            return this;
        }

        @Override
        public Writer append(CharSequence charSequence) throws IOException {
            String string = null;
            string = charSequence == null ? "null" : charSequence.toString();
            this.write(string, 0, string.length());
            return this;
        }

        @Override
        public Writer append(CharSequence charSequence, int start, int end) throws IOException {
            String string = null;
            string = charSequence == null ? "null" : charSequence.subSequence(start, end).toString();
            this.write(string, 0, string.length());
            return this;
        }

        @Override
        public void close() {
            CharPipe.this.bufferLock.lock();
            try {
                this._closed = true;
                CharPipe.this.notFull.signalAll();
            }
            finally {
                CharPipe.this.bufferLock.unlock();
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] chars) throws IOException {
            this.write(chars, 0, chars.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(char[] chars, int offset, int length) throws IOException {
            if (this._closed) {
                throw new IOException("Stream closed");
            }
            if (length <= 0) {
                return;
            }
            CharPipe.this.bufferLock.lock();
            try {
                int write;
                for (int remaining = length; remaining > 0; remaining -= write) {
                    this.waitUntilNotFull();
                    write = remaining;
                    if (remaining > CharPipe.this.buffer.length - CharPipe.this.count) {
                        write = CharPipe.this.buffer.length - CharPipe.this.count;
                    }
                    int sourceBegin = offset + length - remaining;
                    if (CharPipe.this.buffer.length - CharPipe.this.writeIndex >= write) {
                        System.arraycopy(chars, sourceBegin, CharPipe.this.buffer, CharPipe.this.writeIndex, write);
                    } else {
                        int tailLength = CharPipe.this.buffer.length - CharPipe.this.writeIndex;
                        int headLength = write - tailLength;
                        System.arraycopy(chars, sourceBegin, CharPipe.this.buffer, CharPipe.this.writeIndex, tailLength);
                        System.arraycopy(chars, sourceBegin + tailLength, CharPipe.this.buffer, 0, headLength);
                    }
                    this._increaseWriteIndex(write);
                }
            }
            finally {
                CharPipe.this.bufferLock.unlock();
            }
        }

        @Override
        public void write(int c) throws IOException {
            if (this._closed) {
                throw new IOException("Stream closed");
            }
            CharPipe.this.bufferLock.lock();
            try {
                this.waitUntilNotFull();
                CharPipe.this.buffer[CharPipe.this.writeIndex] = (char)c;
                this._increaseWriteIndex(1);
            }
            finally {
                CharPipe.this.bufferLock.unlock();
            }
        }

        @Override
        public void write(String string) throws IOException {
            this.write(string, 0, string.length());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(String string, int offset, int length) throws IOException {
            if (this._closed) {
                throw new IOException("Stream closed");
            }
            if (length <= 0) {
                return;
            }
            CharPipe.this.bufferLock.lock();
            try {
                int write;
                for (int remaining = length; remaining > 0; remaining -= write) {
                    this.waitUntilNotFull();
                    write = remaining;
                    if (remaining > CharPipe.this.buffer.length - CharPipe.this.count) {
                        write = CharPipe.this.buffer.length - CharPipe.this.count;
                    }
                    int sourceBegin = offset + length - remaining;
                    if (CharPipe.this.buffer.length - CharPipe.this.writeIndex >= write) {
                        string.getChars(sourceBegin, sourceBegin + write, CharPipe.this.buffer, CharPipe.this.writeIndex);
                    } else {
                        int tailLength = CharPipe.this.buffer.length - CharPipe.this.writeIndex;
                        int headLength = write - tailLength;
                        string.getChars(sourceBegin, sourceBegin + tailLength, CharPipe.this.buffer, CharPipe.this.writeIndex);
                        string.getChars(sourceBegin + tailLength, sourceBegin + tailLength + headLength, CharPipe.this.buffer, 0);
                    }
                    this._increaseWriteIndex(write);
                }
            }
            finally {
                CharPipe.this.bufferLock.unlock();
            }
        }

        protected void waitUntilNotFull() throws IOException {
            while (CharPipe.this.count == CharPipe.this.buffer.length) {
                CharPipe.this.notFull.awaitUninterruptibly();
                if (!this._closed) continue;
                throw new IOException("Stream closed");
            }
        }

        private void _increaseWriteIndex(int produced) {
            CharPipe.this.writeIndex += produced;
            if (CharPipe.this.writeIndex >= CharPipe.this.buffer.length) {
                CharPipe.this.writeIndex -= CharPipe.this.buffer.length;
            }
            if (CharPipe.this.count == 0) {
                CharPipe.this.notEmpty.signalAll();
            }
            CharPipe.this.count += produced;
        }
    }

    private class PipeReader
    extends Reader {
        private static final int _MAX_SKIP_BUFFER_SIZE = 8192;
        private volatile boolean _closed;
        private char[] _skipBuffer;

        private PipeReader() {
        }

        @Override
        public void close() {
            CharPipe.this.bufferLock.lock();
            try {
                this._closed = true;
                CharPipe.this.notEmpty.signalAll();
            }
            finally {
                CharPipe.this.bufferLock.unlock();
            }
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            throw new IOException("Mark is not supported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            if (this._closed) {
                throw new IOException("Stream closed");
            }
            CharPipe.this.bufferLock.lock();
            try {
                if (this.waitUntilNotEmpty()) {
                    int n = -1;
                    return n;
                }
                char result = CharPipe.this.buffer[CharPipe.this.readIndex];
                this._increaseReadIndex(1);
                char c = result;
                return c;
            }
            finally {
                CharPipe.this.bufferLock.unlock();
            }
        }

        @Override
        public int read(char[] chars) throws IOException {
            return this.read(chars, 0, chars.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(char[] chars, int offset, int length) throws IOException {
            if (this._closed) {
                throw new IOException("Stream closed");
            }
            if (length <= 0) {
                return 0;
            }
            CharPipe.this.bufferLock.lock();
            try {
                if (this.waitUntilNotEmpty()) {
                    int n = -1;
                    return n;
                }
                int read = length;
                if (length > CharPipe.this.count) {
                    read = CharPipe.this.count;
                }
                if (CharPipe.this.buffer.length - CharPipe.this.readIndex >= read) {
                    System.arraycopy(CharPipe.this.buffer, CharPipe.this.readIndex, chars, offset, read);
                } else {
                    int tailLength = CharPipe.this.buffer.length - CharPipe.this.readIndex;
                    int headLength = read - tailLength;
                    System.arraycopy(CharPipe.this.buffer, CharPipe.this.readIndex, chars, offset, tailLength);
                    System.arraycopy(CharPipe.this.buffer, 0, chars, offset + tailLength, headLength);
                }
                this._increaseReadIndex(read);
                int n = read;
                return n;
            }
            finally {
                CharPipe.this.bufferLock.unlock();
            }
        }

        @Override
        public int read(CharBuffer charBuffer) throws IOException {
            if (this._closed) {
                throw new IOException("Stream closed");
            }
            int length = charBuffer.remaining();
            if (length <= 0) {
                return 0;
            }
            char[] tempBuffer = new char[length];
            int read = this.read(tempBuffer, 0, length);
            if (read > 0) {
                charBuffer.put(tempBuffer, 0, read);
            }
            return read;
        }

        @Override
        public boolean ready() throws IOException {
            if (this._closed) {
                throw new IOException("Stream closed");
            }
            CharPipe.this.bufferLock.lock();
            try {
                if (CharPipe.this.count > 0) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                CharPipe.this.bufferLock.unlock();
            }
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("Reset is not supported");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long skip) throws IOException {
            if (skip < 0L) {
                throw new IllegalArgumentException("Skip value is negative");
            }
            if (this._closed) {
                throw new IOException("Stream closed");
            }
            int skipBufferSize = (int)Math.min(skip, 8192L);
            CharPipe.this.bufferLock.lock();
            try {
                long remaining;
                int skipped;
                if (this._skipBuffer == null || this._skipBuffer.length < skipBufferSize) {
                    this._skipBuffer = new char[skipBufferSize];
                }
                for (remaining = skip; remaining > 0L && (skipped = this.read(this._skipBuffer, 0, (int)Math.min(remaining, (long)skipBufferSize))) != -1; remaining -= (long)skipped) {
                }
                long l = skip - remaining;
                return l;
            }
            finally {
                CharPipe.this.bufferLock.unlock();
            }
        }

        protected boolean waitUntilNotEmpty() throws IOException {
            while (CharPipe.this.count == 0 && !CharPipe.this.finished) {
                CharPipe.this.notEmpty.awaitUninterruptibly();
                if (!this._closed) continue;
                throw new IOException("Stream closed");
            }
            return CharPipe.this.count == 0 && CharPipe.this.finished;
        }

        private void _increaseReadIndex(int consumed) {
            CharPipe.this.readIndex += consumed;
            if (CharPipe.this.readIndex >= CharPipe.this.buffer.length) {
                CharPipe.this.readIndex -= CharPipe.this.buffer.length;
            }
            if (CharPipe.this.count == CharPipe.this.buffer.length) {
                CharPipe.this.notFull.signalAll();
            }
            CharPipe.this.count -= consumed;
        }
    }
}

