/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class ClusterNodeResponses
implements Serializable {
    private final Map<String, ClusterNodeResponse> _clusterResponsesByClusterNode = new ConcurrentHashMap<String, ClusterNodeResponse>();
    private final BlockingQueue<ClusterNodeResponse> _clusterResponsesQueue = new LinkedBlockingQueue<ClusterNodeResponse>();
    private final Set<String> _expectedReplyNodeIds = Collections.newSetFromMap(new ConcurrentHashMap());

    public ClusterNodeResponses(Set<String> expectedReplyNodeIds) {
        this._expectedReplyNodeIds.addAll(expectedReplyNodeIds);
    }

    public boolean addClusterResponse(ClusterNodeResponse clusterNodeResponse) {
        ClusterNode clusterNode = clusterNodeResponse.getClusterNode();
        String clusterNodeId = clusterNode.getClusterNodeId();
        if (this._expectedReplyNodeIds.remove(clusterNodeId)) {
            this._clusterResponsesByClusterNode.put(clusterNodeId, clusterNodeResponse);
            this._clusterResponsesQueue.offer(clusterNodeResponse);
            return true;
        }
        return false;
    }

    public ClusterNodeResponse getClusterResponse(String clusterNodeId) {
        return this._clusterResponsesByClusterNode.get(clusterNodeId);
    }

    public BlockingQueue<ClusterNodeResponse> getClusterResponses() {
        return this._clusterResponsesQueue;
    }

    public int size() {
        return this._clusterResponsesByClusterNode.size();
    }
}

