/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.trackback;

import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.CommentManagerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.blogs.linkback.LinkbackConsumer;
import com.liferay.portlet.blogs.linkback.LinkbackConsumerUtil;
import com.liferay.portlet.blogs.trackback.Trackback;

public class TrackbackImpl
implements Trackback {
    @Override
    public void addTrackback(BlogsEntry entry, ThemeDisplay themeDisplay, String excerpt, String url, String blogName, String title, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        long userId = UserLocalServiceUtil.getDefaultUserId((long)themeDisplay.getCompanyId());
        long groupId = entry.getGroupId();
        String className = BlogsEntry.class.getName();
        long classPK = entry.getEntryId();
        String body = this.buildBody(themeDisplay, excerpt, url);
        long commentId = CommentManagerUtil.addComment((long)userId, (long)groupId, (String)className, (long)classPK, (String)blogName, (String)title, (String)body, serviceContextFunction);
        String entryURL = this.buildEntryURL(entry, themeDisplay);
        LinkbackConsumerUtil.addNewTrackback(commentId, url, entryURL);
    }

    @Override
    @Deprecated
    public void setCommentManager(CommentManager commentManager) {
    }

    @Override
    @Deprecated
    public void setLinkbackConsumer(LinkbackConsumer linkbackConsumer) {
    }

    protected String buildBBCodeBody(ThemeDisplay themeDisplay, String excerpt, String url) {
        url = StringUtil.replace((String)url, (char[])new char[]{']', '['}, (String[])new String[]{"%5D", "%5B"});
        StringBundler sb = new StringBundler(7);
        sb.append("[...] ");
        sb.append(excerpt);
        sb.append(" [...] [url=");
        sb.append(url);
        sb.append("]");
        sb.append(themeDisplay.translate("read-more"));
        sb.append("[/url]");
        return sb.toString();
    }

    protected String buildBody(ThemeDisplay themeDisplay, String excerpt, String url) {
        if (PropsValues.DISCUSSION_COMMENTS_FORMAT.equals("bbcode")) {
            return this.buildBBCodeBody(themeDisplay, excerpt, url);
        }
        return this.buildHTMLBody(themeDisplay, excerpt, url);
    }

    protected String buildEntryURL(BlogsEntry entry, ThemeDisplay themeDisplay) throws PortalException {
        StringBundler sb = new StringBundler(4);
        sb.append(PortalUtil.getLayoutFullURL((ThemeDisplay)themeDisplay));
        sb.append("/-/");
        sb.append("blogs/");
        sb.append(entry.getUrlTitle());
        return sb.toString();
    }

    protected String buildHTMLBody(ThemeDisplay themeDisplay, String excerpt, String url) {
        StringBundler sb = new StringBundler(7);
        sb.append("[...] ");
        sb.append(excerpt);
        sb.append(" [...] <a href=\"");
        sb.append(url);
        sb.append("\">");
        sb.append(themeDisplay.translate("read-more"));
        sb.append("</a>");
        return sb.toString();
    }
}

