/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.struts.StrutsPortletAction;
import com.liferay.portal.struts.ActionAdapter;
import com.liferay.portal.struts.PortletActionAdapter;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.StringServiceRegistrationMap;
import com.liferay.registry.collections.StringServiceRegistrationMapImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.struts.action.Action;

public class StrutsActionRegistryUtil {
    private static final StrutsActionRegistryUtil _instance = new StrutsActionRegistryUtil();
    private final Map<String, Action> _actions = new ConcurrentHashMap<String, Action>();
    private final ServiceTracker<?, Action> _serviceTracker;
    private final StringServiceRegistrationMap<StrutsAction> _strutsActionServiceRegistrations = new StringServiceRegistrationMapImpl();
    private final StringServiceRegistrationMap<StrutsPortletAction> _strutsPortletActionServiceRegistrations = new StringServiceRegistrationMapImpl();

    public static Action getAction(String path) {
        return _instance._getAction(path);
    }

    public static Map<String, Action> getActions() {
        return _instance._getActions();
    }

    public static void register(String path, StrutsAction strutsAction) {
        _instance._register(path, strutsAction);
    }

    public static void register(String path, StrutsPortletAction strutsPortletAction) {
        _instance._register(path, strutsPortletAction);
    }

    public static void unregister(String path) {
        _instance._unregister(path);
    }

    private StrutsActionRegistryUtil() {
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(&(|(objectClass=" + StrutsAction.class.getName() + ")(objectClass=" + StrutsPortletAction.class.getName() + "))(path=*))");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new ActionServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private Action _getAction(String path) {
        Action action = this._actions.get(path);
        if (action != null) {
            return action;
        }
        for (Map.Entry<String, Action> entry : this._actions.entrySet()) {
            if (!path.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private Map<String, Action> _getActions() {
        return this._actions;
    }

    private void _register(String path, StrutsAction strutsAction) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("path", path);
        ServiceRegistration serviceRegistration = registry.registerService(StrutsAction.class, (Object)strutsAction, properties);
        this._strutsActionServiceRegistrations.put((Object)path, (Object)serviceRegistration);
    }

    private void _register(String path, StrutsPortletAction strutsPortletAction) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("path", path);
        ServiceRegistration serviceRegistration = registry.registerService(StrutsPortletAction.class, (Object)strutsPortletAction, properties);
        this._strutsPortletActionServiceRegistrations.put((Object)path, (Object)serviceRegistration);
    }

    private void _unregister(String path) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._strutsActionServiceRegistrations.remove((Object)path);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
        if ((serviceRegistration = (ServiceRegistration)this._strutsPortletActionServiceRegistrations.remove((Object)path)) != null) {
            serviceRegistration.unregister();
        }
    }

    private class ActionServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Action> {
        private ActionServiceTrackerCustomizer() {
        }

        public Action addingService(ServiceReference<Object> serviceReference) {
            String[] paths;
            Registry registry = RegistryUtil.getRegistry();
            Object service = registry.getService(serviceReference);
            Action action = null;
            if (service instanceof StrutsAction) {
                action = new ActionAdapter((StrutsAction)service);
            } else if (service instanceof StrutsPortletAction) {
                action = new PortletActionAdapter((StrutsPortletAction)service);
            }
            for (String path : paths = this._getPaths(serviceReference)) {
                StrutsActionRegistryUtil.this._actions.put(path, action);
            }
            return action;
        }

        public void modifiedService(ServiceReference<Object> serviceReference, Action service) {
        }

        public void removedService(ServiceReference<Object> serviceReference, Action service) {
            String[] paths;
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            for (String path : paths = this._getPaths(serviceReference)) {
                StrutsActionRegistryUtil.this._actions.remove(path);
            }
        }

        private String[] _getPaths(ServiceReference<Object> serviceReference) {
            Object object = serviceReference.getProperty("path");
            if (object instanceof String[]) {
                return (String[])object;
            }
            return new String[]{(String)object};
        }
    }
}

