/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import com.liferay.portal.spring.aop.MethodInterceptorsBag;
import com.liferay.portal.spring.aop.ServiceBeanMethodInvocation;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ServiceBeanAopCacheManager {
    private static final Map<MethodInvocation, Annotation[]> _annotations = new ConcurrentHashMap<MethodInvocation, Annotation[]>();
    private static final Annotation[] _nullAnnotations = new Annotation[0];
    private final Map<Class<? extends Annotation>, AnnotationChainableMethodAdvice<?>[]> _annotationChainableMethodAdvices = new HashMap<Class<? extends Annotation>, AnnotationChainableMethodAdvice<?>[]>();
    private final Map<MethodInvocation, MethodInterceptorsBag> _methodInterceptorBags = new ConcurrentHashMap<MethodInvocation, MethodInterceptorsBag>();

    public static <T> T getAnnotation(MethodInvocation methodInvocation, Class<? extends Annotation> annotationType, T defaultValue) {
        Annotation[] annotations = _annotations.get(methodInvocation);
        if (annotations == _nullAnnotations) {
            return defaultValue;
        }
        if (annotations == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != annotationType) continue;
            return (T)annotation;
        }
        return defaultValue;
    }

    public static void putAnnotations(MethodInvocation methodInvocation, Annotation[] annotations) {
        if (ArrayUtil.isEmpty((Object[])annotations)) {
            annotations = _nullAnnotations;
        }
        if (methodInvocation instanceof ServiceBeanMethodInvocation) {
            ServiceBeanMethodInvocation serviceBeanMethodInvocation = (ServiceBeanMethodInvocation)methodInvocation;
            methodInvocation = serviceBeanMethodInvocation.toCacheKeyModel();
        }
        _annotations.put(methodInvocation, annotations);
    }

    public MethodInterceptorsBag getMethodInterceptorsBag(MethodInvocation methodInvocation) {
        return this._methodInterceptorBags.get(methodInvocation);
    }

    public Map<Class<? extends Annotation>, AnnotationChainableMethodAdvice<?>[]> getRegisteredAnnotationChainableMethodAdvices() {
        return this._annotationChainableMethodAdvices;
    }

    public boolean isRegisteredAnnotationClass(Class<? extends Annotation> annotationClass) {
        return this._annotationChainableMethodAdvices.containsKey(annotationClass);
    }

    public void putMethodInterceptorsBag(MethodInvocation methodInvocation, MethodInterceptorsBag methodInterceptorsBag) {
        this._methodInterceptorBags.put(methodInvocation, methodInterceptorsBag);
    }

    public void registerAnnotationChainableMethodAdvice(Class<? extends Annotation> annotationClass, AnnotationChainableMethodAdvice<?> annotationChainableMethodAdvice) {
        Object[] annotationChainableMethodAdvices = this._annotationChainableMethodAdvices.get(annotationClass);
        annotationChainableMethodAdvices = annotationChainableMethodAdvices == null ? new AnnotationChainableMethodAdvice[]{annotationChainableMethodAdvice} : (AnnotationChainableMethodAdvice[])ArrayUtil.append((Object[])annotationChainableMethodAdvices, annotationChainableMethodAdvice);
        this._annotationChainableMethodAdvices.put(annotationClass, (AnnotationChainableMethodAdvice<?>[])annotationChainableMethodAdvices);
    }

    public void removeMethodInterceptor(MethodInvocation methodInvocation, MethodInterceptor methodInterceptor) {
        if (!(methodInvocation instanceof ServiceBeanMethodInvocation)) {
            return;
        }
        ServiceBeanMethodInvocation serviceBeanMethodInvocation = (ServiceBeanMethodInvocation)methodInvocation;
        MethodInterceptorsBag methodInterceptorsBag = this._methodInterceptorBags.get(serviceBeanMethodInvocation);
        if (methodInterceptorsBag == null) {
            return;
        }
        ArrayList<MethodInterceptor> methodInterceptors = new ArrayList<MethodInterceptor>(methodInterceptorsBag.getMergedMethodInterceptors());
        methodInterceptors.remove(methodInterceptor);
        MethodInterceptorsBag newMethodInterceptorsBag = null;
        if (methodInterceptors.equals(methodInterceptorsBag.getClassLevelMethodInterceptors())) {
            newMethodInterceptorsBag = new MethodInterceptorsBag(methodInterceptorsBag.getClassLevelMethodInterceptors(), methodInterceptorsBag.getClassLevelMethodInterceptors());
        } else {
            methodInterceptors.trimToSize();
            newMethodInterceptorsBag = new MethodInterceptorsBag(methodInterceptorsBag.getClassLevelMethodInterceptors(), methodInterceptors);
        }
        this._methodInterceptorBags.put(serviceBeanMethodInvocation.toCacheKeyModel(), newMethodInterceptorsBag);
    }

    public void reset() {
        _annotations.clear();
        this._methodInterceptorBags.clear();
    }
}

