/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.membershippolicy;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.interval.IntervalActionProcessor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.membershippolicy.BaseSiteMembershipPolicy;
import com.liferay.portal.kernel.security.membershippolicy.MembershipPolicyException;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DefaultSiteMembershipPolicy
extends BaseSiteMembershipPolicy {
    private static final Log _log = LogFactoryUtil.getLog(DefaultSiteMembershipPolicy.class);

    public void checkMembership(long[] userIds, long[] addGroupIds, long[] removeGroupIds) throws PortalException {
        if (addGroupIds != null) {
            this.checkAddUsersLimitedGroup(userIds, addGroupIds);
        }
    }

    public boolean isMembershipAllowed(long userId, long groupId) {
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLimitedToParentSiteMembers() && !GroupLocalServiceUtil.hasUserGroup((long)userId, (long)group.getParentGroupId(), (boolean)false)) {
                return false;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return true;
    }

    public void propagateMembership(long[] userIds, long[] addGroupIds, long[] removeGroupIds) throws PortalException {
        if (removeGroupIds != null) {
            for (long removeGroupId : removeGroupIds) {
                this.removeUsersFromLimitedChildrenGroups(userIds, removeGroupId);
            }
        }
    }

    public void verifyPolicy(Group group) throws PortalException {
        if (group.isLimitedToParentSiteMembers()) {
            this.verifyLimitedParentMembership(group);
        }
    }

    public void verifyPolicy(Group group, Group oldGroup, List<AssetCategory> oldAssetCategories, List<AssetTag> oldAssetTags, Map<String, Serializable> oldExpandoAttributes, UnicodeProperties oldTypeSettingsProperties) throws PortalException {
        if (group.isLimitedToParentSiteMembers()) {
            if (group.getParentGroupId() == oldGroup.getParentGroupId() && oldGroup.isLimitedToParentSiteMembers()) {
                this.verifyPolicy(group);
            } else {
                List<Group> childrenGroups = this.getLimitedChildrenGroups(group);
                for (Group childrenGroup : childrenGroups) {
                    this.verifyPolicy(childrenGroup);
                }
            }
        }
    }

    protected void checkAddUsersLimitedGroup(long[] userIds, long[] groupIds) throws PortalException {
        MembershipPolicyException membershipPolicyException = null;
        for (long groupId : groupIds) {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (!group.isLimitedToParentSiteMembers()) continue;
            for (long userId : userIds) {
                if (GroupLocalServiceUtil.hasUserGroup((long)userId, (long)group.getParentGroupId(), (boolean)false)) continue;
                if (membershipPolicyException == null) {
                    membershipPolicyException = new MembershipPolicyException(5);
                }
                User user = UserLocalServiceUtil.getUser((long)userId);
                membershipPolicyException.addUser(user);
            }
            if (membershipPolicyException == null) continue;
            membershipPolicyException.addGroup(group);
        }
        if (membershipPolicyException != null) {
            throw membershipPolicyException;
        }
    }

    protected List<Group> getLimitedChildrenGroups(Group group) throws PortalException {
        ArrayList<Group> parentGroups = new ArrayList<Group>();
        parentGroups.add(group);
        LinkedHashMap<String, Serializable> groupParams = new LinkedHashMap<String, Serializable>();
        groupParams.put("groupsTree", parentGroups);
        groupParams.put("membershipRestriction", Integer.valueOf(1));
        groupParams.put("site", Boolean.TRUE);
        List childrenGroups = GroupLocalServiceUtil.search((long)group.getCompanyId(), null, (String)"", groupParams, (int)-1, (int)-1);
        List filteredChildrenGroups = ListUtil.copy((List)childrenGroups);
        block0: for (Group childrenGroup : childrenGroups) {
            for (Group ancestorGroup : childrenGroup.getAncestors()) {
                if (ancestorGroup.getGroupId() == group.getGroupId() || ancestorGroup.isLimitedToParentSiteMembers()) continue;
                filteredChildrenGroups.remove(childrenGroup);
                continue block0;
            }
        }
        return filteredChildrenGroups;
    }

    protected void removeUsersFromLimitedChildrenGroups(long[] userIds, long groupId) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        List<Group> childrenGroups = this.getLimitedChildrenGroups(group);
        for (Group childrenGroup : childrenGroups) {
            if (!childrenGroup.isLimitedToParentSiteMembers()) continue;
            for (long userId : userIds) {
                UserLocalServiceUtil.unsetGroupUsers((long)childrenGroup.getGroupId(), (long[])new long[]{userId}, null);
            }
        }
    }

    protected void verifyLimitedParentMembership(final Group group) throws PortalException {
        int total = UserLocalServiceUtil.getGroupUsersCount((long)group.getGroupId());
        final IntervalActionProcessor intervalActionProcessor = new IntervalActionProcessor(total);
        intervalActionProcessor.setPerformIntervalActionMethod((IntervalActionProcessor.PerformIntervalActionMethod)new IntervalActionProcessor.PerformIntervalActionMethod<Void>(){

            public Void performIntervalAction(int start, int end) throws PortalException {
                List users = UserLocalServiceUtil.getGroupUsers((long)group.getGroupId(), (int)start, (int)end);
                for (User user : users) {
                    if (!UserLocalServiceUtil.hasGroupUser((long)group.getParentGroupId(), (long)user.getUserId())) {
                        UserLocalServiceUtil.unsetGroupUsers((long)group.getGroupId(), (long[])new long[]{user.getUserId()}, null);
                        continue;
                    }
                    intervalActionProcessor.incrementStart();
                }
                return null;
            }
        });
        intervalActionProcessor.performIntervalActions();
    }
}

