/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;

public class ClassLoaderUtil {
    private static final PACL _pacl = new NoPACL();

    public static ClassLoader getAggregatePluginsClassLoader(String[] servletContextNames, boolean addContextClassLoader) {
        return _pacl.getAggregatePluginsClassLoader(servletContextNames, addContextClassLoader);
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        return _pacl.getClassLoader(clazz);
    }

    public static ClassLoader getContextClassLoader() {
        return _pacl.getContextClassLoader();
    }

    public static ClassLoader getPluginClassLoader(String servletContextName) {
        return _pacl.getPluginClassLoader(servletContextName);
    }

    public static ClassLoader getPortalClassLoader() {
        return _pacl.getPortalClassLoader();
    }

    public static void setContextClassLoader(ClassLoader classLoader) {
        _pacl.setContextClassLoader(classLoader);
    }

    public static interface PACL {
        public ClassLoader getAggregatePluginsClassLoader(String[] var1, boolean var2);

        public ClassLoader getClassLoader(Class<?> var1);

        public ClassLoader getContextClassLoader();

        public ClassLoader getPluginClassLoader(String var1);

        public ClassLoader getPortalClassLoader();

        public void setContextClassLoader(ClassLoader var1);
    }

    public static class NoPACL
    implements PACL {
        @Override
        public ClassLoader getAggregatePluginsClassLoader(String[] servletContextNames, boolean addContextClassLoader) {
            ClassLoader[] classLoaders = null;
            int offset = 0;
            if (addContextClassLoader) {
                classLoaders = new ClassLoader[servletContextNames.length + 1];
                Thread currentThread = Thread.currentThread();
                classLoaders[0] = currentThread.getContextClassLoader();
                offset = 1;
            } else {
                classLoaders = new ClassLoader[servletContextNames.length];
            }
            for (int i = 0; i < servletContextNames.length; ++i) {
                classLoaders[offset + i] = ClassLoaderPool.getClassLoader((String)servletContextNames[i]);
            }
            return AggregateClassLoader.getAggregateClassLoader(classLoaders);
        }

        @Override
        public ClassLoader getClassLoader(Class<?> clazz) {
            return clazz.getClassLoader();
        }

        @Override
        public ClassLoader getContextClassLoader() {
            Thread currentThread = Thread.currentThread();
            return currentThread.getContextClassLoader();
        }

        @Override
        public ClassLoader getPluginClassLoader(String servletContextName) {
            return ClassLoaderPool.getClassLoader((String)servletContextName);
        }

        @Override
        public ClassLoader getPortalClassLoader() {
            return PortalClassLoaderUtil.getClassLoader();
        }

        @Override
        public void setContextClassLoader(ClassLoader classLoader) {
            Thread thread = Thread.currentThread();
            thread.setContextClassLoader(classLoader);
        }
    }
}

