/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.HashMap;
import java.util.List;

public class Autocomplete {
    public static JSONArray arrayToJSONArray(List<?> list, String textParam, String valueParam) {
        return Autocomplete.arrayToJSONArray(Autocomplete.listToArray(list, textParam, valueParam), -1);
    }

    public static JSONArray arrayToJSONArray(String[] array, int max) {
        return Autocomplete.arrayToJSONArray(Autocomplete._singleToPairArray(array), max);
    }

    public static JSONArray arrayToJSONArray(String[][] array, int max) {
        if (max <= 0) {
            max = array.length;
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (int i = 0; i < array.length && i < max; ++i) {
            String text = array[i][0];
            String value = array[i][1];
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("text", text);
            map.put("value", value);
            jsonArray.put(map);
        }
        return jsonArray;
    }

    public static String arrayToXml(String[] array, int max) {
        return Autocomplete.arrayToXml(Autocomplete._singleToPairArray(array), max);
    }

    public static String arrayToXml(String[][] array, int max) {
        if (max <= 0) {
            max = array.length;
        }
        StringBundler sb = new StringBundler(array.length * 8 + 3);
        sb.append("<?xml version=\"1.0\"?>");
        sb.append("<ajaxresponse>");
        for (int i = 0; i < array.length && i < max; ++i) {
            String text = array[i][0];
            String value = array[i][1];
            sb.append("<item>");
            sb.append("<text><![CDATA[");
            sb.append(text);
            sb.append("]]></text>");
            sb.append("<value><![CDATA[");
            sb.append(value);
            sb.append("]]></value>");
            sb.append("</item>");
        }
        sb.append("</ajaxresponse>");
        return sb.toString();
    }

    public static String[][] listToArray(List<?> list, String textParam, String valueParam) {
        String[][] array = new String[list.size()][2];
        for (int i = 0; i < list.size(); ++i) {
            Object value;
            Object bean = list.get(i);
            Object text = BeanPropertiesUtil.getObject(bean, textParam);
            if (text == null) {
                text = "";
            }
            if ((value = BeanPropertiesUtil.getObject(bean, valueParam)) == null) {
                value = "";
            }
            array[i][0] = text.toString();
            array[i][1] = value.toString();
        }
        return array;
    }

    public static String listToXml(List<?> list, String textParam, String valueParam) {
        return Autocomplete.arrayToXml(Autocomplete.listToArray(list, textParam, valueParam), -1);
    }

    private static String[][] _singleToPairArray(String[] array) {
        String[][] pairArray = new String[array.length][2];
        for (int i = 0; i < array.length; ++i) {
            pairArray[i][0] = HtmlUtil.escape(array[i]);
            pairArray[i][1] = array[i];
        }
        return pairArray;
    }
}

