/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upload;

import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadHandler;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public abstract class BaseUploadHandler
implements UploadHandler {
    protected static final String TEMP_FOLDER_NAME = BaseUploadHandler.class.getName();
    private static final int _UNIQUE_FILE_NAME_TRIES = 50;

    @Override
    public void upload(PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest(portletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this.checkPermission(themeDisplay.getScopeGroupId(), this.getFolderId(uploadPortletRequest), themeDisplay.getPermissionChecker());
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            UploadException uploadException = (UploadException)portletRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                Throwable cause = uploadException.getCause();
                if (uploadException.isExceededFileSizeLimit()) {
                    throw new FileSizeException(cause);
                }
                if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                    throw new LiferayFileItemException(cause);
                }
                if (uploadException.isExceededUploadRequestSizeLimit()) {
                    throw new UploadRequestSizeException(cause);
                }
                throw new PortalException(cause);
            }
            JSONObject imageJSONObject = this.getImageJSONObject(portletRequest);
            String randomId = ParamUtil.getString(uploadPortletRequest, "randomId");
            imageJSONObject.put("randomId", randomId);
            jsonObject.put("file", imageJSONObject);
            jsonObject.put("success", Boolean.TRUE);
            JSONPortletResponseUtil.writeJSON(portletRequest, portletResponse, (Object)jsonObject);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe);
        }
        catch (PortalException pe) {
            this.handleUploadException(portletRequest, portletResponse, pe, jsonObject);
        }
    }

    protected abstract FileEntry addFileEntry(long var1, long var3, long var5, String var7, String var8, InputStream var9, long var10, ServiceContext var12) throws PortalException;

    protected abstract void checkPermission(long var1, long var3, PermissionChecker var5) throws PortalException;

    protected void doHandleUploadException(PortletRequest portletRequest, PortletResponse portletResponse, PortalException pe, JSONObject jsonObject) throws PortalException {
        throw pe;
    }

    protected abstract FileEntry fetchFileEntry(long var1, long var3, long var5, String var7) throws PortalException;

    protected long getFolderId(UploadPortletRequest uploadPortletRequest) {
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JSONObject getImageJSONObject(PortletRequest portletRequest) throws PortalException {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest(portletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONObject imageJSONObject = JSONFactoryUtil.createJSONObject();
        try {
            imageJSONObject.put("attributeDataImageId", "data-image-id");
            String parameterName = this.getParameterName();
            String fileName = uploadPortletRequest.getFileName(parameterName);
            String contentType = uploadPortletRequest.getContentType(parameterName);
            long size = uploadPortletRequest.getSize(parameterName);
            this.validateFile(fileName, contentType, size);
            long folderId = this.getFolderId(uploadPortletRequest);
            String uniqueFileName = this.getUniqueFileName(themeDisplay, fileName, folderId);
            try (InputStream inputStream = uploadPortletRequest.getFileAsStream(parameterName);){
                FileEntry fileEntry = this.addFileEntry(themeDisplay.getUserId(), themeDisplay.getScopeGroupId(), folderId, uniqueFileName, contentType, inputStream, size, this.getServiceContext(uploadPortletRequest));
                imageJSONObject.put("fileEntryId", fileEntry.getFileEntryId());
                imageJSONObject.put("groupId", fileEntry.getGroupId());
                imageJSONObject.put("title", fileEntry.getTitle());
                imageJSONObject.put("type", "document");
                imageJSONObject.put("url", this.getURL(fileEntry, themeDisplay));
                imageJSONObject.put("uuid", fileEntry.getUuid());
                JSONObject jSONObject = imageJSONObject;
                return jSONObject;
            }
        }
        catch (IOException ioe) {
            throw new SystemException(ioe);
        }
    }

    protected abstract String getParameterName();

    protected ServiceContext getServiceContext(UploadPortletRequest uploadPortletRequest) throws PortalException {
        return null;
    }

    protected String getUniqueFileName(ThemeDisplay themeDisplay, String fileName, long folderId) throws PortalException {
        FileEntry fileEntry = this.fetchFileEntry(themeDisplay.getUserId(), themeDisplay.getScopeGroupId(), folderId, fileName);
        if (fileEntry == null) {
            return fileName;
        }
        int suffix = 1;
        for (int i = 0; i < 50; ++i) {
            String curFileName = FileUtil.appendParentheticalSuffix(fileName, String.valueOf(suffix));
            fileEntry = this.fetchFileEntry(themeDisplay.getUserId(), themeDisplay.getScopeGroupId(), folderId, curFileName);
            if (fileEntry == null) {
                return curFileName;
            }
            ++suffix;
        }
        throw new PortalException("Unable to get a unique file name for " + fileName);
    }

    protected String getURL(FileEntry fileEntry, ThemeDisplay themeDisplay) {
        return PortletFileRepositoryUtil.getPortletFileEntryURL(themeDisplay, fileEntry, "");
    }

    protected void handleUploadException(PortletRequest portletRequest, PortletResponse portletResponse, PortalException pe, JSONObject jsonObject) throws PortalException {
        jsonObject.put("success", Boolean.FALSE);
        if (pe instanceof AntivirusScannerException || pe instanceof FileNameException || pe instanceof FileSizeException || pe instanceof UploadRequestSizeException) {
            String errorMessage = "";
            int errorType = 0;
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (pe instanceof AntivirusScannerException) {
                errorType = 494;
                AntivirusScannerException ase = (AntivirusScannerException)pe;
                errorMessage = themeDisplay.translate(ase.getMessageKey());
            } else if (pe instanceof FileNameException) {
                errorType = 492;
            } else if (pe instanceof FileSizeException) {
                errorType = 493;
            } else if (pe instanceof UploadRequestSizeException) {
                errorType = 495;
            }
            JSONObject errorJSONObject = JSONFactoryUtil.createJSONObject();
            errorJSONObject.put("errorType", errorType);
            errorJSONObject.put("message", errorMessage);
            jsonObject.put("error", errorJSONObject);
        } else {
            this.doHandleUploadException(portletRequest, portletResponse, pe, jsonObject);
        }
        try {
            JSONPortletResponseUtil.writeJSON(portletRequest, portletResponse, (Object)jsonObject);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe);
        }
    }

    protected abstract void validateFile(String var1, String var2, long var3) throws PortalException;
}

