/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class ServletContextPool {
    private static final Log _log = LogFactoryUtil.getLog(ServletContextPool.class);
    private static final Map<String, ServletContext> _servletContexts = new ConcurrentHashMap<String, ServletContext>();

    public static void clear() {
        _servletContexts.clear();
    }

    public static boolean containsKey(String servletContextName) {
        if (servletContextName == null) {
            return false;
        }
        boolean value = _servletContexts.containsKey(servletContextName);
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("Contains key ", servletContextName, " ", String.valueOf(value)));
        }
        return value;
    }

    public static ServletContext get(String servletContextName) {
        ServletContext servletContext = _servletContexts.get(servletContextName);
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("Get ", servletContextName, " ", String.valueOf(servletContext)));
        }
        return servletContext;
    }

    public static Set<String> keySet() {
        return _servletContexts.keySet();
    }

    public static void put(String servletContextName, ServletContext servletContext) {
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("Put ", servletContextName, " ", String.valueOf(servletContext)));
        }
        _servletContexts.put(servletContextName, servletContext);
    }

    public static ServletContext remove(String servletContextName) {
        String contextPath = PortalUtil.getPathContext();
        if (contextPath.equals(servletContextName)) {
            return null;
        }
        ServletContext servletContext = _servletContexts.remove(servletContextName);
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("Remove ", servletContextName, " ", String.valueOf(servletContext)));
        }
        return servletContext;
    }
}

