/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.auth.AuthToken;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import javax.servlet.http.HttpServletRequest;

public class AuthTokenUtil {
    private static volatile AuthToken _authToken = ServiceProxyFactory.newServiceTrackedInstance(AuthToken.class, AuthTokenUtil.class, "_authToken", false);

    public static void addCSRFToken(HttpServletRequest request, LiferayPortletURL liferayPortletURL) {
        AuthToken authToken = _authToken;
        if (authToken != null) {
            authToken.addCSRFToken(request, liferayPortletURL);
        }
    }

    public static void addPortletInvocationToken(HttpServletRequest request, LiferayPortletURL liferayPortletURL) {
        AuthToken authToken = _authToken;
        if (authToken != null) {
            authToken.addPortletInvocationToken(request, liferayPortletURL);
        }
    }

    @Deprecated
    public static void check(HttpServletRequest request) throws PortalException {
        AuthToken authToken = _authToken;
        if (authToken != null) {
            authToken.check(request);
        }
    }

    public static void checkCSRFToken(HttpServletRequest request, String origin) throws PrincipalException {
        AuthToken authToken = _authToken;
        if (authToken != null) {
            authToken.checkCSRFToken(request, origin);
        }
    }

    public static String getToken(HttpServletRequest request) {
        AuthToken authToken = _authToken;
        if (authToken == null) {
            return null;
        }
        return authToken.getToken(request);
    }

    public static String getToken(HttpServletRequest request, long plid, String portletId) {
        AuthToken authToken = _authToken;
        if (authToken == null) {
            return null;
        }
        return authToken.getToken(request, plid, portletId);
    }

    public static boolean isValidPortletInvocationToken(HttpServletRequest request, Layout layout, Portlet portlet) {
        AuthToken authToken = _authToken;
        if (authToken == null) {
            return false;
        }
        return authToken.isValidPortletInvocationToken(request, layout, portlet);
    }

    @Deprecated
    public static boolean isValidPortletInvocationToken(HttpServletRequest request, long plid, String portletId, String strutsAction, String tokenValue) {
        AuthToken authToken = _authToken;
        if (authToken == null) {
            return false;
        }
        return authToken.isValidPortletInvocationToken(request, plid, portletId, strutsAction, tokenValue);
    }
}

