/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.search.BaseOpenSearchImpl;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.ratings.kernel.model.RatingsStats;
import com.liferay.ratings.kernel.service.RatingsStatsLocalServiceUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public abstract class HitsOpenSearchImpl
extends BaseOpenSearchImpl {
    private static final Log _log = LogFactoryUtil.getLog(HitsOpenSearchImpl.class);

    public Indexer<?> getIndexer() {
        if (_log.isWarnEnabled()) {
            _log.warn(this.getClass() + " does not implement getIndexer()");
        }
        return null;
    }

    public abstract String getSearchPath();

    public Summary getSummary(Indexer<?> indexer, Document document, Locale locale, String snippet) throws SearchException {
        return indexer.getSummary(document, snippet, null, null);
    }

    public abstract String getTitle(String var1);

    @Override
    public String search(HttpServletRequest request, long groupId, long userId, String keywords, int startPage, int itemsPerPage, String format) throws SearchException {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            SearchContext searchContext = SearchContextFactory.getInstance(request);
            searchContext.setAttribute("paginationType", (Serializable)((Object)"more"));
            if (groupId == 0L) {
                searchContext.setGroupIds(null);
            } else {
                searchContext.setGroupIds(new long[]{groupId});
            }
            int end = startPage * itemsPerPage;
            searchContext.setEnd(end);
            Layout layout = themeDisplay.getLayout();
            Group layoutGroup = layout.getGroup();
            if (!layoutGroup.isStagingGroup() && !layoutGroup.isControlPanel()) {
                searchContext.setIncludeStagingGroups(false);
            }
            searchContext.setKeywords(keywords);
            searchContext.setScopeStrict(false);
            int start = startPage * itemsPerPage - itemsPerPage;
            searchContext.setStart(start);
            searchContext.setUserId(userId);
            Indexer<?> indexer = this.getIndexer();
            Hits results = indexer.search(searchContext);
            String[] queryTerms = results.getQueryTerms();
            int total = results.getLength();
            Object[] values = this.addSearchResults(queryTerms, keywords, startPage, itemsPerPage, total, start, this.getTitle(keywords), this.getSearchPath(), format, themeDisplay);
            com.liferay.portal.kernel.xml.Document doc = (com.liferay.portal.kernel.xml.Document)values[0];
            Element root = (Element)values[1];
            for (int i = 0; i < results.getDocs().length; ++i) {
                RatingsStats stats;
                String className;
                long resultScopeGroupId;
                Document result = results.doc(i);
                String snippet = result.get("snippet");
                long resultGroupId = GetterUtil.getLong(result.get("groupId"));
                if (resultGroupId == 0L) {
                    resultGroupId = themeDisplay.getScopeGroupId();
                }
                if ((resultScopeGroupId = GetterUtil.getLong(result.get("scopeGroupId"))) == 0L) {
                    resultScopeGroupId = themeDisplay.getScopeGroupId();
                }
                if (Validator.isNull(className = indexer.getClassName())) {
                    className = result.get("entryClassName");
                }
                PortletURL portletURL = this.getPortletURL(request, className, PortletProvider.Action.VIEW, resultScopeGroupId);
                Summary summary = this.getSummary(indexer, result, themeDisplay.getLocale(), snippet);
                String title = summary.getTitle();
                String url = this.getURL(themeDisplay, resultScopeGroupId, result, portletURL);
                Date modifiedDate = result.getDate("modified");
                String content = summary.getContent();
                String[] tags = new String[]{};
                Field assetTagNamesField = result.getFields().get("assetTagNames");
                if (assetTagNamesField != null) {
                    tags = assetTagNamesField.getValues();
                }
                double ratings = 0.0;
                String entryClassName = result.get("entryClassName");
                long entryClassPK = GetterUtil.getLong(result.get("entryClassPK"));
                if (Validator.isNotNull(entryClassName) && entryClassPK > 0L && (stats = RatingsStatsLocalServiceUtil.fetchStats(entryClassName, entryClassPK)) != null) {
                    ratings = stats.getTotalScore();
                }
                double score = results.score(i);
                this.addSearchResult(root, resultGroupId, resultScopeGroupId, entryClassName, entryClassPK, title, url, modifiedDate, content, tags, ratings, score, format);
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Return\n" + doc.asXML());
            }
            return doc.asXML();
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    protected String getURL(ThemeDisplay themeDisplay, long groupId, Document result, PortletURL portletURL) throws Exception {
        return portletURL.toString();
    }
}

