/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BaseSearchResultPermissionFilter;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.RelatedEntryIndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.FacetPostProcessor;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@ProviderType
public class DefaultSearchResultPermissionFilter
extends BaseSearchResultPermissionFilter {
    private static final Log _log = LogFactoryUtil.getLog(DefaultSearchResultPermissionFilter.class);
    private static volatile FacetPostProcessor _facetPostProcessor = ServiceProxyFactory.newServiceTrackedInstance(FacetPostProcessor.class, DefaultSearchResultPermissionFilter.class, "_facetPostProcessor", false, true);
    private final PermissionChecker _permissionChecker;
    private final SearchExecutor _searchExecutor;

    @Deprecated
    public DefaultSearchResultPermissionFilter(BaseIndexer<?> baseIndexer, PermissionChecker permissionChecker) {
        this(baseIndexer::doSearch, permissionChecker);
    }

    public DefaultSearchResultPermissionFilter(SearchExecutor searchExecutor, PermissionChecker permissionChecker) {
        this._searchExecutor = searchExecutor;
        this._permissionChecker = permissionChecker;
    }

    @Override
    protected void filterHits(Hits hits, SearchContext searchContext) {
        FacetPostProcessor facetPostProcessor;
        ArrayList<Document> docs = new ArrayList<Document>();
        ArrayList<Document> excludeDocs = new ArrayList<Document>();
        ArrayList<Float> scores = new ArrayList<Float>();
        boolean companyAdmin = this._permissionChecker.isCompanyAdmin(this._permissionChecker.getCompanyId());
        int status = GetterUtil.getInteger(searchContext.getAttribute("status"), 0);
        Document[] documents = hits.getDocs();
        for (int i = 0; i < documents.length; ++i) {
            if (this._isIncludeDocument(documents[i], this._permissionChecker.getCompanyId(), companyAdmin, status)) {
                docs.add(documents[i]);
                scores.add(Float.valueOf(hits.score(i)));
                continue;
            }
            excludeDocs.add(documents[i]);
        }
        if (!excludeDocs.isEmpty() && (facetPostProcessor = _facetPostProcessor) != null) {
            Map<String, Facet> facets = searchContext.getFacets();
            for (Facet facet : facets.values()) {
                facetPostProcessor.exclude(excludeDocs, facet);
            }
        }
        hits.setDocs(docs.toArray(new Document[docs.size()]));
        hits.setScores(ArrayUtil.toFloatArray(scores));
        hits.setSearchTime((float)(System.currentTimeMillis() - hits.getStart()) / 1000.0f);
        hits.setLength(hits.getLength() - excludeDocs.size());
    }

    @Override
    protected Hits getHits(SearchContext searchContext) throws SearchException {
        return this._searchExecutor.search(searchContext);
    }

    @Override
    protected boolean isGroupAdmin(SearchContext searchContext) {
        long groupId = GetterUtil.getLong(searchContext.getAttribute("groupId"));
        if (groupId == 0L) {
            return false;
        }
        return this._permissionChecker.isGroupAdmin(groupId);
    }

    private boolean _isIncludeDocument(Document document, long companyId, boolean companyAdmin, int status) {
        block9: {
            long entryCompanyId = GetterUtil.getLong(document.get("companyId"));
            if (entryCompanyId != companyId) {
                return false;
            }
            if (companyAdmin) {
                return true;
            }
            String entryClassName = document.get("entryClassName");
            Indexer indexer = IndexerRegistryUtil.getIndexer(entryClassName);
            if (indexer == null) {
                return true;
            }
            if (!indexer.isFilterSearch()) {
                return true;
            }
            long entryClassPK = GetterUtil.getLong(document.get("entryClassPK"));
            try {
                if (indexer.hasPermission(this._permissionChecker, entryClassName, entryClassPK, "VIEW")) {
                    List<RelatedEntryIndexer> relatedEntryIndexers = RelatedEntryIndexerRegistryUtil.getRelatedEntryIndexers(entryClassName);
                    if (ListUtil.isNotEmpty(relatedEntryIndexers)) {
                        for (RelatedEntryIndexer relatedEntryIndexer : relatedEntryIndexers) {
                            relatedEntryIndexer.isVisibleRelatedEntry(entryClassPK, status);
                        }
                    }
                    return true;
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block9;
                _log.debug(e, e);
            }
        }
        return false;
    }

    public static interface SearchExecutor {
        public Hits search(SearchContext var1) throws SearchException;
    }
}

