/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.process;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.OutputProcessor;
import com.liferay.portal.kernel.process.ProcessException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.function.BiConsumer;

public class LoggingOutputProcessor
implements OutputProcessor<Void, Void> {
    @Deprecated
    public static final OutputProcessor<Void, Void> INSTANCE = new LoggingOutputProcessor();
    private static final Log _log = LogFactoryUtil.getLog(LoggingOutputProcessor.class);
    private final Charset _charset;
    private final BiConsumer<Boolean, String> _logLineConsumer;

    @Deprecated
    public LoggingOutputProcessor() {
        this(Charset.defaultCharset(), (stdErr, line) -> {
            if (stdErr.booleanValue()) {
                _log.error(line);
            } else if (_log.isInfoEnabled()) {
                _log.info(line);
            }
        });
    }

    public LoggingOutputProcessor(BiConsumer<Boolean, String> logLineConsumer) {
        this(Charset.defaultCharset(), logLineConsumer);
    }

    public LoggingOutputProcessor(Charset charset, BiConsumer<Boolean, String> logLineConsumer) {
        this._charset = charset;
        this._logLineConsumer = logLineConsumer;
    }

    @Override
    public Void processStdErr(InputStream stdErrInputStream) throws ProcessException {
        this._processOut(true, stdErrInputStream);
        return null;
    }

    @Override
    public Void processStdOut(InputStream stdOutInputStream) throws ProcessException {
        this._processOut(false, stdOutInputStream);
        return null;
    }

    private void _processOut(boolean stdErr, InputStream inputStream) throws ProcessException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new InputStreamReader(inputStream, this._charset));
        String line = null;
        try {
            while ((line = unsyncBufferedReader.readLine()) != null) {
                this._logLineConsumer.accept(stdErr, line);
            }
        }
        catch (IOException ioe) {
            throw new ProcessException(ioe);
        }
        finally {
            try {
                unsyncBufferedReader.close();
            }
            catch (IOException ioe) {
                throw new ProcessException(ioe);
            }
        }
    }
}

