/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.orm;

import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.security.pacl.NotPrivileged;
import java.io.Serializable;
import java.sql.Connection;

@DoPrivileged
public class ClassLoaderSession
implements Session {
    private final ClassLoader _classLoader;
    private final Session _session;

    public ClassLoaderSession(Session session, ClassLoader classLoader) {
        this._session = session;
        this._classLoader = classLoader;
    }

    @Override
    @NotPrivileged
    public void clear() throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            this._session.clear();
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotPrivileged
    public Connection close() throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            Connection connection = this._session.close();
            return connection;
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotPrivileged
    public boolean contains(Object object) throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            boolean bl = this._session.contains(object);
            return bl;
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query createQuery(String queryString) throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            Query query = this._session.createQuery(queryString);
            return query;
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query createQuery(String queryString, boolean strictName) throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            Query query = this._session.createQuery(queryString, strictName);
            return query;
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLQuery createSQLQuery(String queryString) throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            SQLQuery sQLQuery = this._session.createSQLQuery(queryString);
            return sQLQuery;
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLQuery createSQLQuery(String queryString, boolean strictName) throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            SQLQuery sQLQuery = this._session.createSQLQuery(queryString, strictName);
            return sQLQuery;
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLQuery createSynchronizedSQLQuery(String queryString) throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            SQLQuery sQLQuery = this._session.createSynchronizedSQLQuery(queryString);
            return sQLQuery;
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLQuery createSynchronizedSQLQuery(String queryString, boolean strictName) throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            SQLQuery sQLQuery = this._session.createSynchronizedSQLQuery(queryString, strictName);
            return sQLQuery;
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotPrivileged
    public void delete(Object object) throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            this._session.delete(object);
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotPrivileged
    public void evict(Object object) throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            this._session.evict(object);
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    @Override
    @NotPrivileged
    public void flush() throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            this._session.flush();
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotPrivileged
    public Object get(Class<?> clazz, Serializable id) throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            Object object = this._session.get(clazz, id);
            return object;
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotPrivileged
    public Object get(Class<?> clazz, Serializable id, LockMode lockMode) throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            Object object = this._session.get(clazz, id, lockMode);
            return object;
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotPrivileged
    public Object getWrappedSession() throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            Object object = this._session.getWrappedSession();
            return object;
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotPrivileged
    public boolean isDirty() throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            boolean bl = this._session.isDirty();
            return bl;
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotPrivileged
    public Object load(Class<?> clazz, Serializable id) throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            Object object = this._session.load(clazz, id);
            return object;
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotPrivileged
    public Object merge(Object object) throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            Object object2 = this._session.merge(object);
            return object2;
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotPrivileged
    public Serializable save(Object object) throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            Serializable serializable = this._session.save(object);
            return serializable;
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotPrivileged
    public void saveOrUpdate(Object object) throws ORMException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(this._classLoader);
            }
            this._session.saveOrUpdate(object);
        }
        finally {
            if (contextClassLoader != this._classLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }
}

