/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.bean;

import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.HashMap;
import java.util.Map;

public class PortletBeanLocatorUtil {
    private static final Log _log = LogFactoryUtil.getLog(PortletBeanLocatorUtil.class);
    private static final Map<String, BeanLocator> _beanLocators = new HashMap<String, BeanLocator>();

    public static BeanLocator getBeanLocator(String servletContextName) {
        PortalRuntimePermission.checkGetBeanProperty(servletContextName, PortletBeanLocatorUtil.class);
        return _beanLocators.get(servletContextName);
    }

    public static Object locate(String servletContextName, String name) throws BeanLocatorException {
        BeanLocator beanLocator = PortletBeanLocatorUtil.getBeanLocator(servletContextName);
        if (beanLocator == null) {
            _log.error("BeanLocator is null for servlet context " + servletContextName);
            throw new BeanLocatorException("BeanLocator is not set for servlet context " + servletContextName);
        }
        return beanLocator.locate(name);
    }

    public static void setBeanLocator(String servletContextName, BeanLocator beanLocator) {
        PortalRuntimePermission.checkSetBeanProperty(servletContextName, PortletBeanLocatorUtil.class);
        if (_log.isDebugEnabled()) {
            if (beanLocator != null) {
                _log.debug(StringBundler.concat("Setting BeanLocator ", String.valueOf(beanLocator.hashCode()), " for servlet context ", servletContextName));
            } else {
                _log.debug("Removing BeanLocator for servlet context " + servletContextName);
            }
        }
        _beanLocators.put(servletContextName, beanLocator);
    }
}

