/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.kernel.lar;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.exportimport.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerStatusMessageSenderUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManagerUtil;
import com.liferay.portal.kernel.comment.CommentManagerUtil;
import com.liferay.portal.kernel.comment.DiscussionStagingHandler;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LocalizedModel;
import com.liferay.portal.kernel.model.ResourcedModel;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.WorkflowedModel;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TransientValue;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.service.RatingsEntryLocalServiceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BaseStagedModelDataHandler<T extends StagedModel>
implements StagedModelDataHandler<T> {
    private static final Log _log = LogFactoryUtil.getLog(BaseStagedModelDataHandler.class);

    @Override
    public abstract void deleteStagedModel(String var1, long var2, String var4, String var5) throws PortalException;

    @Override
    public abstract void deleteStagedModel(T var1) throws PortalException;

    @Override
    public void exportStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        this.validateExport(portletDataContext, stagedModel);
        String path = ExportImportPathUtil.getModelPath(stagedModel);
        if (portletDataContext.isPathExportedInScope(path)) {
            return;
        }
        try {
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent(24, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), PortletDataContextFactoryUtil.clonePortletDataContext(portletDataContext), new TransientValue<T>(stagedModel));
            ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage("stagedModel", stagedModel, manifestSummary);
            this.doExportStagedModel(portletDataContext, (StagedModel)stagedModel.clone());
            this.exportAssetCategories(portletDataContext, stagedModel);
            this.exportAssetTags(portletDataContext, stagedModel);
            this.exportComments(portletDataContext, stagedModel);
            this.exportRatings(portletDataContext, stagedModel);
            if (this.countStagedModel(portletDataContext, stagedModel)) {
                manifestSummary.incrementModelAdditionCount(stagedModel.getStagedModelType());
            }
            portletDataContext.cleanUpMissingReferences((ClassedModel)stagedModel);
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent(23, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), PortletDataContextFactoryUtil.clonePortletDataContext(portletDataContext), new TransientValue<T>(stagedModel));
        }
        catch (PortletDataException pde) {
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent(22, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), PortletDataContextFactoryUtil.clonePortletDataContext(portletDataContext), new TransientValue<T>(stagedModel), pde);
            throw pde;
        }
        catch (Throwable t) {
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent(22, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), PortletDataContextFactoryUtil.clonePortletDataContext(portletDataContext), new TransientValue<T>(stagedModel), t);
            PortletDataException pde = new PortletDataException(t);
            if (t instanceof NoSuchModelException) {
                pde.setStagedModelDisplayName(this.getDisplayName(stagedModel));
                pde.setStagedModelClassName(stagedModel.getModelClassName());
                pde.setStagedModelClassPK(GetterUtil.getString(stagedModel.getPrimaryKeyObj()));
                pde.setType(5);
            }
            throw pde;
        }
    }

    @Override
    public T fetchMissingReference(String uuid, long groupId) {
        block9: {
            T existingStagedModel = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
            if (existingStagedModel != null && !this.isStagedModelInTrash(existingStagedModel)) {
                return existingStagedModel;
            }
            try {
                Group group;
                Group originalGroup = GroupLocalServiceUtil.getGroup(groupId);
                for (group = originalGroup.getParentGroup(); group != null && (existingStagedModel = this.fetchStagedModelByUuidAndGroupId(uuid, group.getGroupId())) == null; group = group.getParentGroup()) {
                }
                if (existingStagedModel != null && !this.isStagedModelInTrash(existingStagedModel)) {
                    return existingStagedModel;
                }
                List<T> existingStagedModels = this.fetchStagedModelsByUuidAndCompanyId(uuid, originalGroup.getCompanyId());
                for (StagedModel stagedModel : existingStagedModels) {
                    try {
                        StagedGroupedModel stagedGroupedModel;
                        if (!(stagedModel instanceof StagedGroupedModel ? !(group = GroupLocalServiceUtil.getGroup((stagedGroupedModel = (StagedGroupedModel)stagedModel).getGroupId())).isStagingGroup() && !this.isStagedModelInTrash(stagedModel) : !this.isStagedModelInTrash(stagedModel))) continue;
                        return (T)stagedModel;
                    }
                    catch (PortalException pe) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug(pe, pe);
                    }
                }
            }
            catch (Exception e) {
                if (_log.isDebugEnabled()) {
                    _log.debug(e, e);
                }
                if (!_log.isWarnEnabled()) break block9;
                _log.warn("Unable to fetch missing reference staged model from group " + groupId);
            }
        }
        return null;
    }

    @Override
    public T fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return null;
    }

    @Override
    public abstract List<T> fetchStagedModelsByUuidAndCompanyId(String var1, long var2);

    @Override
    public abstract String[] getClassNames();

    @Override
    public String getDisplayName(T stagedModel) {
        return stagedModel.getUuid();
    }

    @Override
    public int[] getExportableStatuses() {
        return new int[]{0};
    }

    @Override
    public Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, T stagedModel) {
        return new HashMap<String, String>();
    }

    @Override
    @Deprecated
    public void importCompanyStagedModel(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        this.importMissingReference(portletDataContext, referenceElement);
    }

    @Override
    @Deprecated
    public void importCompanyStagedModel(PortletDataContext portletDataContext, String uuid, long classPK) throws PortletDataException {
        this.importMissingReference(portletDataContext, uuid, portletDataContext.getCompanyGroupId(), classPK);
    }

    @Override
    public void importMissingReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        block2: {
            try {
                this.doImportMissingReference(portletDataContext, referenceElement);
            }
            catch (Exception e) {
                if (StringUtil.equalsIgnoreCase(referenceElement.attributeValue("type"), "disposable_dependency")) break block2;
                throw e;
            }
        }
    }

    @Override
    public void importMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long classPK) throws PortletDataException {
        try {
            this.doImportMissingReference(portletDataContext, uuid, groupId, classPK);
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
    }

    @Override
    public void importStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        String path = ExportImportPathUtil.getModelPath(stagedModel);
        if (portletDataContext.isPathProcessed(path)) {
            return;
        }
        try {
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent(27, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), PortletDataContextFactoryUtil.clonePortletDataContext(portletDataContext), new TransientValue<T>(stagedModel));
            ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage("stagedModel", stagedModel, manifestSummary);
            if (stagedModel instanceof LocalizedModel) {
                LocalizedModel localizedModel = (LocalizedModel)stagedModel;
                localizedModel.prepareLocalizedFieldsForImport();
            }
            this.restoreStagedModel(portletDataContext, stagedModel);
            this.importAssetCategories(portletDataContext, stagedModel);
            this.importAssetTags(portletDataContext, stagedModel);
            this.importReferenceStagedModels(portletDataContext, stagedModel);
            this.doImportStagedModel(portletDataContext, stagedModel);
            this.importComments(portletDataContext, stagedModel);
            this.importRatings(portletDataContext, stagedModel);
            manifestSummary.incrementModelAdditionCount(stagedModel.getStagedModelType());
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent(26, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), PortletDataContextFactoryUtil.clonePortletDataContext(portletDataContext), new TransientValue<T>(stagedModel));
        }
        catch (NoSuchModelException nsme) {
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent(25, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), PortletDataContextFactoryUtil.clonePortletDataContext(portletDataContext), new TransientValue<T>(stagedModel), nsme);
            PortletDataException pde = new PortletDataException(nsme);
            pde.setStagedModelDisplayName(this.getDisplayName(stagedModel));
            pde.setStagedModelClassName(stagedModel.getModelClassName());
            pde.setStagedModelClassPK(GetterUtil.getString(stagedModel.getPrimaryKeyObj()));
            pde.setType(5);
            throw pde;
        }
        catch (PortletDataException pde) {
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent(25, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), PortletDataContextFactoryUtil.clonePortletDataContext(portletDataContext), new TransientValue<T>(stagedModel), pde);
            throw pde;
        }
        catch (Throwable t) {
            ExportImportLifecycleManagerUtil.fireExportImportLifecycleEvent(25, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), PortletDataContextFactoryUtil.clonePortletDataContext(portletDataContext), new TransientValue<T>(stagedModel), t);
            throw new PortletDataException(t);
        }
    }

    @Override
    public void restoreStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        try {
            if (stagedModel instanceof TrashedModel) {
                this.doRestoreStagedModel(portletDataContext, stagedModel);
            }
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            PortletDataException pde = new PortletDataException(e);
            pde.setStagedModelDisplayName(this.getDisplayName(stagedModel));
            pde.setStagedModelClassName(stagedModel.getModelClassName());
            pde.setStagedModelClassPK(GetterUtil.getString(stagedModel.getPrimaryKeyObj()));
            throw pde;
        }
    }

    @Override
    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        this.validateMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map<Long, Long> groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong(referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong(groupIds, groupId);
        try {
            return this.validateMissingReference(uuid, groupId);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean countStagedModel(PortletDataContext portletDataContext, T stagedModel) {
        return !portletDataContext.isStagedModelCounted((StagedModel)stagedModel);
    }

    protected abstract void doExportStagedModel(PortletDataContext var1, T var2) throws Exception;

    protected void doImportMissingReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        this.importMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map<Long, Long> groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong(referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong(groupIds, groupId);
        long classPK = GetterUtil.getLong(referenceElement.attributeValue("class-pk"));
        this.importMissingReference(portletDataContext, uuid, groupId, classPK);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long classPK) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected abstract void doImportStagedModel(PortletDataContext var1, T var2) throws Exception;

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, T stagedModel) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void exportAssetCategories(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        List<AssetCategory> assetCategories = AssetCategoryLocalServiceUtil.getCategories(ExportImportClassedModelUtil.getClassName(stagedModel), ExportImportClassedModelUtil.getClassPK(stagedModel));
        for (AssetCategory assetCategory : assetCategories) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel(portletDataContext, stagedModel, assetCategory, "weak");
        }
    }

    protected void exportAssetTags(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        List<AssetTag> assetTags = AssetTagLocalServiceUtil.getTags(ExportImportClassedModelUtil.getClassName(stagedModel), ExportImportClassedModelUtil.getClassPK(stagedModel));
        for (AssetTag assetTag : assetTags) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel(portletDataContext, stagedModel, assetTag, "weak");
        }
    }

    protected void exportComments(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        if (!MapUtil.getBoolean(portletDataContext.getParameterMap(), "PORTLET_DATA_ALL") && !MapUtil.getBoolean(portletDataContext.getParameterMap(), "COMMENTS")) {
            return;
        }
        DiscussionStagingHandler discussionStagingHandler = CommentManagerUtil.getDiscussionStagingHandler();
        if (discussionStagingHandler != null) {
            discussionStagingHandler.exportReferenceDiscussions(portletDataContext, stagedModel);
        }
    }

    protected void exportRatings(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        if (!MapUtil.getBoolean(portletDataContext.getParameterMap(), "PORTLET_DATA_ALL") && !MapUtil.getBoolean(portletDataContext.getParameterMap(), "RATINGS")) {
            return;
        }
        List<RatingsEntry> ratingsEntries = RatingsEntryLocalServiceUtil.getEntries(ExportImportClassedModelUtil.getClassName(stagedModel), ExportImportClassedModelUtil.getClassPK(stagedModel));
        if (ratingsEntries.isEmpty()) {
            return;
        }
        for (RatingsEntry ratingsEntry : ratingsEntries) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel(portletDataContext, stagedModel, ratingsEntry, "weak");
        }
    }

    protected int getProcessFlag() {
        if (ExportImportThreadLocal.isLayoutStagingInProcess()) {
            return 32;
        }
        if (ExportImportThreadLocal.isPortletStagingInProcess()) {
            return 36;
        }
        if (ExportImportThreadLocal.isLayoutExportInProcess()) {
            return 30;
        }
        if (ExportImportThreadLocal.isLayoutImportInProcess()) {
            return 31;
        }
        if (ExportImportThreadLocal.isPortletExportInProcess()) {
            return 34;
        }
        if (ExportImportThreadLocal.isPortletImportInProcess()) {
            return 35;
        }
        return 0;
    }

    protected void importAssetCategories(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        List<Element> referenceElements = portletDataContext.getReferenceElements((StagedModel)stagedModel, AssetCategory.class);
        if (referenceElements.isEmpty()) {
            return;
        }
        ArrayList<Long> assetCategoryIds = new ArrayList<Long>(referenceElements.size());
        for (Element referenceElement : referenceElements) {
            Long classPK = GetterUtil.getLong(referenceElement.attributeValue("class-pk"));
            StagedModelDataHandlerUtil.importReferenceStagedModel(portletDataContext, stagedModel, AssetCategory.class, (Serializable)classPK);
            assetCategoryIds.add(classPK);
        }
        Map<Long, Long> assetCategoryIdsMap = portletDataContext.getNewPrimaryKeysMap(AssetCategory.class);
        long[] importedAssetCategoryIds = new long[assetCategoryIds.size()];
        for (int i = 0; i < assetCategoryIds.size(); ++i) {
            long categoryId = (Long)assetCategoryIds.get(i);
            importedAssetCategoryIds[i] = MapUtil.getLong(assetCategoryIdsMap, categoryId, categoryId);
        }
        portletDataContext.addAssetCategories(ExportImportClassedModelUtil.getClassName(stagedModel), ExportImportClassedModelUtil.getClassPK(stagedModel), importedAssetCategoryIds);
    }

    protected void importAssetTags(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        List<Element> referenceElements = portletDataContext.getReferenceElements((StagedModel)stagedModel, AssetTag.class);
        ArrayList<Long> assetTagIds = new ArrayList<Long>(referenceElements.size());
        for (Element referenceElement : referenceElements) {
            Long classPK = GetterUtil.getLong(referenceElement.attributeValue("class-pk"));
            StagedModelDataHandlerUtil.importReferenceStagedModel(portletDataContext, stagedModel, AssetTag.class, (Serializable)classPK);
            assetTagIds.add(classPK);
        }
        Map<Long, Long> assetTagIdsMap = portletDataContext.getNewPrimaryKeysMap(AssetTag.class);
        HashSet<String> assetTagNames = new HashSet<String>();
        Iterator iterator = assetTagIds.iterator();
        while (iterator.hasNext()) {
            long assetTagId = (Long)iterator.next();
            long importedStagedAssetTagId = MapUtil.getLong(assetTagIdsMap, assetTagId, assetTagId);
            AssetTag assetTag = AssetTagLocalServiceUtil.fetchAssetTag(importedStagedAssetTagId);
            if (assetTag == null) continue;
            assetTagNames.add(assetTag.getName());
        }
        if (assetTagNames.isEmpty()) {
            return;
        }
        portletDataContext.addAssetTags(ExportImportClassedModelUtil.getClassName(stagedModel), ExportImportClassedModelUtil.getClassPK(stagedModel), assetTagNames.toArray(new String[assetTagNames.size()]));
    }

    protected void importComments(PortletDataContext portletDataContext, T stagedModel) throws PortalException {
        ResourcedModel resourcedModel;
        if (stagedModel instanceof ResourcedModel && !(resourcedModel = (ResourcedModel)stagedModel).isResourceMain()) {
            return;
        }
        if (!MapUtil.getBoolean(portletDataContext.getParameterMap(), "PORTLET_DATA_ALL") && !MapUtil.getBoolean(portletDataContext.getParameterMap(), "COMMENTS")) {
            return;
        }
        DiscussionStagingHandler discussionStagingDataHandler = CommentManagerUtil.getDiscussionStagingHandler();
        if (discussionStagingDataHandler != null) {
            discussionStagingDataHandler.importReferenceDiscussions(portletDataContext, stagedModel);
        }
    }

    protected void importMissingGroupReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler("com.liferay.site.model.adapter.StagedGroup");
        stagedModelDataHandler.importMissingReference(portletDataContext, referenceElement);
    }

    protected void importRatings(PortletDataContext portletDataContext, T stagedModel) throws PortalException {
        ResourcedModel resourcedModel;
        if (stagedModel instanceof ResourcedModel && !(resourcedModel = (ResourcedModel)stagedModel).isResourceMain()) {
            return;
        }
        if (!MapUtil.getBoolean(portletDataContext.getParameterMap(), "PORTLET_DATA_ALL") && !MapUtil.getBoolean(portletDataContext.getParameterMap(), "RATINGS")) {
            return;
        }
        StagedModelDataHandlerUtil.importReferenceStagedModels(portletDataContext, stagedModel, RatingsEntry.class);
    }

    protected void importReferenceStagedModels(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        Element stagedModelElement = portletDataContext.getImportDataStagedModelElement((StagedModel)stagedModel);
        Element referencesElement = stagedModelElement.element("references");
        if (referencesElement == null) {
            return;
        }
        DiscussionStagingHandler discussionStagingHandler = CommentManagerUtil.getDiscussionStagingHandler();
        String stagedModelClassName = null;
        if (discussionStagingHandler != null) {
            stagedModelClassName = discussionStagingHandler.getClassName();
        }
        List<Element> referenceElements = referencesElement.elements();
        for (Element referenceElement : referenceElements) {
            String className = referenceElement.attributeValue("class-name");
            if (className.equals(AssetCategory.class.getName()) || className.equals(RatingsEntry.class.getName()) || className.equals(stagedModelClassName)) continue;
            Long classPK = GetterUtil.getLong(referenceElement.attributeValue("class-pk"));
            StagedModelDataHandlerUtil.importReferenceStagedModel(portletDataContext, stagedModel, className, (Serializable)classPK);
        }
    }

    protected boolean isStagedModelInTrash(T stagedModel) {
        if (!(stagedModel instanceof TrashedModel)) {
            return false;
        }
        TrashedModel trashedModel = (TrashedModel)stagedModel;
        return trashedModel.isInTrash();
    }

    protected void validateExport(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        TrashedModel trashedModel;
        if (!portletDataContext.isInitialPublication() && stagedModel instanceof WorkflowedModel) {
            WorkflowedModel workflowedModel = (WorkflowedModel)stagedModel;
            if (!ArrayUtil.contains(this.getExportableStatuses(), workflowedModel.getStatus())) {
                PortletDataException pde = new PortletDataException(9);
                pde.setStagedModelDisplayName(this.getDisplayName(stagedModel));
                pde.setStagedModelClassName(stagedModel.getModelClassName());
                pde.setStagedModelClassPK(GetterUtil.getString(stagedModel.getPrimaryKeyObj()));
                throw pde;
            }
        }
        if (stagedModel instanceof TrashedModel && (trashedModel = (TrashedModel)stagedModel).isInTrash()) {
            PortletDataException pde = new PortletDataException(8);
            pde.setStagedModelDisplayName(this.getDisplayName(stagedModel));
            pde.setStagedModelClassName(stagedModel.getModelClassName());
            pde.setStagedModelClassPK(GetterUtil.getString(stagedModel.getPrimaryKeyObj()));
            throw pde;
        }
    }

    protected boolean validateMissingGroupReference(PortletDataContext portletDataContext, Element referenceElement) {
        StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler("com.liferay.site.model.adapter.StagedGroup");
        return stagedModelDataHandler.validateReference(portletDataContext, referenceElement);
    }

    protected boolean validateMissingReference(String uuid, long groupId) {
        T existingStagedModel = this.fetchMissingReference(uuid, groupId);
        return existingStagedModel != null;
    }
}

