/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.kernel.lar;

import com.liferay.exportimport.kernel.lar.DataLevel;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.plugin.Version;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import javax.portlet.PortletPreferences;

public abstract class BasePortletDataHandler
implements PortletDataHandler {
    private static final Log _log = LogFactoryUtil.getLog(BasePortletDataHandler.class);
    private boolean _dataAlwaysStaged;
    private DataLevel _dataLevel = DataLevel.SITE;
    private boolean _dataLocalized;
    private String[] _dataPortletPreferences = StringPool.EMPTY_ARRAY;
    private StagedModelType[] _deletionSystemEventStagedModelTypes = new StagedModelType[0];
    private PortletDataHandlerControl[] _exportControls = new PortletDataHandlerControl[0];
    private PortletDataHandlerControl[] _exportMetadataControls = new PortletDataHandlerControl[0];
    private PortletDataHandlerControl[] _importControls = new PortletDataHandlerControl[0];
    private PortletDataHandlerControl[] _importMetadataControls = new PortletDataHandlerControl[0];
    private String _portletId;
    private boolean _publishToLiveByDefault;
    private int _rank = 100;
    private PortletDataHandlerControl[] _stagingControls = new PortletDataHandlerControl[0];

    @Override
    public PortletPreferences addDefaultData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws PortletDataException {
        long startTime = 0L;
        if (_log.isInfoEnabled()) {
            _log.info("Adding default data to portlet " + portletId);
            startTime = System.currentTimeMillis();
        }
        try {
            PortletPreferences portletPreferences2 = this.doAddDefaultData(portletDataContext, portletId, portletPreferences);
            return portletPreferences2;
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
        finally {
            if (_log.isInfoEnabled()) {
                long duration = System.currentTimeMillis() - startTime;
                _log.info("Added default data to portlet in " + Time.getDuration(duration));
            }
        }
    }

    @Override
    public PortletPreferences deleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws PortletDataException {
        long startTime = 0L;
        if (_log.isInfoEnabled()) {
            _log.info("Deleting portlet " + portletId);
            startTime = System.currentTimeMillis();
        }
        try {
            PortletPreferences portletPreferences2 = this.doDeleteData(portletDataContext, portletId, portletPreferences);
            return portletPreferences2;
        }
        catch (Exception e) {
            throw this._handleException(e, 10, portletId);
        }
        finally {
            if (_log.isInfoEnabled()) {
                long duration = System.currentTimeMillis() - startTime;
                _log.info("Deleted portlet in " + Time.getDuration(duration));
            }
        }
    }

    @Override
    public String exportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws PortletDataException {
        long startTime = 0L;
        if (_log.isInfoEnabled()) {
            _log.info("Exporting portlet " + portletId);
            startTime = System.currentTimeMillis();
        }
        Element rootElement = null;
        try {
            rootElement = portletDataContext.getExportDataRootElement();
            portletDataContext.addDeletionSystemEventStagedModelTypes(this.getDeletionSystemEventStagedModelTypes());
            for (PortletDataHandlerControl portletDataHandlerControl : this.getExportControls()) {
                this.addUncheckedModelAdditionCount(portletDataContext, portletDataHandlerControl);
            }
            String string = this.doExportData(portletDataContext, portletId, portletPreferences);
            return string;
        }
        catch (Exception exception) {
            throw this._handleException(exception, 11, portletId);
        }
        finally {
            portletDataContext.setExportDataRootElement(rootElement);
            if (_log.isInfoEnabled()) {
                long duration = System.currentTimeMillis() - startTime;
                _log.info("Exported portlet in " + Time.getDuration(duration));
            }
        }
    }

    @Override
    public DataLevel getDataLevel() {
        return this._dataLevel;
    }

    @Override
    public String[] getDataPortletPreferences() {
        return this._dataPortletPreferences;
    }

    @Override
    public StagedModelType[] getDeletionSystemEventStagedModelTypes() {
        return this._deletionSystemEventStagedModelTypes;
    }

    @Override
    public PortletDataHandlerControl[] getExportConfigurationControls(long companyId, long groupId, Portlet portlet, boolean privateLayout) throws Exception {
        return this.getExportConfigurationControls(companyId, groupId, portlet, -1L, privateLayout);
    }

    @Override
    public PortletDataHandlerControl[] getExportConfigurationControls(long companyId, long groupId, Portlet portlet, long plid, boolean privateLayout) throws Exception {
        ArrayList<PortletDataHandlerBoolean> configurationControls = new ArrayList<PortletDataHandlerBoolean>();
        if (PortletPreferencesLocalServiceUtil.getPortletPreferencesCount(0L, 3, plid, portlet, false) > 0L || PortletPreferencesLocalServiceUtil.getPortletPreferencesCount(groupId, 2, portlet.getRootPortletId(), false) > 0L || PortletPreferencesLocalServiceUtil.getPortletPreferencesCount(companyId, 1, portlet.getRootPortletId(), false) > 0L) {
            PortletDataHandlerControl[] portletDataHandlerControls = null;
            if (this.isDisplayPortlet()) {
                portletDataHandlerControls = this.getExportControls();
            }
            configurationControls.add(new PortletDataHandlerBoolean(null, "PORTLET_SETUP", "setup", true, false, portletDataHandlerControls, null, null));
        }
        if (PortletPreferencesLocalServiceUtil.getPortletPreferencesCount(-1L, 5, portlet.getRootPortletId(), false) > 0L) {
            configurationControls.add(new PortletDataHandlerBoolean(null, "PORTLET_ARCHIVED_SETUPS", "configuration-templates", true, false, null, null, null));
        }
        if (PortletPreferencesLocalServiceUtil.getPortletPreferencesCount(-1L, 4, plid, portlet, false) > 0L || PortletPreferencesLocalServiceUtil.getPortletPreferencesCount(groupId, 4, 0L, portlet, false) > 0L) {
            configurationControls.add(new PortletDataHandlerBoolean(null, "PORTLET_USER_PREFERENCES", "user-preferences", true, false, null, null, null));
        }
        return configurationControls.toArray(new PortletDataHandlerBoolean[configurationControls.size()]);
    }

    @Override
    public PortletDataHandlerControl[] getExportControls() {
        return this._exportControls;
    }

    @Override
    public PortletDataHandlerControl[] getExportMetadataControls() {
        return this._exportMetadataControls;
    }

    @Override
    public long getExportModelCount(ManifestSummary manifestSummary) {
        return this.getExportModelCount(manifestSummary, this.getExportControls());
    }

    @Override
    public PortletDataHandlerControl[] getImportConfigurationControls(Portlet portlet, ManifestSummary manifestSummary) {
        String[] configurationPortletOptions = manifestSummary.getConfigurationPortletOptions(portlet.getRootPortletId());
        return this.getImportConfigurationControls(configurationPortletOptions);
    }

    @Override
    public PortletDataHandlerControl[] getImportConfigurationControls(String[] configurationPortletOptions) {
        ArrayList<PortletDataHandlerBoolean> configurationControls = new ArrayList<PortletDataHandlerBoolean>();
        if (ArrayUtil.contains(configurationPortletOptions, "setup")) {
            PortletDataHandlerControl[] portletDataHandlerControls = null;
            if (this.isDisplayPortlet()) {
                portletDataHandlerControls = this.getExportControls();
            }
            configurationControls.add(new PortletDataHandlerBoolean(null, "PORTLET_SETUP", "setup", true, false, portletDataHandlerControls, null, null));
        }
        if (ArrayUtil.contains(configurationPortletOptions, "archived-setups")) {
            configurationControls.add(new PortletDataHandlerBoolean(null, "PORTLET_ARCHIVED_SETUPS", "configuration-templates", true, false, null, null, null));
        }
        if (ArrayUtil.contains(configurationPortletOptions, "user-preferences")) {
            configurationControls.add(new PortletDataHandlerBoolean(null, "PORTLET_USER_PREFERENCES", "user-preferences", true, false, null, null, null));
        }
        return configurationControls.toArray(new PortletDataHandlerBoolean[configurationControls.size()]);
    }

    @Override
    public PortletDataHandlerControl[] getImportControls() {
        return this._importControls;
    }

    @Override
    public PortletDataHandlerControl[] getImportMetadataControls() {
        return this._importMetadataControls;
    }

    @Override
    public String getPortletId() {
        return this._portletId;
    }

    @Override
    public int getRank() {
        return this._rank;
    }

    @Override
    public String getSchemaVersion() {
        return "1.0.0";
    }

    @Override
    public String getServiceName() {
        return null;
    }

    @Override
    public PortletDataHandlerControl[] getStagingControls() {
        if (ArrayUtil.isNotEmpty(this._stagingControls)) {
            return this._stagingControls;
        }
        return this._exportControls;
    }

    @Override
    public PortletPreferences importData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws PortletDataException {
        PortletPreferences portletPreferences2;
        block7: {
            long startTime = 0L;
            if (_log.isInfoEnabled()) {
                _log.info("Importing portlet " + portletId);
                startTime = System.currentTimeMillis();
            }
            long sourceGroupId = portletDataContext.getSourceGroupId();
            Element rootElement = null;
            try {
                if (Validator.isXml(data)) {
                    rootElement = portletDataContext.getImportDataRootElement();
                    this.addImportDataRootElement(portletDataContext, data);
                }
                portletPreferences2 = this.doImportData(portletDataContext, portletId, portletPreferences, data);
                portletDataContext.setImportDataRootElement(rootElement);
                portletDataContext.setSourceGroupId(sourceGroupId);
                if (!_log.isInfoEnabled()) break block7;
            }
            catch (Exception e) {
                try {
                    throw this._handleException(e, 12, portletId);
                }
                catch (Throwable throwable) {
                    portletDataContext.setImportDataRootElement(rootElement);
                    portletDataContext.setSourceGroupId(sourceGroupId);
                    if (_log.isInfoEnabled()) {
                        long duration = System.currentTimeMillis() - startTime;
                        _log.info("Imported portlet in " + Time.getDuration(duration));
                    }
                    throw throwable;
                }
            }
            long duration = System.currentTimeMillis() - startTime;
            _log.info("Imported portlet in " + Time.getDuration(duration));
        }
        return portletPreferences2;
    }

    @Override
    public boolean isDataAlwaysStaged() {
        return this._dataAlwaysStaged;
    }

    @Override
    public boolean isDataLocalized() {
        return this._dataLocalized;
    }

    @Override
    public boolean isDataPortalLevel() {
        return this._dataLevel.equals((Object)DataLevel.PORTAL);
    }

    @Override
    public boolean isDataPortletInstanceLevel() {
        return this._dataLevel.equals((Object)DataLevel.PORTLET_INSTANCE);
    }

    @Override
    public boolean isDataSiteLevel() {
        return this._dataLevel.equals((Object)DataLevel.SITE);
    }

    @Override
    public boolean isDisplayPortlet() {
        return this.isDataPortletInstanceLevel() && !ArrayUtil.isEmpty(this.getDataPortletPreferences());
    }

    @Override
    public boolean isPublishToLiveByDefault() {
        return this._publishToLiveByDefault;
    }

    @Override
    public boolean isRollbackOnException() {
        return true;
    }

    @Override
    public void prepareManifestSummary(PortletDataContext portletDataContext) throws PortletDataException {
        this.prepareManifestSummary(portletDataContext, null);
    }

    @Override
    public void prepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            this.doPrepareManifestSummary(portletDataContext, portletPreferences);
        }
        catch (Exception e) {
            throw this._handleException(e, 13, portletDataContext.getPortletId());
        }
    }

    @Override
    @Deprecated
    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            return this.doProcessExportPortletPreferences(portletDataContext, portletId, portletPreferences);
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
    }

    @Override
    @Deprecated
    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            return this.doProcessImportPortletPreferences(portletDataContext, portletId, portletPreferences);
        }
        catch (PortletDataException pde) {
            throw pde;
        }
        catch (Exception e) {
            throw new PortletDataException(e);
        }
    }

    @Override
    public void setPortletId(String portletId) {
        this._portletId = portletId;
    }

    @Override
    public void setRank(int rank) {
        this._rank = rank;
    }

    @Override
    public boolean validateSchemaVersion(String schemaVersion) {
        try {
            return this.doValidateSchemaVersion(schemaVersion);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Element addExportDataRootElement(PortletDataContext portletDataContext) {
        Document document = SAXReaderUtil.createDocument();
        Class<?> clazz = this.getClass();
        Element rootElement = document.addElement(clazz.getSimpleName());
        portletDataContext.setExportDataRootElement(rootElement);
        return rootElement;
    }

    protected Element addImportDataRootElement(PortletDataContext portletDataContext, String data) throws DocumentException {
        Document document = SAXReaderUtil.read(data);
        Element rootElement = document.getRootElement();
        portletDataContext.setImportDataRootElement(rootElement);
        long groupId = GetterUtil.getLong(rootElement.attributeValue("group-id"));
        if (groupId != 0L) {
            portletDataContext.setSourceGroupId(groupId);
        }
        return rootElement;
    }

    protected void addUncheckedModelAdditionCount(PortletDataContext portletDataContext, PortletDataHandlerControl portletDataHandlerControl) {
        if (!(portletDataHandlerControl instanceof PortletDataHandlerBoolean)) {
            return;
        }
        PortletDataHandlerBoolean portletDataHandlerBoolean = (PortletDataHandlerBoolean)portletDataHandlerControl;
        PortletDataHandlerControl[] childPortletDataHandlerControls = portletDataHandlerBoolean.getChildren();
        if (childPortletDataHandlerControls != null) {
            for (PortletDataHandlerControl childPortletDataHandlerControl : childPortletDataHandlerControls) {
                this.addUncheckedModelAdditionCount(portletDataContext, childPortletDataHandlerControl);
            }
        }
        if (Validator.isNull(portletDataHandlerControl.getClassName())) {
            return;
        }
        boolean checkedControl = GetterUtil.getBoolean(portletDataContext.getBooleanParameter(portletDataHandlerControl.getNamespace(), portletDataHandlerControl.getControlName(), false));
        if (!checkedControl) {
            ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
            StagedModelType stagedModelType = new StagedModelType(portletDataHandlerControl.getClassName(), portletDataHandlerBoolean.getReferrerClassName());
            String manifestSummaryKey = ManifestSummary.getManifestSummaryKey(stagedModelType);
            manifestSummary.addModelAdditionCount(manifestSummaryKey, 0L);
        }
    }

    protected PortletPreferences doAddDefaultData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        return portletPreferences;
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        return null;
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
    }

    protected PortletPreferences doProcessExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        return portletPreferences;
    }

    protected PortletPreferences doProcessImportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        return portletPreferences;
    }

    protected boolean doValidateSchemaVersion(String schemaVersion) throws Exception {
        Version currentVersion = Version.getInstance(this.getSchemaVersion());
        Version importedVersion = Version.getInstance(schemaVersion);
        if (!Objects.equals(currentVersion.getMajor(), importedVersion.getMajor())) {
            return false;
        }
        int currentMinorVersion = GetterUtil.getInteger(currentVersion.getMinor(), -1);
        int importedMinorVersion = GetterUtil.getInteger(importedVersion.getMinor(), -1);
        return (currentMinorVersion != -1 || importedMinorVersion != -1) && currentMinorVersion >= importedMinorVersion;
    }

    protected String getExportDataRootElementString(Element rootElement) {
        if (rootElement == null) {
            return "";
        }
        try {
            Document document = rootElement.getDocument();
            return document.formattedString();
        }
        catch (IOException ioe) {
            return "";
        }
    }

    protected long getExportModelCount(ManifestSummary manifestSummary, PortletDataHandlerControl[] portletDataHandlerControls) {
        long totalModelCount = -1L;
        for (PortletDataHandlerControl portletDataHandlerControl : portletDataHandlerControls) {
            long childModelCount;
            PortletDataHandlerBoolean portletDataHandlerBoolean;
            PortletDataHandlerControl[] childPortletDataHandlerControls;
            StagedModelType stagedModelType = new StagedModelType(portletDataHandlerControl.getClassName(), portletDataHandlerControl.getReferrerClassName());
            long modelAdditionCount = manifestSummary.getModelAdditionCount(stagedModelType);
            if (portletDataHandlerControl instanceof PortletDataHandlerBoolean && (childPortletDataHandlerControls = (portletDataHandlerBoolean = (PortletDataHandlerBoolean)portletDataHandlerControl).getChildren()) != null && (childModelCount = this.getExportModelCount(manifestSummary, childPortletDataHandlerControls)) != -1L) {
                modelAdditionCount = modelAdditionCount == -1L ? childModelCount : (modelAdditionCount += childModelCount);
            }
            if (modelAdditionCount == -1L) continue;
            if (totalModelCount == -1L) {
                totalModelCount = modelAdditionCount;
                continue;
            }
            totalModelCount += modelAdditionCount;
        }
        return totalModelCount;
    }

    protected void setDataAlwaysStaged(boolean dataAlwaysStaged) {
        this._dataAlwaysStaged = dataAlwaysStaged;
    }

    protected void setDataLevel(DataLevel dataLevel) {
        this._dataLevel = dataLevel;
    }

    protected void setDataLocalized(boolean dataLocalized) {
        this._dataLocalized = dataLocalized;
    }

    protected void setDataPortletPreferences(String ... dataPortletPreferences) {
        this._dataPortletPreferences = dataPortletPreferences;
    }

    protected void setDeletionSystemEventStagedModelTypes(StagedModelType ... deletionSystemEventStagedModelTypes) {
        this._deletionSystemEventStagedModelTypes = deletionSystemEventStagedModelTypes;
    }

    protected void setExportControls(PortletDataHandlerControl ... exportControls) {
        this._exportControls = exportControls;
        this.setImportControls(exportControls);
    }

    protected void setExportMetadataControls(PortletDataHandlerControl ... exportMetadataControls) {
        this._exportMetadataControls = exportMetadataControls;
        this.setImportMetadataControls(exportMetadataControls);
    }

    protected void setImportControls(PortletDataHandlerControl ... importControls) {
        this._importControls = importControls;
    }

    protected void setImportMetadataControls(PortletDataHandlerControl ... importMetadataControls) {
        this._importMetadataControls = importMetadataControls;
    }

    protected void setPublishToLiveByDefault(boolean publishToLiveByDefault) {
        this._publishToLiveByDefault = publishToLiveByDefault;
    }

    protected void setStagingControls(PortletDataHandlerControl ... stagingControls) {
        this._stagingControls = stagingControls;
    }

    @Deprecated
    protected void setSupportsDataStrategyCopyAsNew(boolean supportsDataStrategyCopyAsNew) {
    }

    private PortletDataException _handleException(Exception e, int type, String portletId) {
        PortletDataException pde = null;
        pde = e instanceof PortletDataException ? (PortletDataException)e : new PortletDataException(e.getMessage(), (Throwable)e);
        if (Validator.isNull(pde.getPortletId())) {
            pde.setPortletId(portletId);
        }
        if (pde.getType() != 1) {
            return pde;
        }
        pde.setType(type);
        return pde;
    }
}

