/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.lang.builder.maven;

import com.liferay.lang.builder.LangBuilderArgs;
import com.liferay.lang.builder.LangBuilderInvoker;

import java.io.File;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Builds language property files.
 *
 * @author Andrea Di Giorgi
 * @goal build
 */
public class BuildLangMojo extends AbstractMojo {

	@Override
	public void execute() throws MojoExecutionException {
		try {
			LangBuilderInvoker.invoke(baseDir, _langBuilderArgs);
		}
		catch (Exception e) {
			throw new MojoExecutionException(e.getMessage(), e);
		}
	}

	/**
	 * @parameter
	 */
	public void setExcludedLanguageIds(String[] excludedLanguageIds) {
		_langBuilderArgs.setExcludedLanguageIds(excludedLanguageIds);
	}

	/**
	 * @parameter
	 */
	public void setLangDirName(String langDirName) {
		_langBuilderArgs.setLangDirName(langDirName);
	}

	/**
	 * @parameter
	 */
	public void setLangFileName(String langFileName) {
		_langBuilderArgs.setLangFileName(langFileName);
	}

	/**
	 * @parameter
	 */
	public void setPlugin(boolean plugin) {
		_langBuilderArgs.setPlugin(plugin);
	}

	/**
	 * @parameter
	 */
	public void setPortalLanguagePropertiesFileName(
		String portalLanguagePropertiesFileName) {

		_langBuilderArgs.setPortalLanguagePropertiesFileName(
			portalLanguagePropertiesFileName);
	}

	/**
	 * @parameter
	 */
	public void setTranslate(boolean translate) {
		_langBuilderArgs.setTranslate(translate);
	}

	/**
	 * @parameter
	 */
	public void setTranslateSubscriptionKey(String translateSubscriptionKey) {
		_langBuilderArgs.setTranslateSubscriptionKey(translateSubscriptionKey);
	}

	/**
	 * @parameter default-value="${project.basedir}"
	 * @readonly
	 */
	protected File baseDir;

	private final LangBuilderArgs _langBuilderArgs = new LangBuilderArgs();

}