/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.lang.builder;

import com.liferay.petra.string.CharPool;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.File;

/**
 * @author Andrea Di Giorgi
 */
public class LangBuilderInvoker {

	public static LangBuilder invoke(
			File baseDir, LangBuilderArgs langBuilderArgs)
		throws Exception {

		return new LangBuilder(
			langBuilderArgs.getExcludedLanguageIds(),
			_getAbsolutePath(baseDir, langBuilderArgs.getLangDirName()),
			langBuilderArgs.getLangFileName(), langBuilderArgs.isPlugin(),
			langBuilderArgs.getPortalLanguagePropertiesFileName(),
			langBuilderArgs.isTranslate(),
			langBuilderArgs.getTranslateSubscriptionKey());
	}

	private static String _getAbsolutePath(File baseDir, String fileName) {
		File file = new File(baseDir, fileName);

		return StringUtil.replace(
			file.getAbsolutePath(), CharPool.BACK_SLASH, CharPool.SLASH);
	}

}