/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.lang.builder;

/**
 * @author Andrea Di Giorgi
 */
public class LangBuilderArgs {

	public static final String[] EXCLUDED_LANGUAGE_IDS =
		{"da", "de", "fi", "ja", "nl", "pt_PT", "sv"};

	public static final String LANG_DIR_NAME = "src/content";

	public static final String LANG_FILE_NAME = "Language";

	public static final boolean PLUGIN = true;

	public static final boolean TRANSLATE = true;

	public String[] getExcludedLanguageIds() {
		return _excludedLanguageIds;
	}

	public String getLangDirName() {
		return _langDirName;
	}

	public String getLangFileName() {
		return _langFileName;
	}

	public String getPortalLanguagePropertiesFileName() {
		return _portalLanguagePropertiesFileName;
	}

	public String getTranslateSubscriptionKey() {
		return _translateSubscriptionKey;
	}

	public boolean isPlugin() {
		return _plugin;
	}

	public boolean isTranslate() {
		return _translate;
	}

	public void setExcludedLanguageIds(String[] excludedLanguageIds) {
		_excludedLanguageIds = excludedLanguageIds;
	}

	public void setLangDirName(String langDirName) {
		_langDirName = langDirName;
	}

	public void setLangFileName(String langFileName) {
		_langFileName = langFileName;
	}

	public void setPlugin(boolean plugin) {
		_plugin = plugin;
	}

	public void setPortalLanguagePropertiesFileName(
		String portalLanguagePropertiesFileName) {

		_portalLanguagePropertiesFileName = portalLanguagePropertiesFileName;
	}

	public void setTranslate(boolean translate) {
		_translate = translate;
	}

	public void setTranslateSubscriptionKey(String translateSubscriptionKey) {
		_translateSubscriptionKey = translateSubscriptionKey;
	}

	private String[] _excludedLanguageIds = EXCLUDED_LANGUAGE_IDS;
	private String _langDirName = LANG_DIR_NAME;
	private String _langFileName = LANG_FILE_NAME;
	private boolean _plugin = PLUGIN;
	private String _portalLanguagePropertiesFileName;
	private boolean _translate = TRANSLATE;
	private String _translateSubscriptionKey;

}